/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.migration;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DependencyPatternMigrationTest {
    @Test
    public void migrate() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/migration/11.1.0_report.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        ISystemInfoProcessor info = controller.createSystemInfoProcessor();
        List<IResolution> resolutions = info.getResolutions(null);
        Assert.assertEquals((String)"Wrong number of issues", (long)9L, (long)resolutions.size());
        IResolution fixmeArchViolation = resolutions.get(0);
        this.validateDependencyPatterns(fixmeArchViolation);
    }

    private void validateDependencyPatterns(IResolution fixmeArchViolation) {
        Assert.assertEquals((Object)"C11 -> C22", (Object)fixmeArchViolation.getDescription());
        List<IDependencyPattern> patterns = fixmeArchViolation.getDependencyPatterns();
        IDependencyPattern c11ToC22Unmodified = patterns.get(0);
        Assert.assertEquals((String)"Wrong from pattern", (Object)"Workspace:m1:./src:com:h2m:test:ignore:modified:changedMatches:C11.java:C11", (Object)c11ToC22Unmodified.getFromPattern());
        Assert.assertEquals((String)"Wrong to pattern", (Object)"Workspace:m1:./src:com:h2m:test:ignore:modified:changedMatches:C22.java:C22", (Object)c11ToC22Unmodified.getToPattern());
        IDependencyPattern c22ToC22Modified = patterns.get(1);
        Assert.assertEquals((String)"Wrong from pattern", (Object)"Workspace:m1:./src:com:h2m:test:ignore:modified:changedMatches:C11.java:C11:c22|f", (Object)c22ToC22Modified.getFromPattern());
        Assert.assertEquals((String)"Wrong to pattern", (Object)"Workspace:m1:./src:com:h2m:test:ignore:modified:changedMatches:C22.java:C22", (Object)c22ToC22Modified.getToPattern());
    }
}

