/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.controller;

import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ModuleInfoProcessorImpl;
import com.hello2morrow.sonargraph.integration.access.controller.SystemInfoProcessorImpl;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultCause;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.internal.ModuleImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.SoftwareSystemImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlReportReader;
import java.io.File;
import java.io.InputStream;
import java.util.Optional;

final class SonargraphSystemControllerImpl
implements ISonargraphSystemController {
    private SoftwareSystemImpl softwareSystem;

    @Override
    public Result loadSystemReport(File systemReportFile) {
        assert (systemReportFile != null) : "Parameter 'systemReportFile' of method 'loadSystemReport' must not be null";
        return this.innerLoadSystemReport(systemReportFile, null);
    }

    @Override
    public Result loadSystemReport(File systemReportFile, File baseDirectory) {
        assert (systemReportFile != null) : "Parameter 'systemReportFile' of method 'loadSystemReport' must not be null";
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'loadSystemReport' must not be null";
        assert (baseDirectory.exists() && baseDirectory.isDirectory()) : "Must be an existing directory: " + String.valueOf(baseDirectory);
        return this.innerLoadSystemReport(systemReportFile, baseDirectory);
    }

    @Override
    public Result loadSystemReport(InputStream systemReport, File baseDir) {
        assert (systemReport != null) : "Parameter 'systemReport' of method 'loadSystemReport' must not be null";
        assert (baseDir != null) : "Parameter 'baseDir' of method 'loadSystemReport' must not be null";
        XmlReportReader persistence = new XmlReportReader();
        Result result = new Result("Load data from inputStream");
        Optional<SoftwareSystemImpl> readResult = persistence.readReportFile(systemReport, baseDir, result);
        if (!readResult.isPresent() || result.isFailure()) {
            return result;
        }
        this.softwareSystem = readResult.get();
        return result;
    }

    private Result innerLoadSystemReport(File systemReportFile, File baseDir) {
        Result result = new Result("Load data from '" + systemReportFile.getAbsolutePath() + "'");
        if (!systemReportFile.exists()) {
            result.addError(ResultCause.FILE_NOT_FOUND);
        } else if (!systemReportFile.canRead()) {
            result.addError(ResultCause.NO_PERMISSION);
        }
        if (result.isFailure()) {
            return result;
        }
        XmlReportReader persistence = new XmlReportReader();
        Optional<SoftwareSystemImpl> readResult = persistence.readReportFile(systemReportFile, baseDir, result);
        if (!readResult.isPresent() || result.isFailure()) {
            return result;
        }
        this.softwareSystem = readResult.get();
        return result;
    }

    @Override
    public ISoftwareSystem getSoftwareSystem() {
        assert (this.softwareSystem != null) : "Software System must be loaded first with loadSystemReport()!";
        return this.softwareSystem;
    }

    @Override
    public IModuleInfoProcessor createModuleInfoProcessor(IModule module) {
        assert (module != null) : "Parameter 'module' of method 'createModuleInfoProcessor' must not be null";
        assert (module instanceof ModuleImpl) : "Unexpected class in method 'createModuleInfoProcessor': " + String.valueOf(module);
        return new ModuleInfoProcessorImpl(new SystemInfoProcessorImpl(this.softwareSystem), (ModuleImpl)module);
    }

    @Override
    public ISystemInfoProcessor createSystemInfoProcessor() {
        assert (this.softwareSystem != null) : "No software system available";
        return new SystemInfoProcessorImpl(this.softwareSystem);
    }

    @Override
    public boolean hasSoftwareSystem() {
        return this.softwareSystem != null;
    }
}

