/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;

public final class ValidationEventHandlerImpl
implements ValidationEventHandler {
    private final Result operationResult;

    public ValidationEventHandlerImpl(Result result) {
        assert (result != null) : "Parameter 'result' of method 'ValidationEventHandlerImpl' must not be null";
        this.operationResult = result;
    }

    public boolean handleEvent(ValidationEvent event) {
        assert (event != null) : "'event' must not be null";
        ValidationEventLocator locator = event.getLocator();
        this.operationResult.addWarning(ValidationMessageCauses.XML_VALIDATION_WARNING, event.getMessage() + ValidationEventHandlerImpl.getLocation(locator), new Object[0]);
        return true;
    }

    private static String getLocation(ValidationEventLocator locator) {
        if (locator != null) {
            StringBuilder builder = new StringBuilder(" (line:");
            builder.append(locator.getLineNumber());
            builder.append(" col:");
            builder.append(locator.getColumnNumber());
            builder.append(")");
            return builder.toString();
        }
        return "";
    }

    public static enum ValidationMessageCauses implements Result.ICause
    {
        XML_VALIDATION_WARNING,
        XML_VALIDATION_ERROR,
        NOT_SUPPORTED_ENUM_CONSTANT;


        @Override
        public String getStandardName() {
            return Utility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return Utility.convertConstantNameToPresentationName(this.name());
        }
    }
}

