/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IPhysicalElement;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import com.hello2morrow.sonargraph.integration.access.model.internal.PhysicalElementImpl;
import java.util.Optional;

public final class SourceFileImpl
extends PhysicalElementImpl
implements ISourceFile {
    private static final long serialVersionUID = -2940999235312739954L;
    private final String relativeRootDirectory;

    public SourceFileImpl(String kind, String presentationKind, String name, String presentationName, String fqName, boolean isLocationOnly, String relativeRootDirectory, String imageResourceName) {
        super(kind, presentationKind, name, presentationName, fqName, isLocationOnly, imageResourceName);
        assert (relativeRootDirectory != null && relativeRootDirectory.length() > 0) : "Parameter 'relativeRootDirectory' of method 'SourceFileImpl' must not be empty";
        this.relativeRootDirectory = relativeRootDirectory;
    }

    @Override
    public final String getRelativeRootDirectory() {
        return this.relativeRootDirectory;
    }

    @Override
    public String getRelativePath() {
        return this.getPresentationName();
    }

    @Override
    public Optional<ISourceFile> getOriginalLocation() {
        Optional<? extends IPhysicalElement> optOriginal = super.getOriginalLocation();
        if (optOriginal.isPresent()) {
            INamedElement original = optOriginal.get();
            assert (original != null && original instanceof ISourceFile) : "Unexpected class in method 'getOriginal': " + String.valueOf(original);
            return Optional.ofNullable((ISourceFile)original);
        }
        return Optional.empty();
    }

    @Override
    public void setOriginalLocation(PhysicalElementImpl physicalElementImpl) {
        assert (physicalElementImpl != null && physicalElementImpl instanceof SourceFileImpl) : "Unexpected class in method 'setOriginalLOcation': " + String.valueOf(physicalElementImpl);
        super.setOriginalLocation(physicalElementImpl);
    }

    @Override
    public String getIdentifyingPath() {
        return this.relativeRootDirectory + this.getRelativePath().substring(1);
    }

    @Override
    public String toString() {
        return super.toString() + "\nrelativeRootDirectory:" + this.relativeRootDirectory;
    }
}

