/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public final class ModuleInfoProcessorDuplicatesTest {
    @Test
    public void processDuplicateIssuesInSameFile() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/DuplicateInSameFileReport.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        Map<String, IModule> moduleMap = controller.getSoftwareSystem().getModules();
        IModule alarmClock = moduleMap.get("AlarmClock");
        Assert.assertNotNull((String)"Module 'AlarmClock' not found", (Object)alarmClock);
        IModuleInfoProcessor processor = controller.createModuleInfoProcessor(alarmClock);
        Map<ISourceFile, List<IIssue>> issueMap = processor.getIssuesForSourceFiles(issue -> issue.getIssueType().getName().equals("DuplicateCodeBlock"));
        Assert.assertNotNull(issueMap);
        Assert.assertEquals((long)2L, (long)issueMap.size());
        List<IIssue> duplicateIssues = null;
        for (Map.Entry<ISourceFile, List<IIssue>> next : issueMap.entrySet()) {
            if (!next.getKey().getName().endsWith("AlarmClock.java")) continue;
            duplicateIssues = next.getValue();
        }
        Assert.assertNotNull(duplicateIssues);
        Assert.assertEquals((String)"Wrong number of issues", (long)2L, (long)duplicateIssues.size());
    }
}

