/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class XmlPersistenceContext {
    private final Set<String> namespaces = new LinkedHashSet<String>();
    private final Set<URL> schemaUrls = new LinkedHashSet<URL>();

    public XmlPersistenceContext(String namespace, URL schemaUrl) {
        assert (namespace != null && namespace.length() > 0) : "Parameter 'namespace' of method 'XmlPersistenceContext' must not be empty";
        assert (schemaUrl != null) : "Parameter 'schemaUrl' of method 'XmlPersistenceContext' must not be null";
        this.namespaces.add(namespace);
        this.schemaUrls.add(schemaUrl);
    }

    public XmlPersistenceContext(XmlPersistenceContext persistenceContext) {
        assert (persistenceContext != null) : "Parameter 'persistenceContext' of method 'PersistenceContext' must not be null";
        this.namespaces.addAll(persistenceContext.getNamespaces());
        this.schemaUrls.addAll(persistenceContext.getSchemaUrls());
    }

    public void add(String namespace, URL schemaUrl) {
        assert (namespace != null && namespace.length() > 0) : "Parameter 'namespace' of method 'add' must not be empty";
        assert (schemaUrl != null) : "Parameter 'schemaUrl' of method 'add' must not be null";
        this.namespaces.add(namespace);
        this.schemaUrls.add(schemaUrl);
    }

    public void add(XmlPersistenceContext persistenceContext) {
        assert (persistenceContext != null) : "Parameter 'persistenceContext' of method 'add' must not be null";
        this.namespaces.addAll(persistenceContext.getNamespaces());
        this.schemaUrls.addAll(persistenceContext.getSchemaUrls());
    }

    public Set<String> getNamespaces() {
        return Collections.unmodifiableSet(this.namespaces);
    }

    public Set<URL> getSchemaUrls() {
        return Collections.unmodifiableSet(this.schemaUrls);
    }

    public String getNamespaceList() {
        if (this.namespaces.isEmpty()) {
            return "";
        }
        StringBuilder contextPath = new StringBuilder();
        for (String nextNamespace : this.namespaces) {
            contextPath.append(nextNamespace);
            contextPath.append(":");
        }
        contextPath.deleteCharAt(contextPath.length() - 1);
        return contextPath.toString();
    }
}

