/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IModuleDelta;
import com.hello2morrow.sonargraph.integration.access.model.IRootDirectory;
import java.util.Collections;
import java.util.List;

public final class ModuleDeltaImpl
implements IModuleDelta {
    private static final long serialVersionUID = 1127361649841021407L;
    private final IModule module;
    private final List<IRootDirectory> added;
    private final List<IRootDirectory> removed;

    public ModuleDeltaImpl(IModule module, List<IRootDirectory> added, List<IRootDirectory> removed) {
        assert (module != null) : "Parameter 'module' of method 'ModuleDeltaImpl' must not be null";
        assert (added != null) : "Parameter 'added' of method 'ModuleDeltaImpl' must not be null";
        assert (removed != null) : "Parameter 'removed' of method 'ModuleDeltaImpl' must not be null";
        this.module = module;
        this.added = added;
        this.removed = removed;
    }

    @Override
    public List<IRootDirectory> getAddedRootDirectories() {
        return Collections.unmodifiableList(this.added);
    }

    @Override
    public List<IRootDirectory> getRemovedRootDirectories() {
        return Collections.unmodifiableList(this.removed);
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public boolean isEmpty() {
        return this.added.isEmpty() && this.removed.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("   ").append("   ").append(this.module.getName()).append(" [").append(this.module.getLanguage()).append("]");
        builder.append("\n").append("   ").append("   ").append("   ").append("Added root directories (").append(this.added.size()).append(")");
        for (IRootDirectory next : this.added) {
            builder.append("\n").append("   ").append("   ").append("   ").append("   ").append(next.getRelativePath());
        }
        builder.append("\n").append("   ").append("   ").append("   ").append("Removed root directories (").append(this.removed.size()).append(")");
        for (IRootDirectory next : this.removed) {
            builder.append("\n").append("   ").append("   ").append("   ").append("   ").append(next.getRelativePath());
        }
        return builder.toString();
    }
}

