/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IFilterDelta;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IModuleDelta;
import com.hello2morrow.sonargraph.integration.access.model.IWorkspaceDelta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class WorkspaceDeltaImpl
implements IWorkspaceDelta {
    private static final long serialVersionUID = 412462604753552482L;
    private final List<IModuleDelta> changedModules = new ArrayList<IModuleDelta>();
    private final List<IModule> removedModules = new ArrayList<IModule>();
    private final List<IModule> addedModules = new ArrayList<IModule>();
    private IFilterDelta workspaceFileFilterDelta;
    private IFilterDelta productionCodeFilterDelta;
    private IFilterDelta issueFilterDelta;

    public void addRemovedModule(IModule module) {
        assert (module != null) : "Parameter 'module' of method 'addRemovedModule' must not be null";
        this.removedModules.add(module);
    }

    public void addAddedModule(IModule module) {
        assert (module != null) : "Parameter 'module' of method 'addAddedModule' must not be null";
        this.addedModules.add(module);
    }

    @Override
    public List<IModule> getAddedModules() {
        return Collections.unmodifiableList(this.addedModules);
    }

    @Override
    public List<IModule> getRemovedModules() {
        return Collections.unmodifiableList(this.removedModules);
    }

    @Override
    public List<IModuleDelta> getChangedModules() {
        return Collections.unmodifiableList(this.changedModules);
    }

    public void addChangedModule(IModuleDelta changedModule) {
        assert (changedModule != null) : "Parameter 'changedModule' of method 'addChangedModule' must not be null";
        this.changedModules.add(changedModule);
    }

    @Override
    public boolean isEmpty() {
        return this.removedModules.isEmpty() && this.addedModules.isEmpty() && this.changedModules.isEmpty() && this.workspaceFileFilterDelta.isEmpty() && this.productionCodeFilterDelta.isEmpty() && this.issueFilterDelta.isEmpty();
    }

    private String printModuleList(List<IModule> modules) {
        assert (modules != null) : "Parameter 'modules' of method 'printModuleList' must not be null";
        StringBuilder builder = new StringBuilder();
        for (IModule nextModule : modules) {
            builder.append("\n").append("   ").append("   ").append(nextModule.getName()).append(" [").append(nextModule.getLanguage()).append("]");
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append(this.workspaceFileFilterDelta);
        builder.append("\n").append(this.productionCodeFilterDelta);
        builder.append("\n").append(this.issueFilterDelta);
        builder.append("\n").append("   ").append("Added Modules (").append(this.addedModules.size()).append(")");
        builder.append(this.printModuleList(this.addedModules));
        builder.append("\n").append("   ").append("Removed Modules (").append(this.removedModules.size()).append(")");
        builder.append(this.printModuleList(this.removedModules));
        builder.append("\n").append("   ").append("Changed Modules (").append(this.changedModules.size()).append(")");
        for (IModuleDelta delta : this.changedModules) {
            builder.append("\n").append(delta);
        }
        return builder.toString();
    }

    public void setWorkspaceFileFilterDelta(IFilterDelta delta) {
        assert (delta != null) : "Parameter 'delta' of method 'setWorkspaceFileFilterDelta' must not be null";
        this.workspaceFileFilterDelta = delta;
    }

    @Override
    public IFilterDelta getWorkspaceFileFilterDelta() {
        return this.workspaceFileFilterDelta;
    }

    public void setProductionCodeFilterDelta(IFilterDelta delta) {
        assert (delta != null) : "Parameter 'delta' of method 'setProductionCodeFilterDelta' must not be null";
        this.productionCodeFilterDelta = delta;
    }

    @Override
    public IFilterDelta getProductionCodeFilterDelta() {
        return this.productionCodeFilterDelta;
    }

    public void setIssueFilterDelta(IFilterDelta delta) {
        assert (delta != null) : "Parameter 'delta' of method 'setIssueFilterDelta' must not be null";
        this.issueFilterDelta = delta;
    }

    @Override
    public IFilterDelta getIssueFilterDelta() {
        return this.issueFilterDelta;
    }
}

