/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.ISystemFile;
import com.hello2morrow.sonargraph.integration.access.model.SystemFileType;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementImpl;

public class SystemFileImpl
extends ElementImpl
implements ISystemFile {
    private static final long serialVersionUID = -7804519436007162975L;
    private final SystemFileType type;
    private final long lastModified;
    private final String hash;

    public SystemFileImpl(String path, SystemFileType type, long lastModified, String hash) {
        super(path, SystemFileImpl.extractPresentationName(path));
        assert (type != null) : "Parameter 'type' of method 'SystemFileImpl' must not be null";
        assert (hash != null) : "Parameter 'hash' of method 'SystemFileImpl' must not be null";
        this.type = type;
        this.lastModified = lastModified;
        this.hash = hash;
    }

    public SystemFileImpl(String path, SystemFileType type, long lastModified) {
        super(path, SystemFileImpl.extractPresentationName(path));
        assert (type != null) : "Parameter 'type' of method 'SystemFileImpl' must not be null";
        this.hash = null;
        this.type = type;
        this.lastModified = lastModified;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public SystemFileType getType() {
        return this.type;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    private static String extractPresentationName(String path) {
        assert (path != null) : "Parameter 'path' of method 'extractPresentationName' must not be null";
        int slashPos = path.lastIndexOf(47);
        if (slashPos > 0) {
            return path.substring(slashPos + 1, path.length());
        }
        return path;
    }
}

