/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IFilterDelta;
import com.hello2morrow.sonargraph.integration.access.model.IWildcardPattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilterDeltaImpl
implements IFilterDelta {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String presentationName;
    private final List<IWildcardPattern> addedIncludePatterns = new ArrayList<IWildcardPattern>(5);
    private final List<IWildcardPattern> removedIncludePatterns = new ArrayList<IWildcardPattern>(5);
    private final List<IWildcardPattern> addedExcludePatterns = new ArrayList<IWildcardPattern>(5);
    private final List<IWildcardPattern> removedExcludePatterns = new ArrayList<IWildcardPattern>(5);

    public FilterDeltaImpl(String name, String presentationName) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'FilterDeltaImpl' must not be empty";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'FilterDeltaImpl' must not be empty";
        this.name = name;
        this.presentationName = presentationName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public boolean isEmpty() {
        return this.addedIncludePatterns.isEmpty() && this.removedIncludePatterns.isEmpty() && this.addedExcludePatterns.isEmpty() && this.removedExcludePatterns.isEmpty();
    }

    public void removedIncludePattern(IWildcardPattern include) {
        assert (include != null) : "Parameter 'include' of method 'addRemovedIncludePatterns' must not be null";
        this.removedIncludePatterns.add(include);
    }

    @Override
    public List<IWildcardPattern> getRemovedIncludePatterns() {
        return Collections.unmodifiableList(this.removedIncludePatterns);
    }

    public void removedExcludePattern(IWildcardPattern exclude) {
        assert (exclude != null) : "Parameter 'exclude' of method 'addRemovedExcludePattern' must not be null";
        this.removedExcludePatterns.add(exclude);
    }

    @Override
    public List<IWildcardPattern> getRemovedExcludePatterns() {
        return Collections.unmodifiableList(this.removedExcludePatterns);
    }

    public void addedIncludePattern(IWildcardPattern include) {
        assert (include != null) : "Parameter 'include' of method 'addedIncludePattern' must not be null";
        this.addedIncludePatterns.add(include);
    }

    @Override
    public List<IWildcardPattern> getAddedIncludePatterns() {
        return Collections.unmodifiableList(this.addedIncludePatterns);
    }

    public void addedExcludePattern(IWildcardPattern exclude) {
        assert (exclude != null) : "Parameter 'exclude' of method 'addedExcludePattern' must not be null";
        this.addedExcludePatterns.add(exclude);
    }

    @Override
    public List<IWildcardPattern> getAddedExcludePatterns() {
        return Collections.unmodifiableList(this.addedExcludePatterns);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("   ").append(this.presentationName);
        this.addPatternsInfo(builder, this.addedIncludePatterns, "Added include patterns");
        this.addPatternsInfo(builder, this.removedIncludePatterns, "Removed include patterns");
        this.addPatternsInfo(builder, this.addedExcludePatterns, "Added exclude patterns");
        this.addPatternsInfo(builder, this.removedExcludePatterns, "Removed exclude patterns");
        return builder.toString();
    }

    private void addPatternsInfo(StringBuilder builder, List<IWildcardPattern> patterns, String description) {
        builder.append("\n").append("   ").append("   ").append(description).append(" (").append(patterns.size()).append(")");
        for (IWildcardPattern next : patterns) {
            builder.append("\n").append("   ").append("   ").append("   ").append(next.getPattern()).append(" (with ").append(next.getNumberOfMatches()).append(" matches)");
        }
    }
}

