/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.access.model.IIssueCategory;
import com.hello2morrow.sonargraph.integration.access.model.IIssueProvider;
import com.hello2morrow.sonargraph.integration.access.model.IIssueType;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetricProviderImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

abstract class AbstractExportMetaDataImpl
implements IExportMetaData {
    private static final long serialVersionUID = 1934927330602066004L;
    private final Map<String, IIssueCategory> issueCategories = new LinkedHashMap<String, IIssueCategory>();
    private final Map<String, IIssueProvider> issueProviders = new LinkedHashMap<String, IIssueProvider>();
    private final Map<String, IIssueType> issueTypes = new LinkedHashMap<String, IIssueType>();
    private final Map<String, IMetricCategory> metricCategories = new HashMap<String, IMetricCategory>();
    private final Map<String, IMetricProvider> metricProviders = new TreeMap<String, IMetricProvider>(new MetricProviderImpl.MetricProviderComparator());
    private final Map<String, IMetricLevel> metricLevels = new LinkedHashMap<String, IMetricLevel>();
    private final Map<String, IMetricId> metricIds = new HashMap<String, IMetricId>();
    private final String identifier;

    protected AbstractExportMetaDataImpl(String resourceIdentifier) {
        assert (resourceIdentifier != null && resourceIdentifier.length() > 0) : "Parameter 'resourceIdentifier' of method 'AbstractExportMetaDataImpl' must not be empty";
        this.identifier = resourceIdentifier;
    }

    public void addIssueCategory(IIssueCategory category) {
        assert (category != null) : "Parameter 'category' of method 'addIssueCategory' must not be null";
        assert (!this.issueCategories.containsKey(category.getName())) : "issueCategory '" + category.getName() + "' has already been added";
        this.issueCategories.put(category.getName(), category);
    }

    public void addIssueProvider(IIssueProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'addIssueProvider' must not be null";
        assert (!this.issueProviders.containsKey(provider.getName())) : "issueProvider '" + provider.getName() + "' has already been added";
        this.issueProviders.put(provider.getName(), provider);
    }

    public void addIssueType(IIssueType type) {
        assert (type != null) : "Parameter 'type' of method 'addIssueType' must not be null";
        assert (!this.issueTypes.containsKey(type.getName())) : "issueType '" + type.getName() + "' has already been added";
        this.issueTypes.put(type.getName(), type);
    }

    @Override
    public Map<String, IIssueCategory> getIssueCategories() {
        return Collections.unmodifiableMap(this.issueCategories);
    }

    @Override
    public Map<String, IIssueProvider> getIssueProviders() {
        return Collections.unmodifiableMap(this.issueProviders);
    }

    @Override
    public Map<String, IIssueType> getIssueTypes() {
        return Collections.unmodifiableMap(this.issueTypes);
    }

    @Override
    public Map<String, IMetricCategory> getMetricCategories() {
        LinkedHashMap result = new LinkedHashMap();
        this.metricCategories.values().stream().sorted(new IMetricCategory.MetricCategoryComparator()).forEach(c -> {
            IMetricCategory iMetricCategory = result.put(c.getName(), c);
        });
        return Collections.unmodifiableMap(result);
    }

    public void addMetricCategory(IMetricCategory category) {
        assert (category != null) : "Parameter 'category' of method 'addMetricCategory' must not be null";
        assert (!this.metricCategories.containsKey(category.getName())) : "category '" + category.getName() + "' has already been added";
        this.metricCategories.put(category.getName(), category);
    }

    public void addMetricLevel(IMetricLevel level) {
        assert (level != null) : "Parameter 'level' of method 'addMetricLevel' must not be null";
        assert (!this.metricLevels.containsKey(level.getName())) : "metric level '" + level.getName() + "' has already been added";
        this.metricLevels.put(level.getName(), level);
    }

    @Override
    public Map<String, IMetricLevel> getMetricLevels() {
        return Collections.unmodifiableMap(this.metricLevels);
    }

    @Override
    public List<IMetricId> getMetricIdsForLevel(IMetricLevel level) {
        assert (level != null) : "Parameter 'level' of method 'getMetricIdsForLevel' must not be null";
        List metrics = this.metricIds.values().stream().filter(m -> m.getLevels().contains(level)).collect(Collectors.toList());
        return Collections.unmodifiableList(metrics);
    }

    public void addMetricId(IMetricId metricId) {
        assert (metricId != null) : "Parameter 'metricId' of method 'addMetric' must not be null";
        assert (!this.metricIds.containsKey(metricId.getName())) : "metricId '" + metricId.getName() + "' has already been added";
        this.metricIds.put(metricId.getName(), metricId);
    }

    @Override
    public Map<String, IMetricId> getMetricIds() {
        return Collections.unmodifiableMap(this.metricIds);
    }

    @Override
    public Map<String, IMetricProvider> getMetricProviders() {
        return Collections.unmodifiableMap(this.metricProviders);
    }

    public void addMetricProvider(IMetricProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'addMetricProvider' must not be null";
        assert (!this.metricProviders.containsKey(provider.getName())) : "provider '" + provider.getName() + "' has already been added";
        this.metricProviders.put(provider.getName(), provider);
    }

    @Override
    public String getResourceIdentifier() {
        return this.identifier;
    }
}

