/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.foundation;

import java.io.Serializable;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 6387606412181055570L;
    final int major;
    final int minor;
    final int micro;
    final int build;

    public Version(int major, int minor, int micro, int build) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.build = build;
    }

    @Override
    public int compareTo(Version o) {
        int diff = this.major - o.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - o.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.micro - o.micro;
        if (diff != 0) {
            return diff;
        }
        diff = this.build - o.build;
        return diff;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.micro != version.micro) {
            return false;
        }
        return this.build == version.build;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.build;
        return result;
    }

    public String toString() {
        return String.format("%d.%d.%d.%d", this.major, this.minor, this.micro, this.build);
    }

    public String getVersionWithoutBuildNumber() {
        return String.format("%d.%d.%d", this.major, this.minor, this.micro);
    }

    public static Version fromString(String versionString) {
        assert (versionString != null) : "Parameter 'versionString' of method 'fromString' must not be null";
        String[] parts = versionString.split("\\.", 4);
        if (parts.length < 3) {
            throw new IllegalArgumentException("Version '" + versionString + "' does not match the expected format a.b.c");
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            int micro = Integer.parseInt(parts[2]);
            int build = parts.length == 4 ? Integer.parseInt(parts[3]) : 0;
            return new Version(major, minor, micro, build);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Version '" + versionString + "' does not match the expected format a.b.c.d", ex);
        }
    }
}

