/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.controller;

import com.hello2morrow.sonargraph.integration.access.controller.IMetaDataController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultCause;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.access.model.ISingleExportMetaData;
import com.hello2morrow.sonargraph.integration.access.model.internal.SingleExportMetaDataImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlExportMetaDataReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

final class MetaDataControllerImpl
implements IMetaDataController {
    MetaDataControllerImpl() {
    }

    @Override
    public ResultWithOutcome<IExportMetaData> loadExportMetaData(File exportMetaDataFile) {
        assert (exportMetaDataFile != null) : "Parameter 'exportMetaDataFile' of method 'loadExportMetaData' must not be null";
        ResultWithOutcome<IExportMetaData> result = new ResultWithOutcome<IExportMetaData>("Load meta-data from '" + String.valueOf(exportMetaDataFile) + "'");
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileInputStream inputStream = new FileInputStream(exportMetaDataFile);){
                ResultWithOutcome<IExportMetaData> loadExportMetaData = this.loadExportMetaData(inputStream, exportMetaDataFile.getCanonicalPath());
                result.addMessagesFrom(loadExportMetaData);
                result.setOutcome(loadExportMetaData.getOutcome());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            result.addError(ResultCause.FILE_NOT_FOUND, ex);
        }
        catch (IOException ex) {
            result.addError(ResultCause.IO_EXCEPTION, ex);
        }
        return result;
    }

    @Override
    public ResultWithOutcome<IExportMetaData> loadExportMetaData(InputStream inputStream, String identifier) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadExportMetaData' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'loadExportMetaData' must not be empty";
        ResultWithOutcome<IExportMetaData> result = new ResultWithOutcome<IExportMetaData>("Load data from stream");
        ResultWithOutcome<ISingleExportMetaData> readResult = MetaDataControllerImpl.internLoadExportMetaData(inputStream, identifier);
        result.addMessagesFrom(readResult);
        result.setOutcome(readResult.getOutcome());
        return result;
    }

    private static ResultWithOutcome<ISingleExportMetaData> internLoadExportMetaData(InputStream inputStream, String identifier) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadExportMetaData' must not be null";
        XmlExportMetaDataReader persistence = new XmlExportMetaDataReader();
        ResultWithOutcome<ISingleExportMetaData> result = new ResultWithOutcome<ISingleExportMetaData>("Load data from stream");
        Optional<SingleExportMetaDataImpl> readResult = persistence.readMetaDataFromStream(inputStream, identifier, result);
        if (!readResult.isPresent() && result.isSuccess()) {
            result.addError((Result.ICause)ResultCause.READ_ERROR, "Failed to read meta-data from stream", new Object[0]);
        }
        if (result.isFailure()) {
            return result;
        }
        if (readResult.isPresent()) {
            result.setOutcome(readResult.get());
        }
        return result;
    }
}

