/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.controller;

import com.hello2morrow.sonargraph.integration.access.controller.IInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IAnalyzer;
import com.hello2morrow.sonargraph.integration.access.model.IAnalyzerConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IFeature;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssueCategory;
import com.hello2morrow.sonargraph.integration.access.model.IIssueProvider;
import com.hello2morrow.sonargraph.integration.access.model.IIssueType;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.IMetricThreshold;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IPlugin;
import com.hello2morrow.sonargraph.integration.access.model.IPluginConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFile;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFileElement;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public interface ISystemInfoProcessor
extends IInfoProcessor {
    public ISoftwareSystem getSoftwareSystem();

    public List<IIssueProvider> getIssueProviders();

    public List<IIssueType> getIssueTypes();

    public List<ICycleGroupIssue> getCycleGroups(Predicate<ICycleGroupIssue> var1);

    public Optional<IMetricId> getMetricId(String var1);

    public List<IMetricId> getMetricIds();

    public List<IFeature> getFeatures();

    public List<IPlugin> getPlugins();

    public Map<String, IPluginConfiguration> getPluginConfigurations();

    public List<IAnalyzer> getAnalyzers();

    public List<String> getDuplicateCodeConfigurationEntries();

    public List<String> getScriptRunnerConfigurationEntries();

    public List<String> getArchitectureCheckConfigurationEntries();

    public List<IMetricCategory> getMetricCategories();

    public List<IMetricProvider> getMetricProviders();

    public boolean hasIssue(Predicate<IIssue> var1);

    public Map<String, IModule> getModules();

    public List<IIssueCategory> getIssueCategories();

    public List<IMetricThreshold> getMetricThresholds();

    public List<String> getElementKinds();

    public IModuleInfoProcessor createModuleInfoProcessor(IModule var1);

    public Map<String, IAnalyzerConfiguration> getAnalyzerConfigurations();

    public List<ISystemFile> getSystemFiles();

    public List<ISystemFileElement> getSystemFileElements();

    public static final class IIssueComparator
    implements Comparator<IIssue> {
        @Override
        public int compare(IIssue i1, IIssue i2) {
            assert (i1 != null) : "Parameter 'i1' of method 'compare' must not be null";
            assert (i2 != null) : "Parameter 'i2' of method 'compare' must not be null";
            if (i1 == i2) {
                return 0;
            }
            int compared = Integer.compare(i1.getLine(), i2.getLine());
            if (compared == 0 && (compared = Integer.compare(i1.getColumn(), i2.getColumn())) == 0 && (compared = i1.getName().compareToIgnoreCase(i2.getName())) == 0) {
                compared = Integer.compare(i1.hashCode(), i2.hashCode());
            }
            return compared;
        }
    }
}

