/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.issue;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CompositeIssueDiff;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;

public final class CycleGroupIssueDiff
extends CompositeIssueDiff<ICycleGroupIssue, CycleGroupIssue> {
    private String m_changeDetails;
    private final CycleChange m_cycleChange;

    public CycleGroupIssueDiff(NamedElement parent, ICycleGroupIssue baseline, CycleGroupIssue current, IDiffElement.Change change, CycleChange cycleChange) {
        super(parent, baseline, current, change);
        this.getChange();
        assert (cycleChange != null) : "Parameter 'cycleChange' of method 'CycleGroupIssueDiff' must not be null";
        this.m_cycleChange = cycleChange;
    }

    public CycleGroupIssueDiff(NamedElement parent, ICycleGroupIssue baseline, CycleGroupIssue current, IDiffElement.Change change, String changeDetails, CycleChange cycleChange) {
        super(parent, baseline, current, change);
        assert (changeDetails != null && changeDetails.length() > 0) : "Parameter 'changeDetails' of method 'CycleGroupIssueDiff' must not be empty";
        assert (cycleChange != null) : "Parameter 'cycleChange' of method 'CycleGroupIssueDiff' must not be null";
        this.m_changeDetails = changeDetails;
        this.getChange();
        this.m_cycleChange = cycleChange;
    }

    @Override
    public String getChangeDescription() {
        if (this.m_changeDetails != null) {
            return this.m_changeDetails;
        }
        return "";
    }

    public CycleChange getCycleChange() {
        return this.m_cycleChange;
    }

    public String getScope() {
        if (this.getCurrent() != null) {
            AnalyzerCycleGroup affectedElement;
            AnalyzerCycleGroup cycle = affectedElement = ((CycleGroupIssue)this.getCurrent()).getAffectedElement();
            return cycle.getScope().getPresentationName(true);
        }
        return ((ICycleGroupIssue)this.getBaseline()).getScope().getName();
    }

    public String getScopeImageResourceName() {
        if (this.getCurrent() != null) {
            AnalyzerCycleGroup affectedElement;
            AnalyzerCycleGroup cycle = affectedElement = ((CycleGroupIssue)this.getCurrent()).getAffectedElement();
            return cycle.getScope().getImageResourceName();
        }
        return ((ICycleGroupIssue)this.getBaseline()).getScope().getImageResourceName();
    }

    public int getNumberOfCyclicElements() {
        if (this.getCurrent() != null) {
            return this.getCurrentNumberOfCyclicElements();
        }
        return ((ICycleGroupIssue)this.getBaseline()).getAffectedNamedElements().size();
    }

    public int getNumberOfCyclicElementsDiff() {
        AnalyzerCycleGroup affectedElement;
        assert (this.getCurrent() != null && this.getBaseline() != null) : "Baseline and Current must both be non-null! baseline=" + String.valueOf(this.getBaseline()) + ", current=" + String.valueOf(this.getCurrent());
        AnalyzerCycleGroup cycle = affectedElement = ((CycleGroupIssue)this.getCurrent()).getAffectedElement();
        return cycle.getNumberOfCyclicElements() - ((ICycleGroupIssue)this.getBaseline()).getAffectedNamedElements().size();
    }

    public int getParserDependenciesDiff() {
        assert (this.getCurrent() != null && this.getBaseline() != null) : "Baseline and Current must both be non-null! baseline=" + String.valueOf(this.getBaseline()) + ", current=" + String.valueOf(this.getCurrent());
        AnalyzerCycleGroup cycle = ((CycleGroupIssue)this.getCurrent()).getAffectedElement();
        return cycle.getParserDependenciesToRemove() - ((ICycleGroupIssue)this.getBaseline()).getParserDependenciesToRemove();
    }

    private int getCurrentNumberOfCyclicElements() {
        AnalyzerCycleGroup affectedElement;
        AnalyzerCycleGroup cycle = affectedElement = ((CycleGroupIssue)this.getCurrent()).getAffectedElement();
        return cycle.getNumberOfCyclicElements();
    }

    @Override
    public String getImageResourceName() {
        return CycleGroup.class.getSimpleName();
    }

    @Property
    public int getCyclicElementsDiffAbsolute() {
        if (this.getBaseline() == null) {
            return this.getNumberOfCyclicElements();
        }
        if (this.getCurrent() == null) {
            return this.getNumberOfCyclicElements() * -1;
        }
        int baselineSize = ((ICycleGroupIssue)this.getBaseline()).getAffectedNamedElements().size();
        int currentSize = this.getCurrentNumberOfCyclicElements();
        return currentSize - baselineSize;
    }

    @Property
    public float getCyclicElementsDiffRelative() {
        if (this.getBaseline() == null) {
            return 1.0f;
        }
        if (this.getCurrent() == null) {
            return -1.0f;
        }
        int baselineSize = ((ICycleGroupIssue)this.getBaseline()).getAffectedNamedElements().size();
        int currentSize = this.getCurrentNumberOfCyclicElements();
        return ((float)currentSize - (float)baselineSize) / (float)baselineSize;
    }

    public static enum CycleChange {
        UNMODIFIED,
        ADDED,
        REMOVED,
        INTEGRATED,
        SPLIT,
        SEVERITY_CHANGED,
        PARSER_DEPENDENCIES_CHANGED,
        CYCLIC_ELEMENTS_CHANGED,
        CYCLIC_ELEMENTS_MODIFIED;

    }
}

