/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.MetricValue;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.util.List;
import java.util.stream.Collectors;

public final class MetricValueDiff
extends SimpleDiff<com.hello2morrow.sonargraph.integration.access.model.IMetricValue, IMetricValue> {
    private final String m_changeDescription;
    private final Number m_valueDiffAbsolute;
    private final Number m_valueDiffRelative;

    public MetricValueDiff(NamedElement parent, com.hello2morrow.sonargraph.integration.access.model.IMetricValue baseline, IMetricValue current, IDiffElement.Change change, Number valueDiffAbsolute, Number valueDiffRelative, String changeDescription) {
        super(parent, baseline, current, change);
        assert (valueDiffAbsolute != null) : "Parameter 'valueDiff' of method 'MetricValueDiff' must not be null";
        assert (valueDiffRelative != null) : "Parameter 'valueDiffRelative' of method 'MetricValueDiff' must not be null";
        this.m_valueDiffAbsolute = valueDiffAbsolute;
        this.m_valueDiffRelative = valueDiffRelative;
        this.m_changeDescription = changeDescription;
    }

    public MetricValueDiff(NamedElement parent, com.hello2morrow.sonargraph.integration.access.model.IMetricValue baseline, IMetricValue current, IDiffElement.Change change) {
        super(parent, baseline, current, change);
        assert (change != IDiffElement.Change.MODIFIED && change != IDiffElement.Change.IMPROVED && change != IDiffElement.Change.WORSENED) : "Change must not be of type modified, improved or worsened";
        this.m_valueDiffAbsolute = null;
        this.m_valueDiffRelative = null;
        this.m_changeDescription = null;
    }

    @Override
    public boolean providesChangeDescription() {
        return true;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        if (this.getCurrent() != null) {
            return ((IMetricValue)this.getCurrent()).getMetricDescriptor().getId();
        }
        StringBuilder namePart = new StringBuilder();
        namePart.append(((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)this.getBaseline()).getId().getProvider().getName());
        namePart.append(':');
        namePart.append(((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)this.getBaseline()).getLevel().getName());
        namePart.append(':');
        namePart.append(this.getShortName());
        return namePart.toString();
    }

    @Override
    public Element getCurrentElement() {
        return (Element)this.getCurrent();
    }

    @Property
    public String getId() {
        return this.getFullyQualifiedNamePart();
    }

    @Override
    @Property
    public String getChangeDescription() {
        if (this.m_changeDescription != null) {
            return this.m_changeDescription;
        }
        if (this.getChange() == IDiffElement.Change.UNMODIFIED) {
            return NumberUtility.format((Number)((IMetricValue)this.getCurrent()).getValue(), (boolean)true);
        }
        String baseline = this.getBaseline() != null ? NumberUtility.format((Number)((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)this.getBaseline()).getValue(), (boolean)true) : "";
        String current = this.getCurrent() != null ? NumberUtility.format((Number)((IMetricValue)this.getCurrent()).getValue(), (boolean)true) : "";
        return SystemDiffUtility.createChangeDetails(baseline, current, this.getChange());
    }

    @Property
    public Number getValueDiffAbsolute() {
        return this.m_valueDiffAbsolute;
    }

    @Property
    public Number getValueDiffRelative() {
        return this.m_valueDiffRelative;
    }

    @Override
    public String getShortName() {
        if (this.getCurrent() != null) {
            return ((IMetricValue)this.getCurrent()).getMetricDescriptor().getMetricId().getStandardName();
        }
        return ((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)this.getBaseline()).getId().getName();
    }

    @Override
    public String getImageResourceName() {
        return MetricValue.class.getSimpleName();
    }

    public String getMetricPresentationName() {
        if (this.getCurrent() != null) {
            return ((IMetricValue)this.getCurrent()).getMetricDescriptor().getShortName();
        }
        return ((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)this.getBaseline()).getId().getPresentationName();
    }

    public List<String> getCategoryPresentationNames() {
        if (this.getCurrent() != null) {
            return ((IMetricValue)this.getCurrent()).getMetricDescriptor().getMetricId().getCategories().stream().map(c -> c.getPresentationName()).collect(Collectors.toList());
        }
        return ((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)this.getBaseline()).getId().getCategories().stream().map(c -> c.getPresentationName()).collect(Collectors.toList());
    }

    public String getProviderPresentationName() {
        if (this.getCurrent() != null) {
            return ((IMetricValue)this.getCurrent()).getMetricDescriptor().getMetricId().getProvider().getPresentationName();
        }
        return ((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)this.getBaseline()).getId().getProvider().getPresentationName();
    }

    public static String getChangeDescription(MetricValueDiff diff, boolean reportAbsoluteDiff, boolean reportRelativeDiff) {
        StringBuilder result = new StringBuilder();
        if (diff.getChange() == IDiffElement.Change.WORSENED || diff.getChange() == IDiffElement.Change.UNMODIFIED || diff.getChange() == IDiffElement.Change.IMPROVED || diff.getChange() == IDiffElement.Change.MODIFIED) {
            result.append(NumberUtility.format((Number)((com.hello2morrow.sonargraph.integration.access.model.IMetricValue)diff.getBaseline()).getValue()));
            result.append(" -> ");
            result.append(NumberUtility.format((Number)((IMetricValue)diff.getCurrent()).getValue()));
            if (reportAbsoluteDiff) {
                result.append(" (");
                if (Float.compare(diff.getValueDiffAbsolute().floatValue(), 0.0f) >= 0) {
                    result.append("+");
                }
                result.append(NumberUtility.format((Number)diff.getValueDiffAbsolute()));
            }
            if (reportRelativeDiff) {
                if (reportAbsoluteDiff) {
                    result.append(", ");
                } else {
                    result.append(" (");
                }
                if (Float.compare(diff.getValueDiffRelative().floatValue(), 0.0f) >= 0) {
                    result.append("+");
                }
                result.append(NumberUtility.format((Number)Float.valueOf(diff.getValueDiffRelative().floatValue() * 100.0f))).append("%");
            }
            result.append(")");
            return result.toString();
        }
        return diff.getChangeDescription();
    }
}

