/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTargetScriptOutputStream
extends ScriptOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTargetScriptOutputStream.class);
    private final List<ScriptOutputStream> m_outputStreams;

    public MultiTargetScriptOutputStream(List<ScriptOutputStream> outputStreams) {
        assert (outputStreams != null && outputStreams.size() > 0) : "Parameter 'outputStreams' of method 'MultiTargetScriptOutputStream' must not be empty";
        this.m_outputStreams = outputStreams;
    }

    @Override
    public void println(Object message) {
        if (message == null) {
            return;
        }
        for (ScriptOutputStream out : this.m_outputStreams) {
            out.println(message);
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (ScriptOutputStream out : this.m_outputStreams) {
            try {
                out.write(b);
            }
            catch (IOException e) {
                LOGGER.error("Failed to write '" + (byte)b + " to output.", (Throwable)e);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        for (ScriptOutputStream out : this.m_outputStreams) {
            try {
                out.flush();
            }
            catch (IOException e) {
                LOGGER.error("Failed to flush output.", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (ScriptOutputStream out : this.m_outputStreams) {
            try {
                out.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close output.", (Throwable)e);
            }
        }
    }
}

