/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStream;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.InvalidPathException;

public class FileScriptOutputStream
extends ScriptOutputStream {
    private final PrintStream m_out;
    private final String m_filePath;

    public FileScriptOutputStream(String filePath) throws IOException {
        assert (filePath != null && filePath.length() > 0) : "Parameter 'filePath' of method 'FileScriptOutputStream' must not be empty";
        this.m_filePath = filePath;
        try {
            this.m_out = new PrintStream((File)new TFile(this.m_filePath));
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void println(Object message) {
        this.m_out.println(message);
    }

    @Override
    public void write(int b) throws IOException {
        this.m_out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.m_out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.m_out.close();
    }

    @Override
    public void flush() throws IOException {
        this.m_out.flush();
    }

    public String getFilePath() {
        return this.m_filePath;
    }
}

