/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.model.analysis.IHasMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.util.EnumSet;
import java.util.Set;

public final class ThresholdViolationIssue
extends NamedElementIssue
implements IHasMetricDescriptor {
    private final IProviderId m_issueProviderId;
    private final IMetricThreshold m_threshold;
    private final int m_lineNumber;
    private Number m_value;

    public ThresholdViolationIssue(NamedElement element, IProviderId issueProviderId, IMetricThreshold threshold, Number value, int lineNumber) {
        super(element);
        assert (issueProviderId != null) : "Parameter 'issueProviderId' of method 'ThresholdViolationIssue' must not be null";
        assert (threshold != null) : "Parameter 'threshold' of method 'ThresholdViolationIssue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'ThresholdViolationIssue' must not be null";
        this.m_issueProviderId = issueProviderId;
        this.m_threshold = threshold;
        this.m_value = value;
        this.m_lineNumber = lineNumber;
    }

    @Override
    public Severity getSeverity() {
        return this.m_threshold.getSeverity();
    }

    @Override
    public IIssueId getId() {
        return CoreIssueId.THRESHOLD_VIOLATION;
    }

    @Override
    public IProviderId getProvider() {
        return this.m_issueProviderId;
    }

    @Override
    public Set<AnalyzerGroup> getAdditionallyAffectedAnalyzerGroups() {
        return EnumSet.of(AnalyzerGroup.THRESHOLDS);
    }

    @Override
    public String getDescription() {
        return String.format("%s = %s (allowed range: %s to %s)", this.m_threshold.getMetricDescriptor().getShortName(), NumberUtility.format((Number)this.m_value), NumberUtility.format((Number)this.m_threshold.getLowerThreshold()), NumberUtility.format((Number)this.m_threshold.getUpperThreshold()));
    }

    public Number getValue() {
        return this.m_value;
    }

    public void setValue(Number value) {
        assert (value != null) : "Parameter 'value' of method 'setValue' must not be null";
        this.m_value = value;
    }

    @Override
    public String getKey() {
        return super.getKey() + ":" + this.m_threshold.getKey();
    }

    public IMetricThreshold getThreshold() {
        return this.m_threshold;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public IMetricDescriptor getMetricDescriptor() {
        return this.m_threshold.getMetricDescriptor();
    }
}

