/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class CreateFindingOperation
extends ArchitecturalViewOperation {
    private final String m_name;
    private final String m_description;
    private final boolean m_ignoreViolations;
    private final Set<String> m_parserDependencyDescriptors;

    public CreateFindingOperation(NamedElement parent, PresentationMode presentationMode, String name, String description, boolean ignoreViolations, Collection<String> parserDependencyDescriptors) {
        super(parent, presentationMode);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'CreateFindingOperation' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'CreateFindingOperation' must not be null";
        assert (parserDependencyDescriptors != null && !parserDependencyDescriptors.isEmpty()) : "Parameter 'parserDependencyDescriptors' of method 'CreateFindingOperation' must not be empty";
        this.m_name = name;
        this.m_description = description;
        this.m_ignoreViolations = ignoreViolations;
        this.m_parserDependencyDescriptors = new TreeSet<String>(parserDependencyDescriptors);
    }

    private CreateFindingOperation(NamedElement parent, CreateFindingOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'DeleteDependenciesOperation' must not be null";
        this.m_name = copyOf.m_name;
        this.m_description = copyOf.m_description;
        this.m_ignoreViolations = copyOf.m_ignoreViolations;
        this.m_parserDependencyDescriptors = new TreeSet<String>(copyOf.m_parserDependencyDescriptors);
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new CreateFindingOperation(parent, this);
    }

    @Override
    public String getImageResourceName() {
        return "ArchitecturalViewFinding";
    }

    @Override
    public String getShortName() {
        return "Create finding";
    }

    @Property
    public String getFindingName() {
        return this.m_name;
    }

    public boolean ignoreViolations() {
        return this.m_ignoreViolations;
    }

    @Property
    public String getFindingDescription() {
        return this.m_description;
    }

    public Set<String> getParserDependencyDescriptors() {
        return Collections.unmodifiableSet(this.m_parserDependencyDescriptors);
    }

    @Override
    public String getInformation() {
        return super.getInformation() + " Create finding '" + this.m_name + "' for " + this.m_parserDependencyDescriptors.size() + (this.m_parserDependencyDescriptors.size() == 1 ? " parser dependency" : " parser dependencies") + (this.m_ignoreViolations ? ", ignoring potential violations" : ", not ignoring potential violations");
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        executor.createFinding(this, this.m_name, this.m_description, this.m_ignoreViolations, this.m_parserDependencyDescriptors);
    }
}

