/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecturediagram;

import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public final class UmlComponentConnector
extends UmlComponentAnchor<Connector> {
    private final Set<Connector> m_includedConnectors = new THashSet();
    private final Set<UmlComponentConnector> m_includedByInfo;
    private final Set<UmlComponentConnector> m_includesInfo;

    public UmlComponentConnector(NamedElement parent, Connector connector, Comparator<UmlComponentAnchor<?>> comparator) {
        super(parent, connector);
        assert (comparator != null) : "Parameter 'comparator' of method 'UmlComponentConnector' must not be null";
        this.m_includedByInfo = new TreeSet(comparator);
        this.m_includesInfo = new TreeSet(comparator);
    }

    public UmlComponentConnector(NamedElement parent, Connector connector, boolean isPassThrough, Comparator<UmlComponentAnchor<?>> comparator) {
        super(parent, connector, isPassThrough);
        this.m_includedByInfo = new TreeSet(comparator);
        this.m_includesInfo = new TreeSet(comparator);
    }

    @Override
    public String getPresentationKind() {
        return "Connector";
    }

    public void addIncludedConnector(Connector connector) {
        assert (connector != null) : "Parameter 'connector' of method 'addIncludedConnector' must not be null";
        this.m_includedConnectors.add(connector);
    }

    public Set<Connector> getIncludedConnectors() {
        return Collections.unmodifiableSet(this.m_includedConnectors);
    }

    public Set<Interface> getConnectedToInterfaces() {
        return new THashSet(((Connector)this.getArchitectureElement()).getConnectedInterfaces());
    }

    public void addIncludedByInfo(UmlComponentConnector connector) {
        assert (connector != null) : "Parameter 'connector' of method 'addIncludedByInfo' must not be null";
        assert (this != connector) : "Same instances";
        this.m_includedByInfo.add(connector);
    }

    public Set<UmlComponentConnector> getIncludedByInfo() {
        return Collections.unmodifiableSet(this.m_includedByInfo);
    }

    public void addIncludesInfo(UmlComponentConnector connector) {
        assert (connector != null) : "Parameter 'connector' of method 'addIncludesInfo' must not be null";
        assert (this != connector) : "Same instances";
        this.m_includesInfo.add(connector);
    }

    public Set<UmlComponentConnector> getIncludesInfo() {
        return Collections.unmodifiableSet(this.m_includesInfo);
    }
}

