/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreDirectoryType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableDirectory;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IDirectoryType;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ArchitectureSubDirectory
extends ModifiableDirectory
implements ISoftwareSystemDefinitionElement,
IPhysicalArchitectureElement {
    public ArchitectureSubDirectory(NamedElement parent, TFile file, IModifiablePathListener listener) {
        super(parent, file, listener);
        this.getListener().created(this);
    }

    @Override
    public IDirectoryType getDirectoryType() {
        return CoreDirectoryType.ARCHITECTURE_SUB_DIRECTORY;
    }

    @Override
    public String getPresentationKind() {
        return "Architecture Directory";
    }

    @Override
    public List<String> getApplyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (IPhysicalArchitectureElement iPhysicalArchitectureElement : this.getContainedFileElements()) {
            result.addAll(iPhysicalArchitectureElement.getApplyNames());
        }
        return result;
    }

    @Override
    public Map<String, String> getNameChangeMap(String newName) {
        HashMap<String, String> nameChangeMap = new HashMap<String, String>();
        String oldPath = this.getIdentifyingPath();
        int lastSlashPos = oldPath.lastIndexOf("/");
        assert (lastSlashPos != -1);
        String newPath = oldPath.substring(0, lastSlashPos + 1) + newName;
        for (IPhysicalArchitectureElement iPhysicalArchitectureElement : this.getContainedFileElements()) {
            String filePath = iPhysicalArchitectureElement.getIdentifyingPath();
            assert (filePath.startsWith(oldPath));
            Object newApplyName = newPath + filePath.substring(oldPath.length());
            if (((String)newApplyName).startsWith("./")) {
                newApplyName = ((String)newApplyName).substring("./".length());
            }
            newApplyName = FileUtility.removeExtension((String)newApplyName);
            for (String applyName : iPhysicalArchitectureElement.getApplyNames()) {
                nameChangeMap.put(applyName, (String)newApplyName);
            }
        }
        return nameChangeMap;
    }

    @Override
    public Map<String, String> getNameChangeMapForMove(String newParentPath) {
        DirectoryPath parent;
        HashMap<String, String> nameChangeMap = new HashMap<String, String>();
        if (newParentPath.startsWith("./")) {
            newParentPath = newParentPath.substring("./".length());
        }
        Object oldParentPath = (parent = this.getParent(DirectoryPath.class, new Class[0])) instanceof Architecture ? "./" : parent.getIdentifyingPath() + "/";
        for (IPhysicalArchitectureElement iPhysicalArchitectureElement : this.getContainedFileElements()) {
            String filePath = iPhysicalArchitectureElement.getIdentifyingPath();
            assert (filePath.startsWith((String)oldParentPath));
            Object newApplyName = newParentPath + filePath.substring(((String)oldParentPath).length());
            newApplyName = FileUtility.removeExtension((String)newApplyName);
            for (String name : iPhysicalArchitectureElement.getApplyNames()) {
                nameChangeMap.put(name, (String)newApplyName);
            }
        }
        return nameChangeMap;
    }

    @Override
    public TFile getTargetFile(String newName) {
        return new TFile((File)this.getParent(DirectoryPath.class, new Class[0]).getFile(), newName);
    }

    @Override
    public List<? extends IPhysicalArchitectureElement> getContainedFileElements() {
        return this.getChildrenRecursively(ArchitectureFile.class, ArchitectureFile.class);
    }
}

