/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;

public final class SystemDiffAnalyzerConfiguration
extends AnalyzerConfiguration {
    public static final String BASELINE_PATH = "baselinePath";
    private static final String ENABLED = "enabled";
    static final IConfigurationCreator CREATOR = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new SystemDiffAnalyzerConfiguration(parent, analyzerId);
        }

        @Override
        public String getImageResourceName() {
            return "SystemDiffConfiguration";
        }
    };

    public SystemDiffAnalyzerConfiguration(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent, analyzerId);
        this.addValue(BASELINE_PATH, "");
        this.addValue(ENABLED, false);
    }

    private SystemDiffAnalyzerConfiguration(SystemDiffAnalyzerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public SystemDiffAnalyzerConfiguration copy() {
        return new SystemDiffAnalyzerConfiguration(this);
    }

    public void setBaselinePath(String baselinePath, boolean enabled) {
        assert (baselinePath != null) : "Parameter 'baselinePath' of method 'setBaselinePath' must not be null";
        assert (!enabled || !baselinePath.isEmpty()) : "Cannot enable empty baseline path";
        this.addValue(BASELINE_PATH, baselinePath.trim());
        this.addValue(ENABLED, enabled);
    }

    public String getBaselinePath() {
        String baselinePath = (String)this.getValue(BASELINE_PATH);
        return baselinePath != null ? baselinePath.trim() : "";
    }

    public void setEnabled(boolean enabled) {
        this.addValue(ENABLED, enabled);
    }

    public boolean isEnabled() {
        Boolean enabled = (Boolean)this.getValue(ENABLED);
        return enabled != null ? enabled : false;
    }
}

