/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorOrHeightValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ComponentAggregatorFloatValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ComponentMetricFloatValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.FloatMetricProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.FloatValueAdapter;
import com.hello2morrow.sonargraph.core.controller.system.treemap.SourceFileMetricFloatValueAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class ColorOrHeightFloatMetricValueAccessor
extends ColorOrHeightValueAccessor {
    private static final Map<TreeMapLeafElement, List<IMetricId>> SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS = new LinkedHashMap<TreeMapLeafElement, List<IMetricId>>();
    private static final Map<TreeMapLeafElement, List<IMetricId>> SUPPORTED_COMPONENT_LEVEL_METRIC_IDS = new LinkedHashMap<TreeMapLeafElement, List<IMetricId>>();
    private final Map<Float, FloatMetricProvider> m_valueToColorProvider = new THashMap();
    private final IMetricDescriptor m_metricDescriptor;
    private final FloatValueAdapter m_valueAdapter;

    static {
        SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_SOURCE_FILE, Arrays.asList(CoreMetricId.CORE_AVERAGE_NESTING, CoreMetricId.CORE_AVERAGE_COMPLEXITY, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricId.CORE_ISSUE_DENSITY));
        SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_COMPONENT, Arrays.asList(CoreMetricId.CORE_AVERAGE_NESTING, CoreMetricId.CORE_AVERAGE_COMPLEXITY, CoreMetricId.CORE_CODE_CHURN_RATE_30, CoreMetricId.CORE_CODE_CHURN_RATE_90, CoreMetricId.CORE_CODE_CHURN_RATE_365, CoreMetricId.CORE_CODE_CHURN_RATE_2Y, CoreMetricId.CORE_CODE_CHURN_RATE_5Y, CoreMetricId.CORE_ISSUE_DENSITY));
        SUPPORTED_COMPONENT_LEVEL_METRIC_IDS.put(TreeMapLeafElement.PHYSICAL_COMPONENT, Arrays.asList(CoreMetricId.CORE_COMPONENT_RANK_SYSTEM, CoreMetricId.CORE_COMPONENT_RANK_MODULE, CoreMetricId.CORE_ML_FAN_IN_MODULE, CoreMetricId.CORE_FAN_IN_SYSTEM, CoreMetricId.CORE_FAN_IN_MODULE, CoreMetricId.CORE_FAN_OUT_SYSTEM, CoreMetricId.CORE_FAN_OUT_MODULE, CoreMetricId.CORE_INSTABILITY_SYSYTEM, CoreMetricId.CORE_INSTABILITY_MODULE));
    }

    static Map<TreeMapLeafElement, List<IMetricId>> getSupportedSourceFileLevelMetricIds() {
        return Collections.unmodifiableMap(SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS);
    }

    static Map<TreeMapLeafElement, List<IMetricId>> getSupportedComponentLevelMetricIds() {
        return Collections.unmodifiableMap(SUPPORTED_COMPONENT_LEVEL_METRIC_IDS);
    }

    ColorOrHeightFloatMetricValueAccessor(IMetricAccessor metricAccessor, SoftwareSystem softwareSystem, IMetricDescriptor metricDescriptor, TreeMapLeafElement leafElement) {
        assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'ColorMetricFloatValueAccessor' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ColorMetricValueAccessor' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'ColorMetricValueAccessor' must not be null";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'ColorMetricValueAccessor' must not be null";
        this.m_metricDescriptor = metricDescriptor;
        IMetricId metricId = this.m_metricDescriptor.getMetricId();
        List<IMetricId> metricIds = SUPPORTED_SOURCE_FILE_LEVEL_METRIC_IDS.get((Object)leafElement);
        if (metricIds != null && !metricIds.isEmpty() && metricIds.contains(metricId)) {
            assert (metricId.isFloat()) : "Float metric expected";
            switch (leafElement) {
                case PHYSICAL_SOURCE_FILE: {
                    this.m_valueAdapter = new SourceFileMetricFloatValueAdapter(softwareSystem, metricAccessor, this.m_metricDescriptor);
                    break;
                }
                case PHYSICAL_COMPONENT: {
                    this.m_valueAdapter = new ComponentAggregatorFloatValueAdapter(new SourceFileMetricFloatValueAdapter(softwareSystem, metricAccessor, this.m_metricDescriptor));
                    break;
                }
                default: {
                    assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                    this.m_valueAdapter = null;
                }
            }
            return;
        }
        metricIds = SUPPORTED_COMPONENT_LEVEL_METRIC_IDS.get((Object)leafElement);
        if (metricIds != null && !metricIds.isEmpty() && metricIds.contains(metricId)) {
            assert (metricId.isFloat()) : "Float metric expected";
            switch (leafElement) {
                case PHYSICAL_SOURCE_FILE: {
                    assert (false) : "Unexpected leaf element: " + String.valueOf((Object)leafElement);
                    this.m_valueAdapter = null;
                    break;
                }
                case PHYSICAL_COMPONENT: {
                    this.m_valueAdapter = new ComponentMetricFloatValueAdapter(softwareSystem, metricAccessor, this.m_metricDescriptor);
                    break;
                }
                default: {
                    assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                    this.m_valueAdapter = null;
                }
            }
            return;
        }
        assert (false) : "Unhandled metric id: " + String.valueOf(metricId);
        this.m_valueAdapter = null;
    }

    @Override
    ILeafInfoProvider getInfoProvider(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getColorInfoProvider' must not be null";
        float value = this.m_valueAdapter.getValue(element);
        float forcedValue = value < 0.0f ? 0.0f : value;
        this.getValueRange().process(0, (int)Math.ceil(forcedValue));
        Float valueAsFloat = Float.valueOf(forcedValue);
        FloatMetricProvider provider = this.m_valueToColorProvider.get(valueAsFloat);
        if (provider == null) {
            provider = new FloatMetricProvider(this.m_metricDescriptor.getMetricId(), valueAsFloat);
            this.m_valueToColorProvider.put(valueAsFloat, provider);
        }
        return provider;
    }
}

