/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.remoting;

import com.hello2morrow.sonargraph.core.controller.system.remoting.RemoteSelectionClient;
import com.hello2morrow.sonargraph.core.model.remoting.IRemoteSelectionProvider;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteSelectionData;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleHttpServer
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpServer.class);
    private static final Set<String> LOCALHOSTS = Set.of("localhost", "127.0.0.1", "[::1]", "[0:0:0:0:0:0:0:1]");
    private static final String RESPONSE_BAD_REQUEST = "HTTP/1.1 400 Bad Request";
    private static final String RESPONSE_OK = "HTTP/1.1 200 OK";
    private static final String HOST = "host: ";
    private static final String NEW_LINE = "\r\n";
    private final IRemoteSelectionProvider m_remoteSelectionProvider;
    private final int m_port;
    private ServerSocket m_serverSocket;

    public SimpleHttpServer(IRemoteSelectionProvider service, int port) {
        super("HttpServer on port: " + port);
        assert (service != null) : "Parameter 'service' of method 'HttpServer' must not be null";
        assert (port > 0) : "Invalid port: " + port;
        this.m_remoteSelectionProvider = service;
        this.m_port = port;
    }

    private String decode(String message) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'decode' must not be empty";
        try {
            return URLDecoder.decode(message, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return message;
        }
    }

    private String createResponse(String response, String message) {
        assert (response != null && response.length() > 0) : "Parameter 'response' of method 'createResponse' must not be empty";
        StringBuilder builder = new StringBuilder();
        builder.append(response).append(NEW_LINE).append("Date: ").append(new Date()).append(NEW_LINE);
        if (message != null && !message.isEmpty()) {
            builder.append("Content-Length: ").append(message.length()).append(NEW_LINE);
            builder.append("Content-Type: text/plain").append(NEW_LINE);
        }
        builder.append("Connection: Closed");
        if (message != null && !message.isEmpty()) {
            builder.append(NEW_LINE).append(NEW_LINE).append(message);
        }
        return builder.toString();
    }

    private void handleRequest(String host, String message, Map<RemoteSelectionClient.Parameter, String> parameters, PrintStream writer) {
        String responseMessage;
        String response;
        ArrayList<RemoteSelectionData> selectionData;
        assert (host != null && host.length() > 0) : "Parameter 'host' of method 'handleRequest' must not be empty";
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'handleRequest' must not be empty";
        assert (parameters != null && !parameters.isEmpty()) : "Parameter 'parameters' of method 'handleRequest' must not be empty";
        assert (writer != null) : "Parameter 'writer' of method 'handleRequest' must not be null";
        if (!message.startsWith("GET /selection") || !message.endsWith(" HTTP/1.0") && !message.endsWith(" HTTP/1.1") && !message.endsWith(" HTTP/2.0")) {
            LOGGER.error("Message not supported: " + message);
            writer.print(this.createResponse(RESPONSE_BAD_REQUEST, null));
            writer.flush();
            return;
        }
        boolean isLocalhost = false;
        for (String next : LOCALHOSTS) {
            if (!host.startsWith(next)) continue;
            isLocalhost = true;
            break;
        }
        if (!isLocalhost) {
            LOGGER.error("Only requests from localhost allowed: " + host);
            writer.print(this.createResponse(RESPONSE_BAD_REQUEST, null));
            writer.flush();
            return;
        }
        String versionValue = parameters.get((Object)RemoteSelectionClient.Parameter.VERSION);
        if (versionValue == null) {
            LOGGER.error("Parameter '" + RemoteSelectionClient.Parameter.VERSION.getParameterName() + "' must be set.");
            writer.print(this.createResponse(RESPONSE_BAD_REQUEST, null));
            writer.flush();
            return;
        }
        Version version = Version.create((String)versionValue);
        if (version == null) {
            LOGGER.error("Parameter '" + RemoteSelectionClient.Parameter.VERSION.getParameterName() + "' has invalid value '" + versionValue + "'");
            writer.print(this.createResponse(RESPONSE_BAD_REQUEST, null));
            writer.flush();
            return;
        }
        String systemPath = parameters.get((Object)RemoteSelectionClient.Parameter.SYSTEM_PATH);
        if (systemPath == null || systemPath.isEmpty()) {
            LOGGER.error("Parameter '" + RemoteSelectionClient.Parameter.SYSTEM_PATH.getParameterName() + "' has invalid value '" + systemPath + "'");
            writer.print(this.createResponse(RESPONSE_BAD_REQUEST, null));
            writer.flush();
            return;
        }
        String multipleDescriptors = parameters.get((Object)RemoteSelectionClient.Parameter.MULTIPLE_DESCRIPTORS);
        String singleDescriptor = parameters.get((Object)RemoteSelectionClient.Parameter.SINGLE_DESCRIPTOR);
        if (multipleDescriptors != null) {
            String[] descriptors = this.decode(multipleDescriptors).split("!!;");
            selectionData = new ArrayList<RemoteSelectionData>(descriptors.length);
            String[] stringArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                String nextDescriptor = stringArray[n2];
                selectionData.add(new RemoteSelectionData(nextDescriptor, null, -1));
                ++n2;
            }
        } else if (singleDescriptor != null) {
            String path = parameters.get((Object)RemoteSelectionClient.Parameter.SOURCE);
            int line = -1;
            String lineValue = parameters.get((Object)RemoteSelectionClient.Parameter.LINE);
            if (lineValue != null) {
                try {
                    line = Integer.parseInt(lineValue);
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("Received invalid line number: {}", (Object)lineValue);
                }
            }
            selectionData = new ArrayList(1);
            selectionData.add(new RemoteSelectionData(this.decode(singleDescriptor), path, line));
        } else {
            LOGGER.error("Either parameter '" + RemoteSelectionClient.Parameter.MULTIPLE_DESCRIPTORS.getParameterName() + "' or '" + RemoteSelectionClient.Parameter.SINGLE_DESCRIPTOR.getParameterName() + "' must be provided.");
            writer.print(this.createResponse(RESPONSE_BAD_REQUEST, null));
            writer.flush();
            return;
        }
        OperationResult result = this.m_remoteSelectionProvider.handleSelection(version, systemPath, selectionData);
        if (result.containsError()) {
            response = RESPONSE_BAD_REQUEST;
            responseMessage = result.toString();
            LOGGER.error(responseMessage);
        } else if (result.containsWarning()) {
            response = RESPONSE_OK;
            responseMessage = result.toString();
            LOGGER.warn(responseMessage);
        } else {
            response = RESPONSE_OK;
            responseMessage = null;
        }
        writer.print(this.createResponse(response, responseMessage));
        writer.flush();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void shutDown() throws Exception {
        if (this.m_serverSocket != null) {
            this.m_serverSocket.close();
            this.m_serverSocket = null;
            this.join();
        }
    }
}

