/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodesInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CreateArtifactFromElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CreateArtifactsForElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.DeleteElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.DependencyHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.EditArtifactResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.EditArtifactsChangesDetector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.EditArtifactsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewLogger;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FindingHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.SetPresentationModeVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureHandler;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeConnection;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteElementsOperationType;
import com.hello2morrow.sonargraph.core.model.explorationview.ExpandSelectInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementInfo;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class OperationHandler
implements IExplorationViewRepresentationHandler {
    private OperationHandler() {
    }

    private static DeleteElementsOperationType getDeleteElementsOperationType(ArchitecturalViewNodesInfo info, boolean assignablesOnly) {
        assert (info != null) : "Parameter 'info' of method 'getDeleteElementsOperationType' must not be null";
        Set<ArtifactNode> artifactNodes = info.getArtifacts();
        Set<AssignableNode> assignableNodes = info.getAssignables();
        if (!assignablesOnly || artifactNodes.isEmpty() && !assignableNodes.isEmpty()) {
            if (!artifactNodes.isEmpty() && assignableNodes.isEmpty()) {
                return DeleteElementsOperationType.DELETE;
            }
            if (artifactNodes.isEmpty() && !assignableNodes.isEmpty()) {
                boolean allDeletable = true;
                for (AssignableNode next : assignableNodes) {
                    if (StructureHandler.isDeleteRefactoringPossible(next)) continue;
                    allDeletable = false;
                    break;
                }
                if (allDeletable) {
                    return DeleteElementsOperationType.DELETE_REFACTORING;
                }
            }
        }
        return DeleteElementsOperationType.NONE;
    }

    public static DeleteElementsOperationType isOpDeleteElementsPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements, boolean assignablesOnly) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpDeleteElementsPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isOpDeleteElementsPossible' must not be empty";
        return OperationHandler.getDeleteElementsOperationType(NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements), assignablesOnly);
    }

    public static DeleteElementsResult opDeleteElements(PresentationMode presentationMode, List<ArchitecturalViewElement> elements, boolean assignablesOnly, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opDeleteElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'opDeleteElements' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opDeleteElements' must not be null";
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        DeleteElementsOperationType type = OperationHandler.getDeleteElementsOperationType(info, assignablesOnly);
        assert (type != null && type != DeleteElementsOperationType.NONE) : "Delete not possible";
        ExplorationViewLogger.logOpElementBased("Delete Elements", presentationMode, type.toString(), elements, representation);
        LinkedHashSet<ArchitecturalViewNode> parents = null;
        if (!representation.inModification()) {
            parents = new LinkedHashSet<ArchitecturalViewNode>();
            Set<ArchitecturalViewNode> nodes = info.getNodes();
            for (ArchitecturalViewNode next : nodes) {
                ArchitecturalViewNode nextNodeParent = next.getNodeParent();
                if (nextNodeParent == null) continue;
                parents.add(nextNodeParent);
                assert (!nodes.contains(nextNodeParent)) : "Parent contained in nodes: " + nextNodeParent.getElementInfo();
            }
        }
        RepresentationHandler.aboutToChangeStructure(false, representation);
        RepresentationHandler.removeAggregatedDependencies(false, representation);
        ExplorationViewFocus focus = FocusHandler.startOperation(representation);
        switch (type) {
            case DELETE: {
                ArtifactHandler.deleteArtifacts(info.getArtifacts(), representation);
                break;
            }
            case DELETE_REFACTORING: {
                StructureHandler.delete(presentationMode, info.getAssignables(), representation);
                break;
            }
            case NONE: {
                assert (false) : "Delete elements not possible";
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + String.valueOf((Object)type);
                break;
            }
        }
        if (parents != null) {
            for (ArchitecturalViewNode next : parents) {
                if (!next.isExpanded() || next.isExpandable()) continue;
                next.setExpanded(false);
            }
        }
        FilterHandler.finishFilterUpdate(representation);
        ArtifactHandler.finishArtifactModelModification(false, representation);
        RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        FocusHandler.finishOperation(focus, representation);
        RepresentationHandler.createAggregatedDependencies(false, representation);
        RepresentationHandler.structureChanged(false, false, representation);
        return new DeleteElementsResult(info.getRelativePaths(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changePresentationMode(PresentationMode presentationMode, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'changePresentationMode' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'changePresentationMode' must not be null";
        assert (!representation.getPresentationMode().equals((Object)presentationMode)) : "Presentation mode already set to: " + String.valueOf((Object)presentationMode);
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            String msg = ExplorationViewLogger.logInteraction("Change presentation mode to '" + String.valueOf((Object)presentationMode) + "'", null, representation);
            RepresentationHandler.aboutToChangeStructure(false, representation);
            RepresentationHandler.removeAggregatedDependencies(false, representation);
            ExplorationViewFocus focus = FocusHandler.startOperation(representation);
            representation.accept(new SetPresentationModeVisitor(presentationMode));
            ArchitecturalViewNodeInfo nodeInfo = RepresentationHandler.finishElementStructure(representation);
            RepresentationHandler.sortNodes((IWorkerContext)DefaultWorkerContext.INSTANCE, nodeInfo.getLeafNodes(), representation);
            FocusHandler.finishOperation(focus, representation);
            NodeHandler.applySelectionAndExpansionState(nodeInfo.getSelectedNodes(), nodeInfo.getExpandedNodes(), representation);
            RepresentationHandler.createAggregatedDependencies(false, representation);
            RepresentationHandler.structureChanged(false, false, representation);
            ExplorationViewLogger.logDone(msg, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeSortMode(ExplorationViewSortMode mode, ExplorationViewRepresentation representation) {
        assert (mode != null) : "Parameter 'mode' of method 'changeSortMode' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'changeSortMode' must not be null";
        assert (!representation.getSortMode().equals((Object)mode)) : "Sort mode already set to: " + String.valueOf((Object)mode);
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            String msg = ExplorationViewLogger.logInteraction("Change sort mode to '" + String.valueOf((Object)mode) + "'", null, representation);
            RepresentationHandler.aboutToChangeStructure(false, representation);
            RepresentationHandler.removeAggregatedDependencies(false, representation);
            ExplorationViewFocus focus = FocusHandler.startOperation(representation);
            representation.setSortMode(mode);
            ArchitecturalViewNodeInfo nodeInfo = RepresentationHandler.finishElementStructure(representation);
            RepresentationHandler.sortNodes((IWorkerContext)DefaultWorkerContext.INSTANCE, nodeInfo.getLeafNodes(), representation);
            FocusHandler.finishOperation(focus, representation);
            NodeHandler.applySelectionAndExpansionState(nodeInfo.getSelectedNodes(), nodeInfo.getExpandedNodes(), representation);
            RepresentationHandler.createAggregatedDependencies(false, representation);
            RepresentationHandler.structureChanged(false, false, representation);
            ExplorationViewLogger.logDone(msg, null);
        }
    }

    public static boolean isOpHideElementsPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpHideElementsPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isOpHideElementsPossible' must not be empty";
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        Set<ArtifactNode> artifactNodes = info.getArtifacts();
        Set<AssignableNode> assignableNodes = info.getAssignables();
        if (artifactNodes.isEmpty() && !assignableNodes.isEmpty()) {
            for (AssignableNode next : assignableNodes) {
                if (next.getFirstUnderlyingElement() instanceof RootDirectoryPath) {
                    return false;
                }
                if (next.isHidden()) {
                    return false;
                }
                ArtifactNode nextArtifactNode = next.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
                if (nextArtifactNode != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<String> opHideElements(PresentationMode presentationMode, List<ArchitecturalViewElement> elements, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opHideElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'opHideElements' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opHideElements' must not be null";
        assert (OperationHandler.isOpHideElementsPossible(presentationMode, elements)) : "Hide elements not possible";
        ExplorationViewLogger.logOpElementBased("Hide Elements", presentationMode, "", elements, representation);
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        assert (info.getNumberOfNodes() > 0) : "Info is empty";
        HideVisitor hideVisitor = new HideVisitor();
        for (AssignableNode nextNode : info.getAssignables()) {
            assert (!nextNode.isHidden()) : "Already hidden: " + nextNode.getElementInfo();
            ArtifactNode nextArtifactNode = nextNode.getParent(ArtifactNode.class, ExplorationViewRepresentation.class);
            assert (nextArtifactNode != null) : "'nextArtifactNode' of method 'hideElements' must not be null";
            nextArtifactNode.setHasHiddenElements(true);
            RecursiveNode nextRecursiveNode = NodeHandler.recursively(nextNode, presentationMode);
            if (nextRecursiveNode == null) {
                nextNode.accept(hideVisitor);
                continue;
            }
            nextRecursiveNode.getChildren(NonRecursiveNode.class).forEach(n -> n.accept(hideVisitor));
        }
        RepresentationHandler.updateAggregatedDependencies(representation);
        return info.getRelativePaths();
    }

    static void finishProgramminElementNodeCreation(List<ProgrammingElementNode> created, ExplorationViewRepresentation representation) {
        assert (created != null) : "Parameter 'created' of method 'finishProgramminElementNodeCreation' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'finishProgramminElementNodeCreation' must not be null";
        if (!created.isEmpty() && !representation.inModification()) {
            for (ProgrammingElementNode next : created) {
                ArchitecturalViewNode nextParent = next.getNodeParent();
                assert (nextParent != null) : "'nextParent' of method 'finishProgramminElementNodeCreation' must not be null";
                if (!nextParent.isHidden()) continue;
                next.setHidden(true);
            }
        }
    }

    public static boolean isOpMoveElementsPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements, boolean assignablesOnly) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpMoveElementsPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isOpMoveElementsPossible' must not be empty";
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        if (assignablesOnly ? info.getNumberOfArtifacts() == 0 && info.getNumberOfAssignables() > 0 : info.getNumberOfNodes() > 0) {
            if (info.getRepresentation().hasChildren(false, ArtifactNode.class)) {
                return true;
            }
            for (AssignableNode nextNode : info.getAssignables()) {
                if (!StructureHandler.isMoveRefactoringPossible(nextNode)) continue;
                return true;
            }
        }
        return false;
    }

    public static MoveElementsInfo isOpMoveElementsTargetPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements, MovableTargetInfo targetInfo) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpMoveElementsTargetPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isOpMoveElementsTargetPossible' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'isOpMoveElementsTargetPossible' must not be null";
        ArchitecturalViewNodesInfo elementsInfo = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        MoveElementsInfo moveElementsInfo = new MoveElementsInfo(elementsInfo.getRepresentation(), targetInfo);
        if (elementsInfo.getNumberOfArtifacts() > 0) {
            ArtifactHandler.isMoveToTargetPossible(elementsInfo.getArtifacts(), moveElementsInfo);
        }
        if (elementsInfo.getNumberOfAssignables() > 0) {
            StructureHandler.isMoveToTargetPossible(elementsInfo.getAssignables(), moveElementsInfo, new FilterHandler.AssignmentToArtifactCheck(), elementsInfo.getRepresentation());
        }
        return moveElementsInfo;
    }

    public static PartialAlternativeInfo calculatePartialMoveElementsAlternative(List<? extends ArchitecturalViewElement> elements, boolean assignablesOnly) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'calculatePartialMoveElementsAlternative' must not be empty";
        PresentationMode presentationMode = elements.get(0).getPresentationMode();
        assert (OperationHandler.isOpMoveElementsPossible(presentationMode, elements, assignablesOnly)) : "Move elements not possible";
        PartialAlternativeInfo alternativeInfo = RepresentationHandler.calculatePartialAlternativeInfo(NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements).getNodes(), Collections.singletonList(ArtifactNode.class));
        assert (alternativeInfo == null || OperationHandler.isOpMoveElementsPossible(presentationMode, alternativeInfo.getAlternativeNodes(), assignablesOnly)) : "Move elements must be possible with partial altrnative";
        return alternativeInfo;
    }

    public static PartialAlternativeInfo calculatePartialCreateArtifactFromElementsAlternative(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'calculatePartialCreateArtifactFromElementsAlternative' must not be empty";
        PresentationMode presentationMode = elements.get(0).getPresentationMode();
        ArchitecturalViewArtifactOperationAvailability availability = OperationHandler.isOpCreateArtifactFromElementsPossible(presentationMode, elements);
        assert (availability.isAvailable()) : "Create not possible";
        PartialAlternativeInfo alternativeInfo = RepresentationHandler.calculatePartialAlternativeInfo(NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements).getNodes(), Collections.singletonList(ArtifactNode.class));
        assert (alternativeInfo == null || OperationHandler.isOpCreateArtifactFromElementsPossible(presentationMode, alternativeInfo.getAlternativeNodes()).isAvailable()) : "Create artifact must be possible with partial altrnative";
        return alternativeInfo;
    }

    public static PartialAlternativeInfo calculatePartialCreateArtifactsForElementsAlternative(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'calculatePartialCreateArtifactsForElementsAlternative' must not be empty";
        PresentationMode presentationMode = elements.get(0).getPresentationMode();
        ArchitecturalViewArtifactOperationAvailability availability = OperationHandler.isOpCreateArtifactsForElementsPossible(presentationMode, elements);
        assert (availability.isAvailable()) : "Create not possible";
        PartialAlternativeInfo alternativeInfo = RepresentationHandler.calculatePartialAlternativeInfo(NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements).getNodes(), Collections.singletonList(ArtifactNode.class));
        assert (alternativeInfo == null || OperationHandler.isOpCreateArtifactsForElementsPossible(presentationMode, alternativeInfo.getAlternativeNodes()).isAvailable()) : "Create artifacts must be possible with partial altrnative";
        return alternativeInfo;
    }

    public static MoveElementsInfo opMoveElements(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements, MovableTargetInfo targetInfo) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opMoveElements' must not be null";
        MoveElementsInfo moveElementsInfo = OperationHandler.isOpMoveElementsTargetPossible(presentationMode, elements, targetInfo);
        assert (moveElementsInfo != null && moveElementsInfo.isApplicable()) : "Move not possible: " + String.valueOf(moveElementsInfo);
        ExplorationViewRepresentation representation = moveElementsInfo.getRepresentation();
        ArchitecturalViewElement target = moveElementsInfo.getTargetInfo().getTarget();
        ExplorationViewLogger.logOp("Move Elements", presentationMode, moveElementsInfo.toString(), representation);
        RepresentationHandler.aboutToChangeStructure(false, representation);
        RepresentationHandler.removeAggregatedDependencies(false, representation);
        ExplorationViewFocus focus = FocusHandler.startOperation(representation);
        ExpandSelectInfo expandSelectInfo = null;
        if (moveElementsInfo.hasArtifactsToMove()) {
            assert (target instanceof IAssignableTarget) : "Unexpected class in method 'opMoveElements': " + String.valueOf(target);
            ArtifactHandler.move(moveElementsInfo.getArtifactsToToMove(), (IAssignableTarget)((Object)target), moveElementsInfo.getTargetInfo().getRelativeIndex(), representation);
        }
        if (moveElementsInfo.hasAssignablesToAssign()) {
            StructureHandler.assign(presentationMode, moveElementsInfo.getAssignablesToAssign(), StructureHandler.getAssignableTargetForAssign(target), representation);
        }
        if (moveElementsInfo.hasAssignablesToRefactor()) {
            assert (target instanceof ArchitecturalViewNode) : "Unexpected class in method 'opMoveElements': " + String.valueOf(target);
            expandSelectInfo = StructureHandler.move(presentationMode, moveElementsInfo.getAssignablesToRefactor(), (ArchitecturalViewNode)target, moveElementsInfo, representation);
        }
        FilterHandler.finishFilterUpdate(representation);
        ArtifactHandler.finishArtifactModelModification(false, representation);
        RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        FocusHandler.finishOperation(focus, representation);
        if (expandSelectInfo != null && !representation.inModification()) {
            NodeHandler.expandParentChainOf(expandSelectInfo.getExpandParentsOf(), null, representation, false);
            NodeHandler.select(expandSelectInfo.getSelect(), true, representation);
        }
        RepresentationHandler.createAggregatedDependencies(false, representation);
        RepresentationHandler.structureChanged(false, true, representation);
        return moveElementsInfo;
    }

    public static List<ParserDependency> isOpDeleteDependenciesPossible(PresentationMode presentationMode, ArchitecturalViewNode from, boolean fromIsAggregated, ArchitecturalViewNode to, boolean toIsAggregated, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpDeleteDependenciesPossible' must not be null";
        assert (from != null) : "Parameter 'from' of method 'isOpDeleteDependenciesPossible' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isOpDeleteDependenciesPossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isOpDeleteDependenciesPossible' must not be null";
        String msg = ExplorationViewLogger.logInteraction("Collect parser dependencies for deletion", null, representation);
        List<ParserDependency> parserDependencies = DependencyHandler.isDeleteDependenciesPossible(presentationMode, from, fromIsAggregated, to, toIsAggregated, representation);
        ExplorationViewLogger.logDone(msg, null);
        return parserDependencies;
    }

    public static ExplorationViewRepresentation isOpDeleteDependenciesPossible(PresentationMode presentationMode, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpDeleteDependenciesPossible' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'isOpDeleteDependenciesPossible' must not be empty";
        THashSet froms = new THashSet();
        for (ArchitecturalViewNode.ArchitecturalViewDependency next : dependencies) {
            assert (!next.getParserDependencies().isEmpty()) : "Does not contain any parser dependencies: " + String.valueOf(next);
            assert (!next.isExternal()) : "'next' is external: " + next.getFrom().getElementInfo();
            froms.add(next.getFrom());
        }
        return RepresentationHandler.getRepresentation((Collection<? extends IArchitecturalViewElement>)froms);
    }

    public static void opDeleteParserDependencies(PresentationMode presentationMode, Set<ParserDependency> dependencies, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opDeleteParserDependencies' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'opDeleteParserDependencies' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opDeleteParserDependencies' must not be null";
        ExplorationViewLogger.logOpParserDependencyBased("Delete Parser Dependencies", presentationMode, "", dependencies, representation);
        RepresentationHandler.aboutToChangeStructure(false, representation);
        RepresentationHandler.removeAggregatedDependencies(false, representation);
        StructureHandler.delete(presentationMode, dependencies, representation);
        RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        RepresentationHandler.createAggregatedDependencies(false, representation);
        RepresentationHandler.structureChanged(false, false, representation);
    }

    public static List<ArchitecturalViewDependencyDescriptor> opDeleteDependencies(PresentationMode presentationMode, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opDeleteDependencies' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'opDeleteDependencies' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opDeleteDependencies' must not be null";
        assert (representation == OperationHandler.isOpDeleteDependenciesPossible(presentationMode, dependencies)) : "Dependencies not deletable: " + String.valueOf(dependencies);
        ArrayList<ArchitecturalViewDependencyDescriptor> descriptors = new ArrayList<ArchitecturalViewDependencyDescriptor>(dependencies.size());
        Set<ParserDependency> all = DependencyHandler.aboutToDelete(dependencies, descriptors);
        OperationHandler.opDeleteParserDependencies(presentationMode, all, representation);
        return descriptors;
    }

    public static void operationCreatedAndApplied(ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (findingList != null) : "Parameter 'findingList' of method 'operationCreatedAndApplied' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'operationCreatedAndApplied' must not be null";
        FindingHandler.updateFindings(findingList, representation);
    }

    public static ExplorationViewRepresentation isOpCreateFindingPossible(PresentationMode presentationMode, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpCreateFindingPossible' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'isOpCreateFindingPossible' must not be empty";
        return FindingHandler.isCreateFindingPossible(presentationMode, dependencies);
    }

    public static ArchitecturalViewFindingProperties createFindingProperties(PresentationMode presentationMode, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, ArchitecturalViewOperationList operationList, ArchitecturalViewFindingList findingList) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createFindingProperties' must not be null";
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'createFindingProperties' must not be empty";
        assert (operationList != null) : "Parameter 'operationList' of method 'createFindingProperties' must not be null";
        assert (findingList != null) : "Parameter 'findingList' of method 'createFindingProperties' must not be null";
        ExplorationViewRepresentation representation = OperationHandler.isOpCreateFindingPossible(presentationMode, dependencies);
        assert (representation != null) : "Create finding properties not possible";
        return FindingHandler.createFindingProperties(presentationMode, dependencies, operationList, findingList, representation);
    }

    static Set<ParserDependency> opCreateFinding(PresentationMode presentationMode, String name, String description, boolean ignoreViolations, Set<String> parserDependencyDescriptors, ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opDeleteParserDependencies' must not be null";
        assert (parserDependencyDescriptors != null && !parserDependencyDescriptors.isEmpty()) : "Parameter 'parserDependencyDescriptors' of method 'opDeleteParserDependencies' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opDeleteParserDependencies' must not be null";
        ExplorationViewLogger.logOp("Create Finding", presentationMode, "", parserDependencyDescriptors, representation);
        return FindingHandler.createFinding(presentationMode, name, description, ignoreViolations, parserDependencyDescriptors, findingList, representation);
    }

    public static List<String> createFinding(PresentationMode presentationMode, ArchitecturalViewFindingProperties properties, ArchitecturalViewFindingList findingList, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createFinding' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'createFinding' must not be null";
        assert (findingList != null) : "Parameter 'findingList' of method 'createFinding' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createFinding' must not be null";
        assert (representation == OperationHandler.isOpCreateFindingPossible(presentationMode, properties.getDependencies())) : "Create finding not possible: " + String.valueOf(properties);
        ExplorationViewLogger.logOpDependencyBased("Create Finding", presentationMode, "", properties.getDependencies(), representation);
        return FindingHandler.createFinding(presentationMode, properties, findingList, representation);
    }

    public static ArchitecturalViewOperation getCorrespondingOperation(ArchitecturalViewFinding finding) {
        assert (finding != null) : "Parameter 'finding' of method 'getCorrespondingOperation' must not be null";
        return FindingHandler.getCorrespondingOperation(finding);
    }

    public static ArtifactNodeConnection isOpCreateAllowedArtifactConnectionPossible(PresentationMode presentationMode, ArchitecturalViewElement from, ArchitecturalViewElement to) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpCreateAllowedArtifactConnectionPossible' must not be null";
        assert (from != null) : "Parameter 'from' of method 'isOpCreateAllowedArtifactConnectionPossible' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isOpCreateAllowedArtifactConnectionPossible' must not be null";
        return ArtifactHandler.isCreateAllowedArtifactConnectionPossible(from, to);
    }

    public static void opCreateAllowedArtifactConnection(PresentationMode presentationMode, ArtifactNodeConnection dependency, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createAllowedArtifactConnection' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'createAllowedArtifactConnection' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createAllowedArtifactConnection' must not be null";
        ExplorationViewLogger.logOp("Create Allowed Artifact Connection", presentationMode, dependency.toString(), representation);
        ArtifactHandler.createAllowedArtifactConnection(dependency, representation);
    }

    public static ArchitecturalViewArtifactOperationAvailability isEditArtifactsPossible(PresentationMode presentationMode, List<ArtifactNode> artifacts) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isEditArtifactsPossible' must not be null";
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'isEditArtifactsPossible' must not be empty";
        return ArtifactHandler.isEditArtifactsPossible(artifacts);
    }

    public static String getSingleNameProposal(IAssignableTarget parent, List<? extends ArchitecturalViewElement> elements, PresentationMode presentationMode) {
        assert (parent != null) : "Parameter 'parent' of method 'getSingleNameProposal' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getSingleNameProposal' must not be empty";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getSingleNameProposal' must not be null";
        return ArtifactHandler.getSingleNameProposal(parent, elements, presentationMode);
    }

    public static ArchitecturalViewArtifactOperationAvailability isOpCreateArtifactPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpCreateArtifactPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isOpCreateArtifactPossible' must not be empty";
        return ArtifactHandler.isCreateArtifactPossible(presentationMode, elements);
    }

    public static ArtifactNode opCreateArtifact(PresentationMode presentationMode, IAssignableTarget assignableTarget, int relativeIndex, String name, ArtifactProperties properties, ArtifactNodeFilter filter, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opCreateArtifact' must not be null";
        assert (assignableTarget != null) : "Parameter 'assignableTarget' of method 'opCreateArtifact' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'opCreateArtifact' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'opCreateArtifact' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'opCreateArtifact' must not be null";
        assert (FilterHandler.isFilterValid(filter) == null) : "Not a valid filter: " + String.valueOf(filter);
        assert (representation != null) : "Parameter 'representation' of method 'opCreateArtifact' must not be null";
        assert (OperationHandler.isOpCreateArtifactPossible(presentationMode, Collections.singletonList(assignableTarget.getArchitecturalViewElement())).isAvailable()) : "Create not possible";
        boolean hasManualFilter = !filter.isEmpty();
        ExplorationViewLogger.logOp("Create Artifact", presentationMode, "'" + name + "' " + (hasManualFilter ? "Manual Filter" : ""), representation);
        RepresentationHandler.aboutToChangeStructure(false, representation);
        ExplorationViewFocus focus = null;
        if (hasManualFilter) {
            RepresentationHandler.removeAggregatedDependencies(false, representation);
            focus = FocusHandler.startOperation(representation);
        }
        ArtifactNode createdArtifact = ArtifactHandler.createArtifact(assignableTarget, relativeIndex, name, properties, filter, representation);
        if (hasManualFilter) {
            createdArtifact.getFilter().setIsManual(true);
            FilterHandler.finishFilterUpdate(createdArtifact, representation);
            ArtifactHandler.finishArtifactModelModification(false, representation);
            RepresentationHandler.finishElementStructureAfterOperationApply(representation);
            FocusHandler.finishOperation(focus, representation);
            RepresentationHandler.createAggregatedDependencies(false, representation);
        } else {
            createdArtifact.getFilter().setIsManual(false);
            ArtifactHandler.finishArtifactModelModification(false, representation);
            RepresentationHandler.finishArtifactCreation(representation);
            RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        }
        if (!representation.inModification()) {
            assignableTarget.getArchitecturalViewElement().setSelected(false);
            createdArtifact.setSelected(true);
        }
        RepresentationHandler.structureChanged(false, true, representation);
        return createdArtifact;
    }

    public static ArchitecturalViewArtifactOperationAvailability isOpCreateArtifactFromElementsPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpCreateArtifactFromElementsPossible' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isOpCreateArtifactFromElementsPossible' must not be empty";
        return ArtifactHandler.isCreateArtifactFromElementsPossible(presentationMode, elements);
    }

    public static CreateArtifactFromElementsResult opCreateArtifactFromElements(PresentationMode presentationMode, IAssignableTarget assignableTarget, int relativeTargetIndex, String name, ArtifactProperties properties, List<ArchitecturalViewElement> elements, ExplorationViewRepresentation representation) {
        Set<AssignableNode> assignables;
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opCreateArtifactFromElements' must not be null";
        assert (assignableTarget != null) : "Parameter 'assignableTarget' of method 'opCreateArtifactFromElements' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'opCreateArtifactFromElements' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'opCreateArtifactFromElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'opCreateArtifactFromElements' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opCreateArtifactFromElements' must not be null";
        assert (OperationHandler.isOpCreateArtifactFromElementsPossible(presentationMode, elements).isAvailable()) : "Create artifact from elements not possible";
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, elements);
        assert (info.getNumberOfNodes() > 0) : "Create  artifact from elements not possible: " + String.valueOf(info);
        ExplorationViewLogger.logOp("Create Artifact From Elements", presentationMode, "'" + name + "'" + String.valueOf(elements), representation);
        RepresentationHandler.aboutToChangeStructure(false, representation);
        RepresentationHandler.removeAggregatedDependencies(false, representation);
        ExplorationViewFocus focus = FocusHandler.startOperation(representation);
        ArtifactNode createdArtifact = ArtifactHandler.createArtifact(assignableTarget, relativeTargetIndex, name, properties, new ArtifactNodeFilter(null), representation);
        Set<ArtifactNode> artifacts = info.getArtifacts();
        if (!artifacts.isEmpty()) {
            ArtifactHandler.move(artifacts, createdArtifact, -1, representation);
        }
        if (!(assignables = info.getAssignables()).isEmpty()) {
            StructureHandler.assign(presentationMode, assignables, createdArtifact, representation);
        }
        FilterHandler.finishFilterUpdate(representation);
        ArtifactHandler.finishArtifactModelModification(false, representation);
        RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        FocusHandler.finishOperation(focus, representation);
        if (!representation.inModification()) {
            assignableTarget.getArchitecturalViewElement().setSelected(false);
            createdArtifact.setExpanded(true);
            RepresentationHandler.collapse(createdArtifact, representation);
            createdArtifact.setSelected(true);
        }
        RepresentationHandler.createAggregatedDependencies(false, representation);
        RepresentationHandler.structureChanged(false, true, representation);
        return new CreateArtifactFromElementsResult(true, info.getRelativePaths(), createdArtifact);
    }

    public static EditArtifactResult opEditArtifact(PresentationMode presentationMode, ArtifactNode artifact, AssignableTargetInfo targetInfo, String shortName, ArtifactProperties properties, ArtifactNodeFilter filter, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opEditArtifact' must not be null";
        assert (artifact != null) : "Parameter 'artifact' of method 'opEditArtifact' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'opEditArtifact' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'opEditArtifact' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'opEditArtifact' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'opEditArtifact' must not be null";
        assert (FilterHandler.isFilterValid(filter) == null) : "Not a valid filter: " + String.valueOf(filter);
        assert (representation != null) : "Parameter 'representation' of method 'opEditArtifact' must not be null";
        EditArtifactsChangesDetector detector = new EditArtifactsChangesDetector(artifact, targetInfo, shortName, properties, filter);
        if (detector.hasChanges()) {
            ExplorationViewLogger.logOp("Edit Artifact", presentationMode, detector.toString(), representation);
            String relativePath = artifact.getRelativePath();
            ExplorationViewFocus focus = null;
            if (detector.parentOrRelativeParentPositionChanged() || detector.filterChanged()) {
                RepresentationHandler.aboutToChangeStructure(false, representation);
                RepresentationHandler.removeAggregatedDependencies(false, representation);
                focus = FocusHandler.startOperation(representation);
            }
            if (artifact.setShortName(shortName)) {
                RepresentationHandler.resetRelativePath(artifact);
            }
            artifact.setArtifactProperties(properties);
            if (detector.parentOrRelativeParentPositionChanged() || detector.filterChanged()) {
                if (detector.parentOrRelativeParentPositionChanged()) {
                    ArtifactHandler.move(Collections.singleton(artifact), targetInfo.getTarget(), targetInfo.getRelativeIndex(), representation);
                    ArchitecturalViewNode parentNode = artifact.getNodeParent();
                    NodeHandler.updateExpandableState(parentNode, representation);
                }
                if (detector.filterChanged()) {
                    FilterHandler.finishFilterOperation(detector.getFilterOperation(), artifact, filter, representation);
                }
                FilterHandler.finishFilterUpdate(representation);
                if (detector.parentChanged()) {
                    NodeHandler.expandParentChainOf(Collections.singletonList(artifact), null, representation, false);
                }
                ArtifactHandler.finishArtifactModelModification(false, representation);
                RepresentationHandler.finishElementStructureAfterOperationApply(representation);
                FocusHandler.finishOperation(focus, representation);
                RepresentationHandler.createAggregatedDependencies(false, representation);
                RepresentationHandler.structureChanged(false, true, representation);
            } else {
                ArtifactHandler.finishArtifactModelModification(false, representation);
                RepresentationHandler.updateAggregatedDependencies(representation);
            }
            return new EditArtifactResult(detector.parentOrRelativeParentPositionChanged() || detector.filterChanged(), relativePath, detector.getFilterOperation());
        }
        return null;
    }

    public static boolean editArtifactsHasChanges(List<ArtifactNode> artifacts, AssignableTargetInfo targetInfo, ArtifactProperties properties) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'editArtifactsHasChanges' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'editArtifactsHasChanges' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'editArtifactsHasChanges' must not be null";
        return new EditArtifactsChangesDetector(artifacts, targetInfo, properties).hasChanges();
    }

    public static EditArtifactsResult opEditArtifacts(PresentationMode presentationMode, List<ArtifactNode> artifacts, AssignableTargetInfo targetInfo, ArtifactProperties properties, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opEditArtifacts' must not be null";
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'opEditArtifacts' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'opEditArtifacts' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'opEditArtifacts' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'opEditArtifacts' must not be null";
        assert (OperationHandler.isEditArtifactsPossible(presentationMode, artifacts).isAvailable()) : "Edit artifacts not possible";
        EditArtifactsChangesDetector detector = new EditArtifactsChangesDetector(artifacts, targetInfo, properties);
        if (detector.hasChanges()) {
            ExplorationViewLogger.logOp("Edit Artifacts", presentationMode, detector.toString(), representation);
            ArrayList<String> relativePaths = new ArrayList<String>(artifacts.size());
            artifacts.forEach(a -> {
                boolean bl = relativePaths.add(a.getRelativePath());
            });
            assert (!detector.filterChanged()) : "Unexpected filter change: " + String.valueOf(detector);
            if (detector.parentOrRelativeParentPositionChanged()) {
                RepresentationHandler.aboutToChangeStructure(false, representation);
                RepresentationHandler.removeAggregatedDependencies(false, representation);
                ExplorationViewFocus focus = FocusHandler.startOperation(representation);
                ArtifactHandler.setArtifactProperties(artifacts, properties);
                ArtifactHandler.move(artifacts, targetInfo.getTarget(), targetInfo.getRelativeIndex(), representation);
                FilterHandler.finishFilterUpdate(representation);
                ArtifactHandler.finishArtifactModelModification(false, representation);
                RepresentationHandler.finishElementStructureAfterOperationApply(representation);
                FocusHandler.finishOperation(focus, representation);
                NodeHandler.expandParentChainOf(Collections.singletonList(artifacts.get(0)), null, representation, false);
                RepresentationHandler.createAggregatedDependencies(false, representation);
                RepresentationHandler.structureChanged(false, true, representation);
            } else {
                ArtifactHandler.setArtifactProperties(artifacts, properties);
                ArtifactHandler.finishArtifactModelModification(false, representation);
                RepresentationHandler.updateAggregatedDependencies(representation);
            }
            return new EditArtifactsResult(detector.parentOrRelativeParentPositionChanged(), relativePaths);
        }
        return null;
    }

    public static ArchitecturalViewArtifactOperationAvailability isOpCreateArtifactsForElementsPossible(PresentationMode presentationMode, List<? extends ArchitecturalViewElement> elements) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpCreateArtifactsForElementsPossible' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'isOpCreateArtifactsForElementsPossible' must not be null";
        return ArtifactHandler.isCreateArtifactsForElementsPossible(presentationMode, elements);
    }

    public static CreateArtifactsForElementsResult opCreateArtifactsForElements(PresentationMode presentationMode, IAssignableTarget assignableTarget, int relativeIndex, ArtifactProperties properties, List<ArchitecturalViewElement> basedOn, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opCreateArtifactsForElements' must not be null";
        assert (assignableTarget != null) : "Parameter 'assignableTarget' of method 'opCreateArtifactsForElements' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'opCreateArtifactsForElements' must not be null";
        assert (basedOn != null && !basedOn.isEmpty()) : "Parameter 'basedOn' of method 'opCreateArtifactsForElements' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opCreateArtifactsForElements' must not be null";
        assert (OperationHandler.isOpCreateArtifactsForElementsPossible(presentationMode, basedOn).isAvailable()) : "Create artifacts for elements not possible";
        ExplorationViewLogger.logOpElementBased("Create Artifact For Elements", presentationMode, "", basedOn, representation);
        RepresentationHandler.aboutToChangeStructure(false, representation);
        RepresentationHandler.removeAggregatedDependencies(false, representation);
        ExplorationViewFocus focus = FocusHandler.startOperation(representation);
        ArchitecturalViewNodesInfo info = NodeHandler.createArchitecturalViewNodesInfo(presentationMode, basedOn, false);
        assert (info.getNumberOfNodes() > 0) : "Create artifacts for elements not possible: " + String.valueOf(info);
        Set<AssignableNode> assignables = info.getAssignables();
        assert (assignables != null && !assignables.isEmpty()) : "'assignables' of method 'opCreateArtifactsForElements' must not be empty";
        assert (info.getArtifacts().isEmpty()) : "No artifacts expected";
        List<String> names = ArtifactHandler.getMultipleNameProposals(assignableTarget, assignables, presentationMode);
        ArrayList<ArtifactNode> createdArtifacts = new ArrayList<ArtifactNode>(names.size());
        int index = 0;
        for (AssignableNode nextAssignable : assignables) {
            ArtifactNode nextCreatedArtifact = ArtifactHandler.createArtifact(assignableTarget, relativeIndex + index, names.get(index), properties, new ArtifactNodeFilter(null), representation);
            StructureHandler.assign(presentationMode, Collections.singletonList(nextAssignable), nextCreatedArtifact, representation);
            createdArtifacts.add(nextCreatedArtifact);
            ++index;
        }
        FilterHandler.finishFilterUpdate(representation);
        ArtifactHandler.finishArtifactModelModification(false, representation);
        RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        FocusHandler.finishOperation(focus, representation);
        if (!representation.inModification()) {
            assignableTarget.getArchitecturalViewElement().setSelected(false);
            createdArtifacts.forEach(a -> a.setExpanded(true));
            createdArtifacts.forEach(a -> RepresentationHandler.collapse(a, representation));
            createdArtifacts.forEach(a -> a.setSelected(true));
        }
        RepresentationHandler.createAggregatedDependencies(false, representation);
        RepresentationHandler.structureChanged(false, true, representation);
        return new CreateArtifactsForElementsResult(true, info.getRelativePaths(), createdArtifacts);
    }

    public static RecursiveElementCreationInfo isOpCreateElementPossible(PresentationMode presentationMode, ArchitecturalViewElement element) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpCreateElementPossible' must not be null";
        assert (element != null) : "Parameter 'element' of method 'isCreateElementPossible' must not be null";
        return StructureHandler.isCreateElementPossible(element);
    }

    public static ArchitecturalViewNode opCreateElement(PresentationMode presentationMode, RecursiveElementCreationInfo creationInfo, String name, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opCreateElement' must not be null";
        assert (creationInfo != null) : "Parameter 'creationInfo' of method 'opCreateElement' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'opCreateElement' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opCreateElement' must not be null";
        ExplorationViewLogger.logOp("Create Element", presentationMode, "'" + name + "' underneath " + creationInfo.getValidator().getRootNode().getElementInfo(), representation);
        RepresentationHandler.aboutToChangeStructure(false, representation);
        RepresentationHandler.removeAggregatedDependencies(false, representation);
        RecursiveNode leafNode = StructureHandler.createRecursiveElement(creationInfo, name, representation);
        RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        NodeHandler.expandParentChainOf(Collections.singletonList(leafNode), true, representation, false);
        RepresentationHandler.createAggregatedDependencies(false, representation);
        RepresentationHandler.structureChanged(false, true, representation);
        return leafNode;
    }

    public static RenameElementInfo isOpRenameElementPossible(PresentationMode presentationMode, ArchitecturalViewElement element, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isOpRenameElementPossible' must not be null";
        assert (element != null) : "Parameter 'element' of method 'isOpRenameElementPossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isOpRenameElementPossible' must not be null";
        return StructureHandler.isRenamePossible(element, representation);
    }

    public static RenameElementInfo opRenameElement(PresentationMode presentationMode, ArchitecturalViewElement element, String name, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'opRenameElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'opRenameElement' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'opRenameElement' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'opRenameElement' must not be null";
        RenameElementInfo renameElementInfo = OperationHandler.isOpRenameElementPossible(presentationMode, element, representation);
        assert (renameElementInfo != null) : "'renameElementInfo' of method 'opRenameElement' must not be null";
        assert (renameElementInfo.getValidator().isValid(null, name).isSuccess()) : "Not a valid name: " + name;
        ExplorationViewLogger.logOp("Rename Element", presentationMode, "'" + element.getElementInfo() + "' to '" + name + "'", representation);
        RepresentationHandler.aboutToChangeStructure(false, representation);
        RepresentationHandler.removeAggregatedDependencies(false, representation);
        ExplorationViewFocus focus = FocusHandler.startOperation(representation);
        RenameElementInfo info = StructureHandler.rename(presentationMode, element, name, representation);
        FilterHandler.finishFilterUpdate(representation);
        ArtifactHandler.finishArtifactModelModification(false, representation);
        RepresentationHandler.finishElementStructureAfterOperationApply(representation);
        FocusHandler.finishOperation(focus, representation);
        RepresentationHandler.createAggregatedDependencies(false, representation);
        RepresentationHandler.structureChanged(false, true, representation);
        return info;
    }

    static final class HideVisitor
    extends ArchitecturalViewVisitor
    implements AssignableNode.IVisitor {
        HideVisitor() {
        }

        @Override
        public final void visitAssignableNode(AssignableNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitAssignableNode' must not be null";
            element.setHidden(true);
            this.visitChildrenOf(element);
        }
    }
}

