/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class FindElementsInArchitectureFile
implements AssignedElement.IVisitor {
    private final Map<NamedElement, NamedElement> m_collector;
    private final Set<NamedElement> m_toBeFound;

    FindElementsInArchitectureFile(Collection<NamedElement> toBeFound, Map<NamedElement, NamedElement> collector) {
        assert (toBeFound != null && !toBeFound.isEmpty()) : "Parameter 'toBeFound' of method 'FindElementsInArchitectureFile' must not be empty";
        assert (collector != null) : "Parameter 'collector' of method 'FindElementsInArchitectureFile' must not be null";
        this.m_toBeFound = new THashSet(toBeFound);
        this.m_collector = collector;
    }

    @Override
    public final void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        for (NamedElement next : element.getChildren()) {
            if (this.m_toBeFound.isEmpty()) break;
            next.accept(this);
        }
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        Object representedElement;
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (element instanceof ArchitectureElementContainer && this.m_toBeFound.remove(representedElement = ((ArchitectureElementContainer)element).getRepresentedElement())) {
            this.m_collector.put(element, (NamedElement)representedElement);
        }
        this.visitChildrenOf(element);
    }

    @Override
    public void visitAssignedElement(AssignedElement element) {
        NamedElement namedElement;
        assert (element != null) : "Parameter 'element' of method 'visitAssignedElement' must not be null";
        IAssignableToArtifact assignableToArtifact = element.getAssignable();
        if (assignableToArtifact != null && this.m_toBeFound.remove(namedElement = assignableToArtifact.getNamedElement())) {
            this.m_collector.put(element, namedElement);
        }
    }
}

