/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchitecturalViewNodeCreator
extends NamedElementVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewNodeCreator.class);
    private static final String WORKING = "Working";
    private static final int WORKING_THRESHOLD = 25000;
    private final Deque<ArchitecturalViewElement> m_stack = new ArrayDeque<ArchitecturalViewElement>();
    private final List<ProgrammingElement> m_programmingElementsToAssign = new ArrayList<ProgrammingElement>();
    private final IWorkerContext m_workerContext;
    private final ExplorationViewRepresentation m_representation;
    private ProgrammingElementAggregatingNode m_currentLeafNode;
    private int m_visitedNamedElements;
    private boolean m_atLeastOneProgrammingElementAdded;

    protected ArchitecturalViewNodeCreator(IWorkerContext workerContext, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'ArchitecturalViewElementCreator' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'ArchitecturalViewElementCreator' must not be null";
        assert (representation.getPresentationMode() == PresentationMode.HIERARCHICAL) : "Unexpected presentation mode: " + String.valueOf((Object)representation.getPresentationMode());
        this.m_workerContext = workerContext;
        this.m_representation = representation;
        this.m_stack.push(representation);
    }

    protected final boolean isReadOnly() {
        return this.m_representation.isReadOnly();
    }

    @Override
    public final boolean done() {
        if (this.m_visitedNamedElements % 25000 == 0) {
            this.m_workerContext.working(WORKING, false);
        }
        return this.m_workerContext.hasBeenCanceled();
    }

    protected final PresentationMode getPresentationMode() {
        return this.m_representation.getPresentationMode();
    }

    protected abstract void enter(NamedElement var1, ArchitecturalViewNode var2);

    protected abstract void leave(NamedElement var1, ArchitecturalViewNode var2);

    protected abstract ArchitecturalViewNode processElement(ArchitecturalViewElement var1, NamedElement var2);

    protected abstract boolean includeElement(NamedElement var1);

    private boolean hasAtLeastOneIncomingDependencyFromInternal(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'hasAtLeastOneIncomingDependencyFromInternal' must not be null";
        assert (element.isExternal()) : "Not external: " + String.valueOf(element);
        Iterator<ParserDependency> nextIter = element.getDependencyIterator();
        while (nextIter.hasNext()) {
            if (this.done()) {
                return false;
            }
            ParserDependency nextDependency = nextIter.next();
            if (!this.m_representation.includeIncomingParserDependency(element, nextDependency, false, null).isIncluded() || nextDependency.getFrom().isExternal()) continue;
            return true;
        }
        return false;
    }

    protected final void startLeafNode(ProgrammingElementAggregatingNode node) {
        assert (node != null) : "Parameter 'node' of method 'startLeafNode' must not be null";
        assert (this.m_programmingElementsToAssign.isEmpty()) : "There are already programming elements";
        assert (this.m_currentLeafNode == null) : "Already started: " + this.m_currentLeafNode.getElementInfo();
        this.m_currentLeafNode = node;
    }

    protected final ProgrammingElementAggregatingNode getCurrentLeafNode() {
        return this.m_currentLeafNode;
    }

    protected final void finishLeafNode(ProgrammingElementAggregatingNode node) {
        assert (node != null) : "Parameter 'node' of method 'finishLeafNode' must not be null";
        assert (this.m_currentLeafNode != null) : "'m_current' of method 'finishLeafNode' must not be null";
        assert (this.m_currentLeafNode == node) : "Different nodes";
        assert (this.m_programmingElementsToAssign != null) : "'m_programmingElementsToAssign' of method 'finishLeafNode' must not be null";
        if (!this.m_programmingElementsToAssign.isEmpty()) {
            boolean keep = false;
            if (node.isExternal()) {
                ArrayList<ProgrammingElement> removalCandidates = new ArrayList<ProgrammingElement>();
                for (ProgrammingElement programmingElement : this.m_programmingElementsToAssign) {
                    if (this.done()) {
                        return;
                    }
                    if (!programmingElement.isExternal() || this.hasAtLeastOneIncomingDependencyFromInternal(programmingElement)) continue;
                    removalCandidates.add(programmingElement);
                }
                if (removalCandidates.size() != this.m_programmingElementsToAssign.size()) {
                    keep = true;
                    for (ProgrammingElement programmingElement : removalCandidates) {
                        if (this.done()) {
                            return;
                        }
                        List<ProgrammingElement> nextChildren = programmingElement.getChildrenRecursively(ProgrammingElement.class, new Class[0]);
                        if (nextChildren.isEmpty()) {
                            this.m_programmingElementsToAssign.remove(programmingElement);
                            this.m_representation.addExcludedProgrammingElement(programmingElement);
                            continue;
                        }
                        boolean remove = true;
                        for (ProgrammingElement nextChild : nextChildren) {
                            if (this.done()) {
                                return;
                            }
                            if (!this.m_programmingElementsToAssign.contains(nextChild) || removalCandidates.contains(nextChild)) continue;
                            remove = false;
                            break;
                        }
                        if (!remove) continue;
                        this.m_programmingElementsToAssign.remove(programmingElement);
                        this.m_representation.addExcludedProgrammingElement(programmingElement);
                    }
                }
            } else {
                keep = true;
            }
            if (keep) {
                this.m_atLeastOneProgrammingElementAdded = true;
                Iterator<ArchitecturalViewElement> iter = this.m_stack.iterator();
                while (iter.hasNext()) {
                    if (this.done()) {
                        return;
                    }
                    NamedElement namedElement = iter.next();
                    if (namedElement == node) {
                        node.addProgrammingElements(this.m_programmingElementsToAssign);
                        this.m_representation.assignProgrammingElementsToLeafNode(this.m_programmingElementsToAssign, node);
                        continue;
                    }
                    if (!(namedElement instanceof ProgrammingElementAggregatingNode)) continue;
                    ((ProgrammingElementAggregatingNode)namedElement).addProgrammingElements(this.m_programmingElementsToAssign);
                }
            }
            this.m_programmingElementsToAssign.clear();
        }
        this.m_currentLeafNode = null;
    }

    protected final void processEmptyProgrammingElement(ArchitecturalViewNode owner, EmptyNodeProgrammingElement programmingElement) {
        assert (owner != null) : "Parameter 'owner' of method 'processEmptyProgrammingElement' must not be null";
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'processProgrammingElement' must not be null";
        Iterator<ArchitecturalViewElement> iter = this.m_stack.iterator();
        while (iter.hasNext()) {
            if (this.done()) {
                return;
            }
            NamedElement next = iter.next();
            if (next == owner || !(next instanceof ProgrammingElementAggregatingNode) || ((ProgrammingElementAggregatingNode)next).getProgrammingElements().contains(programmingElement)) continue;
            ((ProgrammingElementAggregatingNode)next).addProgrammingElement(programmingElement);
        }
    }

    protected final void processProgrammingElement(ProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'processProgrammingElement' must not be null";
        assert (!(programmingElement instanceof EmptyNodeProgrammingElement)) : "Unexpected " + programmingElement.getClass().getName();
        if (this.m_currentLeafNode != null) {
            if (programmingElement.getRefactoringState() == RefactoringState.DELETED) {
                this.m_representation.addExcludedProgrammingElement(programmingElement);
            } else {
                this.m_programmingElementsToAssign.add(programmingElement);
            }
        } else {
            LOGGER.warn("No IComponent parent found for programming element: " + programmingElement.getDebugInfo());
        }
    }

    public static boolean canBeShownInExplorationView(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'canBeShownInExplorationView' must not be null";
        return !element.isExcluded() && !element.isGhost() && element.getRefactoringState() != RefactoringState.DELETED;
    }

    @Override
    public final void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (!this.done()) {
            if (element.getRefactoringState() == RefactoringState.DELETED) {
                if (element instanceof ProgrammingElement) {
                    this.m_representation.addExcludedProgrammingElement((ProgrammingElement)element);
                }
            } else if (element.isGhost()) {
                if (element instanceof ProgrammingElement) {
                    this.m_representation.addExcludedProgrammingElement((ProgrammingElement)element);
                }
                this.visitChildrenOf(element);
            } else if (this.includeElement(element)) {
                ArchitecturalViewElement parent = this.m_stack.peek();
                assert (parent != null) : "'parent' of method 'visitNamedElement' must not be null";
                ArchitecturalViewNode node = this.processElement(parent, element);
                if (node != null) {
                    this.m_stack.push(node);
                    this.enter(element, node);
                    this.visitChildrenOf(element);
                    this.leave(element, node);
                    this.m_stack.pop();
                } else {
                    this.enter(element, null);
                    this.visitChildrenOf(element);
                    this.leave(element, null);
                }
            }
        }
        ++this.m_visitedNamedElements;
    }

    public final boolean finish() {
        this.m_representation.accept(new RemoveEmptyExternalsVisitor());
        return this.m_atLeastOneProgrammingElementAdded;
    }

    private static final class RemoveEmptyExternalsVisitor
    extends ArchitecturalViewVisitor
    implements ProgrammingElementAggregatingNode.IVisitor,
    AssignableToArtifactNode.IVisitor {
        RemoveEmptyExternalsVisitor() {
        }

        private boolean removeExternal(ProgrammingElementAggregatingNode node) {
            assert (node != null) : "Parameter 'node' of method 'removeExternal' must not be null";
            Iterator<ProgrammingElement> iter = node.getProgrammingElements().iterator();
            while (iter.hasNext()) {
                if (iter.next() instanceof EmptyNodeProgrammingElement) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visitProgrammingElementAggregatingNode(ProgrammingElementAggregatingNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            if (element.isExternal()) {
                this.visitChildrenOf(element);
                for (ProgrammingElementAggregatingNode next : element.getChildren(ProgrammingElementAggregatingNode.class)) {
                    if (!this.removeExternal(next)) continue;
                    element.removeChild(next);
                }
            }
        }

        @Override
        public void visitAssignableToArtifactNode(AssignableToArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitAssignableToArtifactNode' must not be null";
        }
    }
}

