/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractDiffProcessor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.AbstractFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ExcludePatternDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.IncludePatternDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.IssueFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ModuleDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ProductionCodeFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.RootDirectoryDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.WorkspaceFilterDiff;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IComponentFilter;
import com.hello2morrow.sonargraph.integration.access.model.IFilter;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IRootDirectory;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.IWildcardPattern;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public final class WorkspaceDiffProcessor
extends AbstractDiffProcessor {
    public WorkspaceDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem currentSystem) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
    }

    @Override
    public void process(NamedElement parent) {
        Workspace currentWorkspace = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
        this.processFilters(parent, currentWorkspace);
        this.processModules(parent, currentWorkspace);
    }

    private void processFilters(NamedElement parent, Workspace currentWorkspace) {
        Optional workspaceFilterOpt = this.getBaselineSystem().getWorkspaceFilter();
        assert (workspaceFilterOpt.isPresent()) : "Missing workspace filter!";
        IFilter baselineWorkspaceFilter = (IFilter)workspaceFilterOpt.get();
        WorkspaceFilter currentWorkspaceFilter = currentWorkspace.getUniqueExistingChild(WorkspaceFilter.class);
        WorkspaceFilterDiff workspaceFilterDiff = new WorkspaceFilterDiff(parent, baselineWorkspaceFilter, currentWorkspaceFilter);
        this.processIncludes(baselineWorkspaceFilter, currentWorkspaceFilter, workspaceFilterDiff);
        this.processExcludes(baselineWorkspaceFilter, currentWorkspaceFilter, workspaceFilterDiff);
        parent.addChild(workspaceFilterDiff);
        Optional productionCodeFilterOpt = this.getBaselineSystem().getProductionCodeFilter();
        assert (productionCodeFilterOpt.isPresent()) : "Missing production code filter!";
        IComponentFilter baselineProductionCodeFilter = (IComponentFilter)productionCodeFilterOpt.get();
        ProductionCodeFilter currentProductionCodeFilter = currentWorkspace.getUniqueExistingChild(ProductionCodeFilter.class);
        ProductionCodeFilterDiff productionCodeFilterDiff = new ProductionCodeFilterDiff(parent, (IFilter)baselineProductionCodeFilter, currentProductionCodeFilter);
        this.processIncludes((IFilter)baselineProductionCodeFilter, currentProductionCodeFilter, productionCodeFilterDiff);
        this.processExcludes((IFilter)baselineProductionCodeFilter, currentProductionCodeFilter, productionCodeFilterDiff);
        parent.addChild(productionCodeFilterDiff);
        Optional baselineIssueFilterOpt = this.getBaselineSystem().getIssueFilter();
        assert (baselineIssueFilterOpt.isPresent()) : "Missing issue filter!";
        IComponentFilter baselineIssueFilter = (IComponentFilter)baselineIssueFilterOpt.get();
        IssueFilter currentIssueFilter = currentWorkspace.getUniqueExistingChild(IssueFilter.class);
        IssueFilterDiff issueFilterDiff = new IssueFilterDiff(parent, (IFilter)baselineIssueFilter, currentIssueFilter);
        this.processIncludes((IFilter)baselineIssueFilter, currentIssueFilter, issueFilterDiff);
        this.processExcludes((IFilter)baselineIssueFilter, currentIssueFilter, issueFilterDiff);
        parent.addChild(issueFilterDiff);
    }

    private void processIncludes(IFilter baselineFilter, Filter currentFilter, AbstractFilterDiff<?> filterDiff) {
        IncludePatternDiff includeDiff;
        assert (baselineFilter != null) : "Parameter 'baselineFilter' of method 'processIncludes' must not be null";
        assert (currentFilter != null) : "Parameter 'currentFilter' of method 'processIncludes' must not be null";
        assert (filterDiff != null) : "Parameter 'filterDiff' of method 'processIncludes' must not be null";
        Map<String, WildcardPatternInclude> currentIncludePatterns = this.collectCurrentPatterns(currentFilter, WildcardPatternInclude.class);
        Map<String, IWildcardPattern> baselineIncludePatterns = this.collectBaselinePatterns(baselineFilter, true);
        for (Map.Entry<String, WildcardPatternInclude> currentInclude : currentIncludePatterns.entrySet()) {
            IWildcardPattern baselineIncludePattern = baselineIncludePatterns.remove(currentInclude.getKey());
            includeDiff = baselineIncludePattern != null ? new IncludePatternDiff((NamedElement)filterDiff, baselineIncludePattern, currentInclude.getValue(), IDiffElement.Change.UNMODIFIED) : new IncludePatternDiff((NamedElement)filterDiff, null, currentInclude.getValue(), IDiffElement.Change.ADDED);
            filterDiff.addChild(includeDiff);
        }
        for (IWildcardPattern nextBaseline : baselineIncludePatterns.values()) {
            includeDiff = new IncludePatternDiff(filterDiff, nextBaseline, null, IDiffElement.Change.REMOVED);
            filterDiff.addChild(includeDiff);
        }
    }

    private void processExcludes(IFilter baselineFilter, Filter currentFilter, AbstractFilterDiff<?> filterDiff) {
        assert (baselineFilter != null) : "Parameter 'baselineFilter' of method 'processExcludes' must not be null";
        assert (currentFilter != null) : "Parameter 'currentFilter' of method 'processExcludes' must not be null";
        assert (filterDiff != null) : "Parameter 'filterDiff' of method 'processExcludes' must not be null";
        Map<String, WildcardPatternExclude> currentExcludePatterns = this.collectCurrentPatterns(currentFilter, WildcardPatternExclude.class);
        Map<String, IWildcardPattern> baselineExcludePatterns = this.collectBaselinePatterns(baselineFilter, false);
        for (Map.Entry<String, WildcardPatternExclude> currentExclude : currentExcludePatterns.entrySet()) {
            IWildcardPattern baselineExcludePattern = baselineExcludePatterns.remove(currentExclude.getKey());
            ExcludePatternDiff excludeDiff = baselineExcludePattern != null ? new ExcludePatternDiff((NamedElement)filterDiff, baselineExcludePattern, currentExclude.getValue(), IDiffElement.Change.UNMODIFIED) : new ExcludePatternDiff((NamedElement)filterDiff, null, currentExclude.getValue(), IDiffElement.Change.ADDED);
            filterDiff.addChild(excludeDiff);
        }
        for (IWildcardPattern nextBaseline : baselineExcludePatterns.values()) {
            ExcludePatternDiff excludeDiff = new ExcludePatternDiff(filterDiff, nextBaseline, null, IDiffElement.Change.REMOVED);
            filterDiff.addChild(excludeDiff);
        }
    }

    private <T extends WildcardPattern> Map<String, T> collectCurrentPatterns(Filter currentFilter, Class<T> clazz) {
        assert (currentFilter != null) : "Parameter 'currentFilter' of method 'collectCurrentPatterns' must not be null";
        assert (clazz != null) : "Parameter 'clazz' of method 'collectCurrentPatterns' must not be null";
        LinkedHashMap currentPatterns = new LinkedHashMap();
        currentFilter.getChildren(clazz).forEach(pattern -> {
            WildcardPattern wildcardPattern = currentPatterns.put(pattern.getName(), pattern);
        });
        return currentPatterns;
    }

    private Map<String, IWildcardPattern> collectBaselinePatterns(IFilter baselineFilter, boolean isInclude) {
        assert (baselineFilter != null) : "Parameter 'baselineFilter' of method 'collectBaselinePatterns' must not be null";
        LinkedHashMap<String, IWildcardPattern> baselinePatterns = new LinkedHashMap<String, IWildcardPattern>();
        List patterns = isInclude ? baselineFilter.getIncludePatterns() : baselineFilter.getExcludePatterns();
        patterns.forEach(pattern -> {
            IWildcardPattern iWildcardPattern = baselinePatterns.put(pattern.getPattern(), (IWildcardPattern)pattern);
        });
        return baselinePatterns;
    }

    private void processModules(NamedElement parent, Workspace currentWorkspace) {
        assert (parent != null) : "Parameter 'parent' of method 'processModules' must not be null";
        assert (currentWorkspace != null) : "Parameter 'currentWorkspace' of method 'processModules' must not be null";
        Map<String, StrictPair<IModule, Integer>> baselineModules = this.collectBaselineModules(this.getBaselineSystem());
        Map<String, StrictPair<Module, Integer>> currentModules = this.collectCurrentModules(currentWorkspace);
        for (Map.Entry<String, StrictPair<Module, Integer>> entry : currentModules.entrySet()) {
            ModuleDiff moduleDiff;
            Module currentModule = (Module)entry.getValue().getFirst();
            int currentPosition = (Integer)entry.getValue().getSecond();
            StrictPair<IModule, Integer> baselineModuleAndPosition = baselineModules.remove(entry.getKey());
            if (baselineModuleAndPosition != null) {
                StringJoiner changeDescription = new StringJoiner(". ", "", ".");
                IModule baselineModule = (IModule)baselineModuleAndPosition.getFirst();
                int baselinePosition = (Integer)baselineModuleAndPosition.getSecond();
                if (!baselineModule.getDescription().equals(currentModule.getDescription())) {
                    changeDescription.add("Description: " + baselineModule.getDescription() + " -> " + currentModule.getDescription());
                }
                if (currentPosition != baselinePosition) {
                    changeDescription.add("Position: " + baselinePosition + " -> " + currentPosition);
                }
                moduleDiff = changeDescription.length() == 1 ? new ModuleDiff(parent, baselineModule, currentModule, IDiffElement.Change.UNMODIFIED) : new ModuleDiff(parent, baselineModule, currentModule, IDiffElement.Change.MODIFIED, changeDescription.toString());
            } else {
                moduleDiff = new ModuleDiff(parent, null, currentModule, IDiffElement.Change.ADDED);
            }
            this.processRootDirectories(moduleDiff);
            parent.addChild(moduleDiff);
        }
        for (StrictPair strictPair : baselineModules.values()) {
            ModuleDiff moduleDiff = new ModuleDiff(parent, (IModule)strictPair.getFirst(), null, IDiffElement.Change.REMOVED);
            parent.addChild(moduleDiff);
            this.processRootDirectories(moduleDiff);
        }
    }

    private Map<String, StrictPair<Module, Integer>> collectCurrentModules(Workspace currentWorkspace) {
        assert (currentWorkspace != null) : "Parameter 'currentWorkspace' of method 'collectCurrentModules' must not be null";
        LinkedHashMap<String, StrictPair<Module, Integer>> currentModules = new LinkedHashMap<String, StrictPair<Module, Integer>>();
        int i = 1;
        for (Module nextCurrent : currentWorkspace.getChildren(Module.class)) {
            currentModules.put(nextCurrent.getName(), (StrictPair<Module, Integer>)new StrictPair((Object)nextCurrent, (Object)i));
            ++i;
        }
        return currentModules;
    }

    private Map<String, StrictPair<IModule, Integer>> collectBaselineModules(ISoftwareSystem baselineSoftwareSystem) {
        assert (baselineSoftwareSystem != null) : "Parameter 'baselineSoftwareSystem' of method 'collectBaselineModules' must not be null";
        LinkedHashMap<String, StrictPair<IModule, Integer>> baselineModules = new LinkedHashMap<String, StrictPair<IModule, Integer>>();
        int i = 1;
        for (Map.Entry nextBaselineEntry : baselineSoftwareSystem.getModules().entrySet()) {
            baselineModules.put((String)nextBaselineEntry.getKey(), (StrictPair<IModule, Integer>)new StrictPair((Object)((IModule)nextBaselineEntry.getValue()), (Object)i));
            ++i;
        }
        return baselineModules;
    }

    private void processRootDirectories(ModuleDiff moduleDiff) {
        assert (moduleDiff != null) : "Parameter 'moduleDiff' of method 'processRootDirectories' must not be null";
        Map<String, StrictPair<RootDirectoryPath, RootDirectoryDto>> currentRootsMap = this.collectCurrentRoots((Module)moduleDiff.getCurrent());
        Map<String, StrictPair<IRootDirectory, RootDirectoryDto>> baselineRootsMap = this.collectBaselineRoots((IModule)moduleDiff.getBaseline());
        for (Map.Entry<String, StrictPair<RootDirectoryPath, RootDirectoryDto>> entry : currentRootsMap.entrySet()) {
            String path = entry.getKey();
            RootDirectoryPath currentRoot = (RootDirectoryPath)entry.getValue().getFirst();
            RootDirectoryDto currentDto = (RootDirectoryDto)entry.getValue().getSecond();
            StrictPair<IRootDirectory, RootDirectoryDto> baseline = baselineRootsMap.remove(path);
            if (baseline != null) {
                StringJoiner changeDescription = new StringJoiner(". ", "", ".");
                IRootDirectory baselineRoot = (IRootDirectory)baseline.getFirst();
                RootDirectoryDto baselineDto = (RootDirectoryDto)baseline.getSecond();
                if (!currentDto.getKind().equals(baselineDto.getKind())) {
                    changeDescription.add("Type: " + baselineDto.getKind() + " -> " + currentDto.getKind());
                }
                if (currentDto.getPosition() != baselineDto.getPosition()) {
                    changeDescription.add("Position: " + baselineDto.getPosition() + " -> " + currentDto.getPosition());
                }
                RootDirectoryDiff rootDiff = changeDescription.length() == 1 ? new RootDirectoryDiff((NamedElement)moduleDiff, baselineRoot, currentRoot, IDiffElement.Change.UNMODIFIED) : new RootDirectoryDiff((NamedElement)moduleDiff, baselineRoot, currentRoot, IDiffElement.Change.MODIFIED, changeDescription.toString());
                moduleDiff.addChild(rootDiff);
                continue;
            }
            String changeMessage = "Added at position " + currentDto.getPosition();
            RootDirectoryDiff rootDiff = new RootDirectoryDiff((NamedElement)moduleDiff, null, currentRoot, IDiffElement.Change.ADDED, changeMessage);
            moduleDiff.addChild(rootDiff);
        }
        for (StrictPair strictPair : baselineRootsMap.values()) {
            RootDirectoryDiff rootDiff = new RootDirectoryDiff((NamedElement)moduleDiff, (IRootDirectory)strictPair.getFirst(), null, IDiffElement.Change.REMOVED);
            moduleDiff.addChild(rootDiff);
        }
    }

    private Map<String, StrictPair<IRootDirectory, RootDirectoryDto>> collectBaselineRoots(IModule baselineModule) {
        if (baselineModule == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, StrictPair<IRootDirectory, RootDirectoryDto>> baselineRoots = new LinkedHashMap<String, StrictPair<IRootDirectory, RootDirectoryDto>>();
        int index = 1;
        for (IRootDirectory nextRoot : baselineModule.getRootDirectories()) {
            RootDirectoryDto dto = new RootDirectoryDto(nextRoot.getPresentationKind(), index++);
            baselineRoots.put(nextRoot.getName(), (StrictPair<IRootDirectory, RootDirectoryDto>)new StrictPair((Object)nextRoot, (Object)dto));
        }
        return baselineRoots;
    }

    private Map<String, StrictPair<RootDirectoryPath, RootDirectoryDto>> collectCurrentRoots(Module currentModule) {
        if (currentModule == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, StrictPair<RootDirectoryPath, RootDirectoryDto>> currentRoots = new LinkedHashMap<String, StrictPair<RootDirectoryPath, RootDirectoryDto>>();
        int index = 1;
        for (RootDirectoryPath nextRoot : currentModule.getChildren(RootDirectoryPath.class)) {
            RootDirectoryDto dto = new RootDirectoryDto(nextRoot.getPresentationKind(), index++);
            currentRoots.put(nextRoot.getName(), (StrictPair<RootDirectoryPath, RootDirectoryDto>)new StrictPair((Object)nextRoot, (Object)dto));
        }
        return currentRoots;
    }

    private static class RootDirectoryDto {
        private final int m_position;
        private final String m_kind;

        public RootDirectoryDto(String kind, int position) {
            assert (kind != null) : "Parameter 'kind' of method 'RootDirectoryDto' must not be null";
            this.m_position = position;
            this.m_kind = kind;
        }

        public String getKind() {
            return this.m_kind;
        }

        public int getPosition() {
            return this.m_position;
        }
    }
}

