/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

abstract class AbstractDependencyMetricsSystem
extends AnalyzerAdapter {
    protected static final Predicate<ProgrammingElement> PE = pe -> !pe.isExcluded() && !pe.getRefactoringState().hasBeenDeleted();
    protected static final Predicate<ParserDependency> PD = pd -> !pd.isExcluded() && !pd.getTo().isExcluded() && pd.isCompileTimeDependency() && !pd.getRefactoringState().hasBeenDeleted();

    AbstractDependencyMetricsSystem(IAnalyzerController listener, IConfigurableAnalyzerId id) {
        super(listener, id);
    }

    @Override
    protected final IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    @Override
    public final boolean canStoreResult() {
        return true;
    }

    abstract class DependencyMetricsSystemJob
    extends AnalyzerJob {
        protected DependencyMetricsSystemJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
        }

        protected abstract void processSystem(NodeAdapterSet<ParserDependencyNodeAdapter> var1);

        @Override
        public final void internalRun() {
            this.getWorkerContext().working("Creating node adapter set", true);
            ArrayList<NamedElement> forNamedElements = new ArrayList<NamedElement>();
            List<Module> modules = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class);
            if (modules.isEmpty()) {
                return;
            }
            this.getWorkerContext().setNumberOfSteps(3, new int[]{5, 5, 90});
            for (Module nextModule : modules) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                List<IComponent> components = nextModule.getChildrenRecursively(IComponent.class, new Class[0]);
                for (IComponent nextComponent : components) {
                    if (this.getWorkerContext().hasBeenCanceled()) {
                        return;
                    }
                    NamedElement nextNamedElement = nextComponent.getNamedElement();
                    if (nextNamedElement.isExcluded() || nextNamedElement.getRefactoringState().hasBeenDeleted()) continue;
                    forNamedElements.add(nextNamedElement);
                }
            }
            this.getWorkerContext().endStep();
            if (!this.getWorkerContext().hasBeenCanceled() && forNamedElements.size() > 0) {
                this.getWorkerContext().beginSubTask("Create node adapter set");
                ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(this.getWorkerContext(), forNamedElements, new DependencyEndpointCollector(), PE, PD);
                this.getWorkerContext().endSubTask();
                this.getWorkerContext().beginSubTask("Calculate dependency metrics");
                this.processSystem(nodeAdapterSet);
                this.getWorkerContext().endSubTask();
            }
        }
    }
}

