/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectWriter;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnalyzerResultWriter
extends ObjectWriter {
    private final AnalyzerResult m_result;
    private final IAnalyzerController m_controller;

    protected AnalyzerResultWriter(AnalyzerResult result, IAnalyzerController controller) {
        assert (result != null) : "Parameter 'result' of method 'AnalyzerResultWriter' must not be null";
        assert (controller != null) : "Parameter 'controller' of method 'AnalyzerResultWriter' must not be null";
        this.m_result = result;
        this.m_controller = controller;
    }

    public void storeChildrenAndAdditionalObjects(TFile target, List<? extends IPersistable> issues) throws IOException {
        assert (target != null) : "Parameter 'target' of method 'store' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'store' must not be null";
        ArrayList<? extends IPersistable> toBeStored = new ArrayList<IPersistable>();
        toBeStored.addAll(this.m_result.getChildren());
        toBeStored.addAll(issues);
        super.storeChildrenAndAdditionalObjects(target, toBeStored);
    }

    protected void writeObjectReference(IPersistable object) throws IOException {
        if (object instanceof NamedElement) {
            NamedElement element = (NamedElement)object;
            if (element.hasAsParent(this.m_result, false)) {
                super.writeObjectReference(object);
            } else {
                this.writeString(this.m_controller.getResolver().getDescriptor(element));
            }
        } else if (object instanceof Dependency) {
            this.writeString(this.m_controller.getResolver().getDescriptor((Element)object));
        } else {
            super.writeObjectReference(object);
        }
    }

    public void writeOther(String attributeName, Object obj) throws IOException {
        assert (attributeName != null && attributeName.length() > 0) : "Parameter 'attributeName' of method 'writeObjectReference' must not be empty";
        if (obj instanceof Language) {
            this.writeString(attributeName, ((Language)obj).getStandardName());
        } else if (obj instanceof IMetricDescriptor) {
            IMetricDescriptor md = (IMetricDescriptor)obj;
            String descriptor = md.getMetricId().getStandardName() + ":" + md.getLevel().getStandardName();
            this.writeString(attributeName, descriptor);
        } else if (obj instanceof Element) {
            this.writeObjectReference(attributeName, (Element)obj);
        } else {
            super.writeOther(attributeName, obj);
        }
    }
}

