/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.architecture;

import com.hello2morrow.sonargraph.core.controller.system.analysis.SizeComputationUtility;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.transients.AssignedElementsResult;
import com.hello2morrow.sonargraph.core.model.analysis.transients.ComponentsWithViolationsResult;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class ArchitectureMetricAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.ARCHITECTURE_SOURCECODE_METRICS;
    private final IMetricDescriptor m_percentageLocInFilesWithViolations;
    private final IMetricDescriptor m_percentageLocInFilesWithViolationsOrDeprecations;
    private final IMetricDescriptor m_locInFilesWithViolations;
    private final IMetricDescriptor m_locInFilesWithViolationsOrDeprecations;
    private final IMetricDescriptor m_percentageLocUnassignedCode;
    private final IMetricDescriptor m_violationDensitySourceElementCount;
    private final IMetricDescriptor m_violationDensityLoc;

    public ArchitectureMetricAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_percentageLocInFilesWithViolations = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATING_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_percentageLocInFilesWithViolationsOrDeprecations = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_locInFilesWithViolations = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATING_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
        this.m_locInFilesWithViolationsOrDeprecations = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_DEPRECATED_OR_VIOLATING_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
        this.m_percentageLocUnassignedCode = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_UNASSIGNED_LINES_OF_CODE_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_violationDensitySourceElementCount = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATION_DENSITY_SOURCE_ELEMENTS, CoreMetricLevel.SYSTEM);
        this.m_violationDensityLoc = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATION_DENSITY_LINES_OF_CODE, CoreMetricLevel.SYSTEM);
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        ArchitectureSourceMetricsJob job = new ArchitectureSourceMetricsJob(this.getGroup(), result, this.getController(), this.getRequiredResults());
        job.start();
    }

    @Override
    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        if (result.getMetricValue(this.getSoftwareSystem(), this.m_percentageLocInFilesWithViolations) == null) {
            throw new RestoreException("Missing expected metric value for fully analyzed lines of code.");
        }
        super.resultSuccessfullyRestored(result);
    }

    private final class ArchitectureSourceMetricsJob
    extends AnalyzerJob {
        private ArchitectureSourceMetricsJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, List<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void internalRun() {
            IMetricAccessor metricAccessor = this.getInstallation().getExtension(IMetricAccessor.class);
            int relevantLoc = this.computeLocCheckedByArchitecture(metricAccessor);
            if (relevantLoc <= 0) {
                return;
            }
            AnalyzerResult architectureCheck = this.getArchitectureCheckResult(this.getRequiredResults());
            if (architectureCheck == null) {
                return;
            }
            if (!this.hasAnyCheckedArchitectures(architectureCheck)) {
                return;
            }
            this.computeViolatingLocRatio(relevantLoc);
            this.computeUnassignedCodeRatio(relevantLoc);
            this.computeViolationDensity(metricAccessor, relevantLoc);
        }

        private boolean hasAnyCheckedArchitectures(AnalyzerResult architectureCheck) {
            Analyzer architectureAnalyzer = architectureCheck.getParent(Analyzer.class, new Class[0]);
            ArchitectureCheckConfiguration config = architectureAnalyzer.getUniqueExistingChild(ArchitectureCheckConfiguration.class);
            if (config == null) {
                return false;
            }
            return !config.getIdentifyingPaths().isEmpty();
        }

        private AnalyzerResult getArchitectureCheckResult(List<AnalyzerResult> results) {
            for (AnalyzerResult next : results) {
                if (next.getId() != CoreAnalyzerId.ARCHITECTURE_CHECK) continue;
                return next;
            }
            return null;
        }

        private int computeLocCheckedByArchitecture(IMetricAccessor metricAccessor) {
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'computeMaximumLocCheckedByArchitecture' must not be null";
            Number fullyAnalyzedLocValue = metricAccessor.getMetricValue(this.getSoftwareSystem(), this.getSoftwareSystem(), CoreMetricId.CORE_LINES_OF_CODE_FULLY_ANALYZED);
            if (fullyAnalyzedLocValue == null) {
                return -1;
            }
            int fullyAnalyzedLoc = fullyAnalyzedLocValue.intValue();
            Number issueIgnoringLocValue = metricAccessor.getMetricValue(this.getSoftwareSystem(), this.getSoftwareSystem(), CoreMetricId.CORE_LINES_OF_CODE_ISSUE_IGNORING);
            if (issueIgnoringLocValue == null) {
                return -1;
            }
            int issueIgnoringLoc = issueIgnoringLocValue.intValue();
            return fullyAnalyzedLoc + issueIgnoringLoc;
        }

        private void computeViolatingLocRatio(int issueIgnoringLoc) {
            ComponentsWithViolationsResult violatingComponentsResult = null;
            for (AnalyzerResult next : this.getRequiredResults()) {
                if (next.getId() != CoreAnalyzerId.ARCHITECTURE_CHECK) continue;
                violatingComponentsResult = next.getUniqueChild(ComponentsWithViolationsResult.class);
                break;
            }
            if (violatingComponentsResult == null) {
                return;
            }
            Set<IComponent> violatingComponents = violatingComponentsResult.getComponentsWithViolations();
            Set<IComponent> componentsWithDeprecations = violatingComponentsResult.getComponentsWithDeprecations();
            if (violatingComponents == null || componentsWithDeprecations == null) {
                return;
            }
            THashSet sourceFiles = new THashSet();
            THashSet sourceFilesWithViolationsOrDeprecations = new THashSet();
            for (IComponent next : violatingComponents) {
                sourceFiles.addAll(SizeComputationUtility.getInternalNotExcludedSourceFiles(next));
            }
            componentsWithDeprecations.removeAll(violatingComponents);
            sourceFilesWithViolationsOrDeprecations.addAll(sourceFiles);
            for (IComponent next : componentsWithDeprecations) {
                sourceFilesWithViolationsOrDeprecations.addAll(SizeComputationUtility.getInternalNotExcludedSourceFiles(next));
            }
            violatingComponentsResult.reset();
            int locOfViolatingSourceFiles = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)sourceFiles);
            int locOfViolatingOrDeprecatedSourceFiles = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)sourceFilesWithViolationsOrDeprecations);
            float percentageOfCodeInViolatingSources = (float)locOfViolatingSourceFiles * 100.0f / (float)issueIgnoringLoc;
            float percentageOfCodeInViolatingorDeprecayedSources = (float)locOfViolatingOrDeprecatedSourceFiles * 100.0f / (float)issueIgnoringLoc;
            ArchitectureMetricAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(percentageOfCodeInViolatingSources), ArchitectureMetricAnalyzerAdapter.this.m_percentageLocInFilesWithViolations);
            ArchitectureMetricAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(percentageOfCodeInViolatingorDeprecayedSources), ArchitectureMetricAnalyzerAdapter.this.m_percentageLocInFilesWithViolationsOrDeprecations);
            ArchitectureMetricAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), locOfViolatingSourceFiles, ArchitectureMetricAnalyzerAdapter.this.m_locInFilesWithViolations);
            ArchitectureMetricAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), locOfViolatingOrDeprecatedSourceFiles, ArchitectureMetricAnalyzerAdapter.this.m_locInFilesWithViolationsOrDeprecations);
        }

        private void computeUnassignedCodeRatio(int relevantLoc) {
            AssignedElementsResult assignedElementsResult = null;
            for (AnalyzerResult next : this.getRequiredResults()) {
                if (next.getId() != CoreAnalyzerId.ARCHITECTURE_CHECK) continue;
                assignedElementsResult = next.getUniqueChild(AssignedElementsResult.class);
                break;
            }
            if (assignedElementsResult == null) {
                return;
            }
            Set<NamedElement> assignedElements = assignedElementsResult.getAssignedElements();
            if (assignedElements == null) {
                return;
            }
            THashSet sourceFiles = new THashSet();
            for (NamedElement next : assignedElements) {
                NamedElement element;
                if (next instanceof AssignedElement) {
                    AssignedElement assigned = (AssignedElement)next;
                    element = assigned.getRepresentedElement();
                } else {
                    element = next;
                }
                if (element.isExternal()) continue;
                sourceFiles.addAll(SizeComputationUtility.getInternalNotExcludedSourceFiles(element));
            }
            assignedElementsResult.reset();
            int assignedLoc = SizeComputationUtility.computeLinesOfCode((Collection<SourceFile>)sourceFiles);
            int unassignedLoc = relevantLoc - assignedLoc;
            float percentageOfUnassignedLoc = (float)unassignedLoc * 100.0f / (float)relevantLoc;
            ArchitectureMetricAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(percentageOfUnassignedLoc), ArchitectureMetricAnalyzerAdapter.this.m_percentageLocUnassignedCode);
        }

        private void computeViolationDensity(IMetricAccessor metricAccessor, int relevantLoc) {
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'computeViolationDensity' must not be null";
            Number sourceElementCountValue = metricAccessor.getMetricValue(this.getSoftwareSystem(), this.getSoftwareSystem(), CoreMetricId.CORE_SOURCE_ELEMENT_COUNT);
            if (sourceElementCountValue == null) {
                return;
            }
            int sourceElementCount = sourceElementCountValue.intValue();
            assert (sourceElementCount > 0) : "SourceElementCount for System must be > 0, but was " + sourceElementCount;
            Number violationCountValue = metricAccessor.getMetricValue(this.getSoftwareSystem(), this.getSoftwareSystem(), CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES);
            if (violationCountValue == null) {
                return;
            }
            int violationCount = violationCountValue.intValue();
            assert (violationCount >= 0) : "Violation count for System must be >= 0, but was " + violationCount;
            float violationDensitySourceElements = (float)violationCount * 1000.0f / (float)sourceElementCount;
            ArchitectureMetricAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(violationDensitySourceElements), ArchitectureMetricAnalyzerAdapter.this.m_violationDensitySourceElementCount);
            float violationDensityLoc = (float)violationCount * 1000.0f / (float)relevantLoc;
            ArchitectureMetricAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(violationDensityLoc), ArchitectureMetricAnalyzerAdapter.this.m_violationDensityLoc);
        }
    }
}

