/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceProfileExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.FilterModification;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfileProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfileModuleRef;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfilePatternModification;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfileRootPathMapping;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfiles;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.WorkspaceProfilePersistence;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public final class WorkspaceProfileExtension
extends Extension
implements IWorkspaceProfileExtension,
IModifiableFileProvider,
IModifiableFileDeltaKey {
    private static final String SEPARATOR = "~_-_-_-_-_~";
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;
    private final WorkspaceProfiles m_workspaceProfiles;
    private WorkspaceProfile m_currentWorkspaceProfile;

    public WorkspaceProfileExtension(Installation installation, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        assert (installation != null) : "Parameter 'installation' of method 'WorkspaceProfileExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'WorkspaceProfileExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'WorkspaceProfileExtension' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_workspaceProfiles = softwareSystem.getUniqueExistingChild(Files.class).getWorkspaceProfilesDirectory();
    }

    @Override
    public WorkspaceProfile getWorkspaceProfile() {
        return this.m_currentWorkspaceProfile;
    }

    public void checkOutOfSync(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        if (!this.m_workspaceProfiles.correspondingFileExists()) {
            TFile directory = this.m_workspaceProfiles.getFile();
            assert (directory != null) : "'directory' of method 'checkOutOfSync' must not be null";
            if (!directory.exists() || !directory.isDirectory()) {
                if (!directory.mkdir()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, "Failed to create workspaceProfile directory '" + this.m_workspaceProfiles.getIdentifyingPath() + "'", new Object[0]);
                    return;
                }
                this.m_workspaceProfiles.checkExistence();
            }
        }
        if (this.m_workspaceProfiles.isOutOfSync(new String[][]{CoreFileType.WORKSPACE_PROFILE.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        this.m_workspaceProfiles.checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return WorkspaceProfileExtension.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!$assertionsDisabled && modifiableFile == null) {
                    throw new AssertionError((Object)"Parameter 'modifiableFile' of method 'exists' must not be null");
                }
                return modifiableFile instanceof WorkspaceProfile;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return WorkspaceProfileExtension.this.m_workspaceProfiles;
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.WORKSPACE_PROFILE);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return WorkspaceProfile.class.getSimpleName();
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return WorkspaceProfileExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof WorkspaceProfile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                WorkspaceProfileExtension.this.addWorkspaceProfile(modified.getFile(), (WorkspaceProfile)modified);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof WorkspaceProfile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                WorkspaceProfile toBeRemoved = (WorkspaceProfile)deleted;
                toBeRemoved.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                result.addMessagesFrom(WorkspaceProfileExtension.this.addWorkspaceProfile(file, null));
            }
        }, true);
    }

    WorkspaceProfilePersistence getPersistence() {
        return new WorkspaceProfilePersistence(this.m_installation.getVersion(), this.m_softwareSystem);
    }

    private OperationResult addWorkspaceProfile(TFile file, WorkspaceProfile profile) {
        OperationResultWithOutcome<WorkspaceProfile> loadResult;
        assert (file != null) : "Parameter 'file' of method 'addWorkspaceProfile' must not be null";
        Files files = this.m_softwareSystem.getUniqueChild(Files.class);
        WorkspaceProfiles workspaceProfiles = files.getWorkspaceProfilesDirectory();
        WorkspaceProfilePersistence persistence = this.getPersistence();
        if (profile != null) {
            profile.removeChildren(WorkspaceProfileModuleRef.class);
            profile.removeChildren(WorkspaceProfilePattern.class);
            loadResult = persistence.load(profile, profile.getFile());
        } else {
            loadResult = persistence.load(null, file);
            if (loadResult.isSuccess()) {
                workspaceProfiles.addChild((NamedElement)loadResult.getOutcome());
            }
        }
        return loadResult;
    }

    WorkspaceProfile set(IWorkerContext workerContext, String profileName, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'changeCurrentProfile' must not be null";
        assert (profileName != null && profileName.length() > 0) : "Parameter 'profileName' of method 'changeCurrentProfile' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'apply' must not be null";
        assert (!this.m_softwareSystem.isClearable()) : "System must not be clearable";
        WorkspaceProfile profile = this.getProfile(profileName);
        if (profile == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Workspace profile: ", new Object[]{profileName});
            return null;
        }
        LinkedHashMap<String, String> resolutionMappings = new LinkedHashMap<String, String>();
        Workspace workspace = this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        ArrayList<RootDirectoryPath> rootDirectoriesToRemove = new ArrayList<RootDirectoryPath>();
        LinkedHashMap<String, RootDirectoryPath> rootDirectoriesToAdd = new LinkedHashMap<String, RootDirectoryPath>();
        List<IWorkspaceProfilePattern> patterns = profile.getChildren(IWorkspaceProfilePattern.class);
        for (Module module : workspace.getChildren(Module.class)) {
            if (!module.supportsWorkspaceProfiles()) continue;
            for (RootDirectoryPath rootDirectoryPath : module.getChildren(module.getRootDirectoryPathClass())) {
                String identifyingPath = rootDirectoryPath.getIdentifyingPath();
                OperationResult translationResult = new OperationResult("Translate '" + identifyingPath + "'");
                String translatedPath = this.translatePath(patterns, module.getShortName(), identifyingPath, translationResult);
                if (translationResult.isSuccess()) {
                    if (translatedPath.trim().isEmpty()) {
                        result.addError((OperationResult.IMessageCause)IWorkspaceProfileProvider.PatternCause.INVALID_PATTERN, "Empty replacement of path '" + identifyingPath + "' is not valid." + StringUtility.LINE_SEPARATOR + "Workspace profile '" + profileName + "' cannot be applied.", new Object[0]);
                        continue;
                    }
                    RootDirectoryPath newPath = module.createRootDirectoryPath(this.m_softwareSystem, module, new TFile(translatedPath));
                    String newFullyQualifiedName = newPath.getFullyQualifiedName();
                    resolutionMappings.put(rootDirectoryPath.getFullyQualifiedName(), newFullyQualifiedName);
                    rootDirectoriesToRemove.add(rootDirectoryPath);
                    if (rootDirectoriesToAdd.containsKey(newFullyQualifiedName)) continue;
                    rootDirectoriesToAdd.put(newFullyQualifiedName, newPath);
                    continue;
                }
                result.addMessagesFrom(translationResult);
            }
        }
        if (result.isFailure()) {
            return null;
        }
        for (RootDirectoryPath rootDirectoryPath : rootDirectoriesToRemove) {
            rootDirectoryPath.remove();
        }
        for (Map.Entry entry : rootDirectoriesToAdd.entrySet()) {
            RootDirectoryPath rootDirectoryPath = (RootDirectoryPath)entry.getValue();
            rootDirectoryPath.getParent().addChild(rootDirectoryPath);
        }
        profile.setResolutionMappings(resolutionMappings);
        this.m_currentWorkspaceProfile = profile;
        if (!profile.overrideWorkspaceFilter()) {
            return profile;
        }
        ProductionCodeFilter productionCodeFilter = profile.getUniqueExistingChild(ProductionCodeFilter.class);
        if (productionCodeFilter.getNumberOfChildren() > 0) {
            ProductionCodeFilter workspaceFilter = workspace.getProductionCodeFilter();
            workspaceFilter.removeChildren(WildcardPattern.class);
            productionCodeFilter.getChildren(WildcardPatternInclude.class).stream().forEach(i -> workspaceFilter.addChild(new WildcardPatternInclude(workspaceFilter, i.getName())));
            productionCodeFilter.getChildren(WildcardPatternExclude.class).stream().forEach(e -> workspaceFilter.addChild(new WildcardPatternExclude(workspaceFilter, e.getName())));
        }
        return profile;
    }

    private String translatePath(List<IWorkspaceProfilePattern> patterns, String moduleShortName, String identifyingPath, OperationResult translationResult) {
        assert (patterns != null) : "Parameter 'profile' of method 'translatePath' must not be null";
        assert (moduleShortName != null && moduleShortName.length() > 0) : "Parameter 'moduleShortName' of method 'translatePath' must not be empty";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'translatePath' must not be empty";
        assert (translationResult != null) : "Parameter 'translationResult' of method 'translatePath' must not be null";
        String result = identifyingPath;
        Object input = identifyingPath;
        boolean atLeastOnePatternMatched = false;
        for (IWorkspaceProfilePattern pattern : patterns) {
            try {
                String cleanedPath;
                if (!moduleShortName.matches(pattern.getModuleMatcher()) || !result.matches(pattern.getRootPathMatcher())) continue;
                input = moduleShortName + SEPARATOR + result;
                String regexp = pattern.getModuleMatcher() + SEPARATOR + pattern.getRootPathMatcher();
                String replacedPath = ((String)input).replaceFirst(regexp, pattern.getRootPathReplacement());
                result = cleanedPath = replacedPath.replace(SEPARATOR, "");
                atLeastOnePatternMatched = true;
            }
            catch (IndexOutOfBoundsException | PatternSyntaxException ex) {
                translationResult.addError((OperationResult.IMessageCause)IWorkspaceProfileProvider.PatternCause.INVALID_PATTERN, "Failed to apply pattern '" + String.valueOf(pattern) + "'", new Object[]{ex});
                return "";
            }
        }
        return atLeastOnePatternMatched ? result.trim() : "";
    }

    private WorkspaceProfile getProfile(final String profileName) {
        assert (profileName != null && profileName.length() > 0) : "Parameter 'profileName' of method 'getProfile' must not be empty";
        return this.m_workspaceProfiles.getUniqueChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (namedElement instanceof WorkspaceProfile) {
                    WorkspaceProfile profile = (WorkspaceProfile)namedElement;
                    return profile.getFile().getName().equals(profileName);
                }
                return false;
            }
        }, WorkspaceProfile.class);
    }

    @Override
    public OperationResultWithOutcome<WorkspaceProfile> create(IWorkerContext workerContext, String name, String description, List<IWorkspaceProfilePattern> patterns, FilterModification filters) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createProfile' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createProfile' must not be empty";
        assert (this.getNameValidator().isValid(null, name).isSuccess()) : "Parameter 'name' of method 'createProfile' must not be empty";
        assert (patterns != null) : "Parameter 'patterns' of method 'createProfile' must not be null";
        assert (filters != null) : "Parameter 'filters' of method 'create' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Workspace Profile");
        this.checkOutOfSync((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile file = new TFile((File)this.m_workspaceProfiles.getFile(), name + CoreFileType.WORKSPACE_PROFILE.getDefaultExtension());
        WorkspaceProfile profile = new WorkspaceProfile((NamedElement)this.m_workspaceProfiles, file, this.m_softwareSystem.getUniqueExistingChild(Files.class));
        profile.setDescription(description);
        for (IWorkspaceProfilePattern next : patterns) {
            WorkspaceProfilePattern pattern = new WorkspaceProfilePattern(profile, next.getModuleMatcher(), next.getRootPathMatcher(), next.getRootPathReplacement());
            profile.addChild(pattern);
        }
        ProductionCodeFilter filter = new ProductionCodeFilter(profile);
        profile.addChild(filter);
        profile.setOverrideWorkspaceFilter(filters.overrideWorkspaceFilter());
        if (profile.overrideWorkspaceFilter() && filters.isModified() && !filters.isEmpty()) {
            filters.getPatterns().stream().forEach(i -> {
                i.setParent(filter);
                filter.addChild((NamedElement)i);
            });
        }
        OperationResultWithOutcome createResult = new OperationResultWithOutcome("Create pattern-based profile '" + name + "'");
        OperationResult saveResult = this.getPersistence().save(profile);
        createResult.addMessagesFrom(saveResult);
        if (saveResult.isSuccess()) {
            this.m_workspaceProfiles.addChild(profile);
            profile.setExistsOnDisk(true);
            profile.resetTimestamp();
            createResult.setOutcome((Object)profile);
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.noneOf(Modification.class), (OperationResult)createResult);
        return createResult;
    }

    @Override
    public ITextValidator getNameValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                } else {
                    result.addError("Input not valid");
                }
                if (!FileUtility.isValidName((String)newInput)) {
                    result.addError("Input not valid");
                } else if (newInput.endsWith(CoreFileType.WORKSPACE_PROFILE.getDefaultExtension())) {
                    result.addError("Extension will be added automatically");
                } else if (result.inputModified()) {
                    String newInputWithExtension = newInput + CoreFileType.WORKSPACE_PROFILE.getDefaultExtension();
                    for (WorkspaceProfile next : WorkspaceProfileExtension.this.m_workspaceProfiles.getChildren(WorkspaceProfile.class)) {
                        if (!next.getShortName().equalsIgnoreCase(newInputWithExtension)) continue;
                        result.addError("Profile with name '" + newInput + "' already exists");
                        break;
                    }
                }
                return result;
            }
        };
    }

    @Override
    public ITextValidator getMatchPatternValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                } else {
                    result.addError("Input not valid");
                }
                if (newInput.isEmpty()) {
                    result.addError("Must not be empty");
                }
                try {
                    "Test".replaceFirst(newInput, "");
                }
                catch (PatternSyntaxException ex) {
                    result.addError(ex.getMessage());
                }
                return result;
            }
        };
    }

    @Override
    public ITextValidator getReplacementPatternValidator(final IWorkspaceProfileProvider.MatcherPair matchers) {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Input not valid");
                    return result;
                }
                String trimmedInput = newInput.trim();
                if (trimmedInput.length() == 0) {
                    result.addError("Replacement pattern must not be empty");
                    return result;
                }
                if (matchers.getModuleMatcher() == null || matchers.getModuleMatcher().trim().length() == 0) {
                    result.addError("Module matcher must not be empty");
                    return result;
                }
                if (matchers.getRootPathMatcher() == null || matchers.getRootPathMatcher().trim().length() == 0) {
                    result.addError("Root path matcher must not be empty");
                    return result;
                }
                String input = "_______________~_-_-_-_-_~=====================";
                String regexp = matchers.getModuleMatcher().trim() + WorkspaceProfileExtension.SEPARATOR + matchers.getRootPathMatcher().trim();
                try {
                    "_______________~_-_-_-_-_~=====================".replaceFirst(regexp, trimmedInput);
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                    result.addError(ex.getMessage() + " (regular expression error)");
                }
                return result;
            }
        };
    }

    @Override
    public OperationResult delete(IWorkerContext workerContext, List<WorkspaceProfile> profiles) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteWorkspaceProfile' must not be null";
        assert (profiles != null && !profiles.isEmpty()) : "Parameter 'profiles' of method 'delete' must not be empty";
        OperationResult result = new OperationResult("Delete " + profiles.size() + " workspace profile(s)");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        for (WorkspaceProfile next : profiles) {
            SoftwareSystemFilesDirectory.removeFile(next.getFile(), false, result);
            next.remove();
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult modify(IWorkerContext workerContext, WorkspaceProfile profile, String newNameWithoutExtension, String newDescription, List<IWorkspaceProfilePattern> newPatterns, FilterModification filterModification) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'modifyProfile' must not be null";
        assert (profile != null) : "Parameter 'profile' of method 'modifyProfile' must not be null";
        assert (newNameWithoutExtension != null && newNameWithoutExtension.length() > 0) : "Parameter 'newNameWithoutExtension' of method 'modifyProfile' must not be empty";
        assert (newPatterns != null) : "Parameter 'newPatterns' of method 'modifyProfile' must not be null";
        assert (filterModification != null) : "Parameter 'filterModification' of method 'modify' must not be null";
        OperationResult result = new OperationResult("Modify profile '" + profile.getName() + "'");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        String newName = newNameWithoutExtension + CoreFileType.WORKSPACE_PROFILE.getDefaultExtension();
        boolean nameChanged = !profile.getFile().getName().equals(newName);
        profile.setNeedsSave(true);
        if (nameChanged) {
            TFile targetFile = new TFile((File)this.m_workspaceProfiles.getFile(), newName);
            try {
                profile.getFile().mv((File)targetFile);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            profile.setPath(targetFile);
        }
        profile.setDescription(newDescription);
        profile.removeChildren(WorkspaceProfilePattern.class);
        for (IWorkspaceProfilePattern next : newPatterns) {
            WorkspaceProfilePattern pattern = new WorkspaceProfilePattern(profile, next.getModuleMatcher(), next.getRootPathMatcher(), next.getRootPathReplacement());
            profile.addChild(pattern);
        }
        ProductionCodeFilter filter = profile.getUniqueChild(ProductionCodeFilter.class);
        filter.removeChildren(WildcardPattern.class);
        profile.setOverrideWorkspaceFilter(filterModification.overrideWorkspaceFilter());
        if (filterModification.overrideWorkspaceFilter() && filterModification.isModified() && !filterModification.isEmpty()) {
            filterModification.getPatterns().stream().forEach(i -> {
                i.setParent(filter);
                filter.addChild((NamedElement)i);
            });
        }
        if (nameChanged) {
            OperationResult saveResult = this.save(profile);
            result.addMessagesFrom(saveResult);
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.noneOf(Modification.class), result);
        return result;
    }

    public OperationResult save(WorkspaceProfile profile) {
        assert (profile != null) : "Parameter 'profile' of method 'save' must not be null";
        assert (profile.needsSave()) : "Does not need save: " + profile.getName();
        OperationResult saveResult = this.getPersistence().save(profile);
        if (saveResult.isSuccess()) {
            profile.setNeedsSave(false);
            profile.resetTimestamp();
        }
        return saveResult;
    }

    @Override
    public List<IWorkspaceProfilePattern> getPatterns(WorkspaceProfile profile) {
        assert (profile != null) : "Parameter 'profile' of method 'getProfilePatterns' must not be null";
        return profile.getChildren(WorkspaceProfilePattern.class).stream().map(p -> new WorkspaceProfilePatternModification(p.getModuleMatcher(), p.getRootPathMatcher(), p.getRootPathReplacement())).collect(Collectors.toList());
    }

    @Override
    public boolean isPossibleDirectory(DirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'isWorkspaceProfileDirectory' must not be null";
        return path == this.m_workspaceProfiles;
    }

    @Override
    public boolean hasChanged(WorkspaceProfile profile, String name, String description, List<IWorkspaceProfilePattern> patterns, FilterModification filterModifications) {
        assert (profile != null) : "Parameter 'profile' of method 'hasProfileChanged' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'hasProfileChanged' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'hasProfileChanged' must not be null";
        assert (patterns != null) : "Parameter 'patterns' of method 'hasChanged' must not be null";
        assert (filterModifications != null) : "Parameter 'filterModifications' of method 'hasChanged' must not be null";
        if (!FileUtility.getFileNameWithoutExtension((TFile)profile.getFile()).equals(name)) {
            return true;
        }
        if (!profile.getDescription().equals(description)) {
            return true;
        }
        return !this.getPatterns(profile).equals(patterns) || filterModifications.isModified();
    }

    @Override
    public boolean isCreationPossible() {
        return this.m_softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(namedElement instanceof Module)) {
                    return false;
                }
                Module module = (Module)namedElement;
                return module.supportsWorkspaceProfiles();
            }
        }, Module.class).size() > 0;
    }

    @Override
    public WorkspaceProfileRootPathMapping getRootDirectoryPathMapping(List<IWorkspaceProfilePattern> patterns) {
        assert (patterns != null) : "Parameter 'patterns' of method 'getRootDirectoryMapping' must not be null";
        WorkspaceProfileRootPathMapping mapping = new WorkspaceProfileRootPathMapping(patterns);
        Workspace workspace = this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        ITextValidator pathValidator = this.getMappingValidator(this.m_softwareSystem.getDirectoryFile());
        for (Module nextModule : workspace.getChildren(Module.class)) {
            if (!nextModule.supportsWorkspaceProfiles()) continue;
            for (RootDirectoryPath rootDirectoryPath : nextModule.getChildren(nextModule.getRootDirectoryPathClass())) {
                String identifyingPath = rootDirectoryPath.getIdentifyingPath();
                OperationResult translationResult = new OperationResult("Translate '" + identifyingPath + "'");
                String translatedPath = this.translatePath(patterns, nextModule.getShortName(), identifyingPath, translationResult);
                if (translationResult.isFailure()) {
                    ValidationResult result = new ValidationResult(false);
                    result.addError("Invalid pattern");
                    mapping.addMapping(nextModule, rootDirectoryPath, "", result);
                    continue;
                }
                mapping.addMapping(nextModule, rootDirectoryPath, translatedPath, pathValidator.isValid(identifyingPath, translatedPath));
            }
        }
        return mapping;
    }

    private ITextValidator getMappingValidator(final TFile baseDirectory) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'getMappingValidator' must not be null";
        assert (baseDirectory.exists() && baseDirectory.isDirectory()) : "baseDirectory must be an existing directory";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.trim().isEmpty()) {
                    result.addError("Translated path must not be empty");
                } else if (!result.inputModified()) {
                    result.addWarning("Path is not translated");
                } else {
                    TFile path = FileUtility.isAbsolutePath((String)newInput) ? new TFile(newInput) : new TFile((File)baseDirectory, newInput);
                    try {
                        if (!path.exists() || !path.isDirectory()) {
                            result.addWarning("Path '" + newInput + "' does not exist");
                        }
                    }
                    catch (InvalidPathException ex) {
                        result.addError("Invalid path: " + ex.getLocalizedMessage());
                    }
                    TrueZipFacade.clear((TFile)path);
                }
                return result;
            }
        };
    }
}

