/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.ReportExtension;
import com.hello2morrow.sonargraph.core.controller.system.SystemDiffProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.diff.DiffProcess;
import com.hello2morrow.sonargraph.core.controller.system.diff.PersistentDiffInfoHandler;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IReportExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISystemDiffExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.BaselinesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.Baseline;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffComputationFailed;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfiguration;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffLocalBaselineNotAccessible;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffSystemBaselineNotAccessible;
import com.hello2morrow.sonargraph.core.persistence.diff.BaselineReader;
import com.hello2morrow.sonargraph.core.persistence.diff.SystemDiffHtmlWriter;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemDiffExtension
extends SystemDiffProvider
implements ISystemDiffExtension,
Baseline.IInfoProvider,
IModifiableFileProvider,
IModifiableFileDeltaKey,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemDiffExtension.class);
    private static final Version MINIMUM_BASELINE_REPORT_VERSION = Version.create((String)"9.13.0");
    private final IFinishModelProcessor m_finishModelProcessor;
    private final PersistentDiffInfoHandler m_persistentInfoHandler;
    private SystemDiffConfiguration m_diffConfiguration;
    private LastBaselineReportProcessing m_lastBaselineSystem;

    SystemDiffExtension(SoftwareSystem softwareSystem, IAnalyzerController analyzerController, IFinishModelProcessor finishModelProcessor, SonargraphProduct product) {
        super(softwareSystem, analyzerController);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'SystemDiffExtension' must not be null";
        assert (product != null) : "Parameter 'product' of method 'SystemDiffExtension' must not be null";
        this.m_persistentInfoHandler = new PersistentDiffInfoHandler(softwareSystem, product);
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_finishModelProcessor.addListener(this);
    }

    private void checkBaselineIssues(AnalyzerConfigurationFile configurationFile, String baselinePath, BaselineType baselineType) {
        assert (this.isLicensed()) : "Not licensed";
        assert (configurationFile != null) : "Parameter 'configurationFile' of method 'checkBaselineIssues' must not be null";
        assert (baselinePath != null && baselinePath.length() > 0) : "Parameter 'baselinePath' of method 'checkBaselineIssues' must not be empty";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'checkBaselineIssues' must not be null";
        TFile baseline = FileUtility.isRelativePath((String)baselinePath) ? new TFile((File)this.getSoftwareSystem().getSystemDirectoryFile(), baselinePath) : new TFile(baselinePath);
        switch (baselineType) {
            case SYSTEM: {
                if (!baseline.exists()) {
                    configurationFile.addIssue(new SystemDiffSystemBaselineNotAccessible(configurationFile, baselineType.getPresentationName() + " baseline '" + FileUtility.getCanonicalFilePath((TFile)baseline) + "' not found"));
                    break;
                }
                if (baseline.canRead()) break;
                configurationFile.addIssue(new SystemDiffSystemBaselineNotAccessible(configurationFile, baselineType.getPresentationName() + " baseline '" + FileUtility.getCanonicalFilePath((TFile)baseline) + "' cannot be read"));
                break;
            }
            case LOCAL: {
                if (!baseline.exists()) {
                    configurationFile.addIssue(new SystemDiffLocalBaselineNotAccessible(configurationFile, baselineType.getPresentationName() + " baseline '" + FileUtility.getCanonicalFilePath((TFile)baseline) + "' not found"));
                    break;
                }
                if (baseline.canRead()) break;
                configurationFile.addIssue(new SystemDiffLocalBaselineNotAccessible(configurationFile, baselineType.getPresentationName() + " baseline '" + FileUtility.getCanonicalFilePath((TFile)baseline) + "' cannot be read"));
                break;
            }
            default: {
                assert (false) : "Unhandled baseline type: " + String.valueOf((Object)baselineType);
                break;
            }
        }
    }

    @Override
    public String getInformation(TFile file) {
        SystemDiffConfiguration diffConfiguration;
        TFile activeBaselineFile;
        assert (file != null) : "Parameter 'file' of method 'getInformation' must not be null";
        if (this.isLicensed() && (activeBaselineFile = (diffConfiguration = this.getSystemDiffConfiguration()).getActiveBaselineFile()) != null && FileUtility.refersToSameFile((TFile)activeBaselineFile, (TFile)file)) {
            return "Active, " + diffConfiguration.getBaselineType().getPresentationName();
        }
        return "";
    }

    @Override
    public void initialized(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        if (this.isLicensed()) {
            AnalyzerConfigurationFile systemDiffAnalyzerConfigurationFile = this.getSystemDiffAnalyzerConfigurationFile();
            systemDiffAnalyzerConfigurationFile.removeIssues(CoreIssueId.SYSTEM_DIFF_LOCAL_BASELINE_NOT_ACCESSIBLE);
            String localBaselinePath = this.m_persistentInfoHandler.getLocalBaselinePath();
            if (localBaselinePath != null && !localBaselinePath.isEmpty()) {
                this.checkBaselineIssues(systemDiffAnalyzerConfigurationFile, localBaselinePath, BaselineType.LOCAL);
            }
        }
    }

    @Override
    public void aboutToRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToRefresh' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'aboutToRefresh' must not be null";
        if (this.isLicensed()) {
            THashSet hasIssues;
            String localBaselinePath;
            AnalyzerConfigurationFile systemDiffAnalyzerConfigurationFile = this.getSystemDiffAnalyzerConfigurationFile();
            THashSet hadIssues = new THashSet(systemDiffAnalyzerConfigurationFile.getIssues(CoreIssueId.SYSTEM_DIFF_LOCAL_BASELINE_NOT_ACCESSIBLE, CoreIssueId.SYSTEM_DIFF_SYSTEM_BASELINE_NOT_ACCESSIBLE));
            systemDiffAnalyzerConfigurationFile.removeIssues(CoreIssueId.SYSTEM_DIFF_LOCAL_BASELINE_NOT_ACCESSIBLE, CoreIssueId.SYSTEM_DIFF_SYSTEM_BASELINE_NOT_ACCESSIBLE);
            String systemBaselinePath = this.getSystemDiffAnalyzerConfiguration().getBaselinePath();
            if (systemBaselinePath != null && !systemBaselinePath.isEmpty()) {
                this.checkBaselineIssues(systemDiffAnalyzerConfigurationFile, systemBaselinePath, BaselineType.SYSTEM);
            }
            if ((localBaselinePath = this.m_persistentInfoHandler.getLocalBaselinePath()) != null && !localBaselinePath.isEmpty()) {
                this.checkBaselineIssues(systemDiffAnalyzerConfigurationFile, localBaselinePath, BaselineType.LOCAL);
            }
            if (!hadIssues.equals(hasIssues = new THashSet(systemDiffAnalyzerConfigurationFile.getIssues(CoreIssueId.SYSTEM_DIFF_LOCAL_BASELINE_NOT_ACCESSIBLE, CoreIssueId.SYSTEM_DIFF_SYSTEM_BASELINE_NOT_ACCESSIBLE)))) {
                modifications.add(Modification.BASELINE_MODIFIED);
            }
        }
    }

    @Override
    public void analyzerConfigurationChanged(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        if (configuration instanceof SystemDiffAnalyzerConfiguration) {
            String localBaselinePath;
            assert (this.isLicensed()) : "Not licensed";
            this.m_diffConfiguration = null;
            this.m_lastBaselineSystem = null;
            SystemDiffAnalyzerConfiguration systemDiffAnalyzerConfiguration = this.getSystemDiffAnalyzerConfiguration();
            AnalyzerConfigurationFile systemDiffAnalyzerConfigurationFile = this.getSystemDiffAnalyzerConfigurationFile();
            systemDiffAnalyzerConfigurationFile.removeIssues(CoreIssueId.SYSTEM_DIFF_SYSTEM_BASELINE_NOT_ACCESSIBLE, CoreIssueId.SYSTEM_DIFF_LOCAL_BASELINE_NOT_ACCESSIBLE, CoreIssueId.SYSTEM_DIFF_COMPUTATION_FAILED);
            String systembBaselinePath = systemDiffAnalyzerConfiguration.getBaselinePath();
            if (systembBaselinePath == null || systembBaselinePath.isEmpty()) {
                if (systemDiffAnalyzerConfiguration.isEnabled()) {
                    systemDiffAnalyzerConfigurationFile.addIssue(new SystemDiffSystemBaselineNotAccessible(systemDiffAnalyzerConfigurationFile, "System baseline enabled but no baseline specified"));
                }
            } else {
                this.checkBaselineIssues(systemDiffAnalyzerConfigurationFile, systembBaselinePath, BaselineType.SYSTEM);
            }
            if ((localBaselinePath = this.m_persistentInfoHandler.getLocalBaselinePath()) != null && !localBaselinePath.isEmpty()) {
                this.checkBaselineIssues(systemDiffAnalyzerConfigurationFile, localBaselinePath, BaselineType.LOCAL);
            }
            if (modifications != null) {
                modifications.add(Modification.BASELINE_MODIFIED);
            }
        }
    }

    @Override
    public void computeSystemDiff(IWorkerContext workerContext, AnalyzerResult analyzerResult) {
        ISystemInfoProcessor baselineSystemInfoProcessor;
        ISoftwareSystem baselineSystem;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeSystemDiff' must not be null";
        assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'computeSystemDiff' must not be null";
        assert (this.isLicensed()) : "No licensed";
        SystemDiffConfiguration diffConfiguration = this.getSystemDiffConfiguration();
        BaselineType baselineType = diffConfiguration.getBaselineType();
        if (baselineType == null) {
            LOGGER.info("Baseline inactive");
            return;
        }
        long start = System.currentTimeMillis();
        workerContext.setNumberOfSteps(4, new int[]{40, 10, 25, 25});
        workerContext.working("Compute system diff", true);
        TFile baselineReport = diffConfiguration.getActiveBaselineFile();
        LOGGER.info("Compute diff using " + StringUtility.firstCharacterCase((String)baselineType.getPresentationName(), (boolean)true) + " baseline: " + FileUtility.getCanonicalFilePath((TFile)baselineReport));
        if (this.m_lastBaselineSystem != null && baselineReport.lastModified() == this.m_lastBaselineSystem.getReportFileLastModified() && FileUtility.areEqual((TFile)baselineReport, (TFile)this.m_lastBaselineSystem.getReportFile())) {
            LOGGER.info("Use already created baseline system");
            assert (baselineType.equals((Object)this.m_lastBaselineSystem.getBaselineType())) : "Baseline type does not match";
            baselineSystem = this.m_lastBaselineSystem.getSystem();
            baselineSystemInfoProcessor = this.m_lastBaselineSystem.getSystemInfoProcessor();
        } else {
            LOGGER.info("Create baseline system");
            ISonargraphSystemController controller = ControllerFactory.createController();
            AnalyzerConfigurationFile systemDiffAnalyzerConfigurationFile = this.getSystemDiffAnalyzerConfigurationFile();
            systemDiffAnalyzerConfigurationFile.removeIssues(CoreIssueId.SYSTEM_DIFF_COMPUTATION_FAILED);
            try {
                Throwable throwable = null;
                Object var13_14 = null;
                try (TFileInputStream in = new TFileInputStream((File)baselineReport);){
                    Result loadBaselineSystemResult = controller.loadSystemReport((InputStream)in, (File)this.getSoftwareSystem().getDirectoryFile());
                    if (loadBaselineSystemResult.isFailure()) {
                        this.m_lastBaselineSystem = null;
                        LOGGER.error("Failed to read baseline report '" + baselineReport.getAbsolutePath() + "': " + loadBaselineSystemResult.toString());
                        systemDiffAnalyzerConfigurationFile.addIssue(new SystemDiffComputationFailed(systemDiffAnalyzerConfigurationFile, "Failed to read baseline report"));
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.m_lastBaselineSystem = null;
                LOGGER.error("Failed to read baseline report: ", (Throwable)e);
                String description = "Failed to read baseline report '" + baselineReport.getAbsolutePath() + "': " + e.getMessage();
                systemDiffAnalyzerConfigurationFile.addIssue(new SystemDiffComputationFailed(systemDiffAnalyzerConfigurationFile, description));
                return;
            }
            baselineSystem = controller.getSoftwareSystem();
            Version baselineReportVersion = Version.create((String)baselineSystem.getVersion());
            if (baselineReportVersion.isBefore(MINIMUM_BASELINE_REPORT_VERSION)) {
                this.m_lastBaselineSystem = null;
                String description = "Baseline report has been created with version '" + String.valueOf(baselineReportVersion) + "' which is not suitable for system diff - at least version '" + MINIMUM_BASELINE_REPORT_VERSION.toString(3) + "' is required";
                systemDiffAnalyzerConfigurationFile.addIssue(new SystemDiffComputationFailed(systemDiffAnalyzerConfigurationFile, description));
                return;
            }
            baselineSystemInfoProcessor = controller.createSystemInfoProcessor();
            LOGGER.debug("Needed {} ms to load baseline report", (Object)(System.currentTimeMillis() - start));
        }
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        DiffProcess diffProcess = new DiffProcess(this.getSoftwareSystem(), this.m_finishModelProcessor.getLicenseProvider().getAvailableFeatures());
        diffProcess.execute(workerContext, analyzerResult, baselineSystem, baselineSystemInfoProcessor, baselineType, baselineReport);
        this.m_lastBaselineSystem = new LastBaselineReportProcessing(baselineReport, baselineSystem, baselineSystemInfoProcessor, baselineType);
        LOGGER.info("Compute diff using " + StringUtility.firstCharacterCase((String)baselineType.getPresentationName(), (boolean)true) + " baseline: " + FileUtility.getCanonicalFilePath((TFile)baselineReport) + " - done (" + (System.currentTimeMillis() - start) + " ms)");
    }

    @Override
    public void systemDiffCleared() {
        assert (this.isLicensed()) : "No licensed";
        this.getSystemDiffAnalyzerConfigurationFile().removeIssues(CoreIssueId.SYSTEM_DIFF_COMPUTATION_FAILED);
    }

    @Override
    public OperationResultWithOutcome<Map<IFileType, TFile>> createSystemDiffReport(IWorkerContext workerContext, IReport report, TFile targetDirectory, String targetFileName, Set<IFileType> requestedFileTypes, TFile baselineXmlReport, String mainReportName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createSystemDiffReports' must not be null";
        assert (report != null) : "Parameter 'report' of method 'createSystemDiffReports' must not be null";
        assert (this.isLicensed()) : "No licensed";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create system diff report");
        workerContext.beginSubTask("Create system diff report");
        workerContext.setNumberOfSteps(4, new int[]{40, 10, 25, 25});
        SoftwareSystemDiff systemDiff = this.getSoftwareSystemDiff();
        if (systemDiff != null && requestedFileTypes.contains((Object)CoreFileType.REPORT_HTML)) {
            SystemDiffHtmlWriter htmlWriter = new SystemDiffHtmlWriter(systemDiff, report);
            Map<CoreFileType, TFile> targetFiles = this.createSystemDiffTargetFiles(targetDirectory, targetFileName, requestedFileTypes, new Date(report.getTimestamp()));
            OperationResultWithOutcome<TFile> htmlReportResult = htmlWriter.writeReport(targetFiles.get((Object)CoreFileType.REPORT_HTML), mainReportName);
            result.addMessagesFrom(htmlReportResult);
            if (htmlReportResult.isSuccess()) {
                HashMap<CoreFileType, TFile> outcome = new HashMap<CoreFileType, TFile>();
                outcome.put(CoreFileType.REPORT_HTML, (TFile)htmlReportResult.getOutcome());
                result.setOutcome(outcome);
            }
        }
        workerContext.endSubTask();
        return result;
    }

    private Map<CoreFileType, TFile> createSystemDiffTargetFiles(TFile targetDirectory, String reportFileName, Set<IFileType> requestedFileTypes, Date timestamp) {
        assert (targetDirectory != null && targetDirectory.isDirectory() && targetDirectory.exists()) : "Parameter 'targetDirectory' of method 'createSystemDiffTargetFiles' must be an existing directory";
        assert (reportFileName != null) : "Parameter 'reportFileName' of method 'createSystemDiffTargetFiles' must not be null";
        assert (requestedFileTypes != null && !requestedFileTypes.isEmpty()) : "Parameter 'reportFormats' of method 'createSystemDiffTargetFiles' must not be empty";
        assert (timestamp != null) : "Parameter 'timestamp' of method 'createSystemDiffTargetFiles' must not be null";
        HashMap<CoreFileType, TFile> targetFiles = new HashMap<CoreFileType, TFile>(requestedFileTypes.size());
        this.addTargetSystemDiffFile(targetDirectory, requestedFileTypes, reportFileName, targetFiles, CoreFileType.REPORT_HTML);
        this.addTargetSystemDiffFile(targetDirectory, requestedFileTypes, reportFileName, targetFiles, CoreFileType.REPORT_XML);
        return targetFiles;
    }

    private void addTargetSystemDiffFile(TFile targetDirectory, Set<IFileType> requestedFileTypes, String reportFileName, Map<CoreFileType, TFile> targetFiles, CoreFileType fileType) {
        if (requestedFileTypes.contains((Object)fileType)) {
            TFile targetFile = new TFile((File)targetDirectory, reportFileName + fileType.getDefaultExtension());
            targetFiles.put(fileType, targetFile);
        }
    }

    @Override
    public List<BaselineInfo> getRecentlyUsedBaselineReports(BaselineType type) {
        assert (type != null) : "Parameter 'type' of method 'getRecentlyUsedBaselineReports' must not be null";
        return this.m_persistentInfoHandler.getRecentlyUsedBaselineReports(type);
    }

    @Override
    public TFile getHiddenBaselinesDirectory() {
        return this.m_persistentInfoHandler.getHiddenBaselinesDirectory();
    }

    @Override
    public OperationResultWithOutcome<Map<IReport.Format, TFile>> createSystemDiffReport(IWorkerContext workerContext, TFile outputDirectory, Set<IReport.Format> reportFormats, String targetFileName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createReport' must not be null";
        assert (outputDirectory != null) : "Parameter 'outputDirectory' of method 'createReport' must not be null";
        assert (reportFormats != null && !reportFormats.isEmpty()) : "Parameter 'reportFormats' of method 'createReport' must not be empty";
        if (targetFileName == null) {
            targetFileName = this.createDefaultDiffFileName(new Date());
        }
        workerContext.setNumberOfSteps(6, new int[]{10, 20, 10, 25, 25, 10});
        workerContext.beginSubTask("Waiting for analyzers to complete");
        AnalyzerExtension analyzerExtension = this.getSoftwareSystem().getExtension(AnalyzerExtension.class);
        analyzerExtension.waitForAnalyzersToComplete(workerContext);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        IReportExtension reportExtension = this.getSoftwareSystem().getExtension(IReportExtension.class);
        IReport currentReport = reportExtension.createReportObjectForBasicSystemInfo(workerContext);
        OperationResultWithOutcome createReportResult = new OperationResultWithOutcome("Creating report for system diff");
        List<Issue> issues = this.getSystemDiffComputationErrorIssues();
        if (!issues.isEmpty()) {
            String message = issues.stream().map(i -> i.getDescription()).collect(Collectors.joining(" "));
            createReportResult.addError((OperationResult.IMessageCause)ReportExtension.MessageCause.FAILED_TO_LOAD_BASELINE_SYSTEM_XML_REPORT, message, new Object[0]);
            return createReportResult;
        }
        SoftwareSystemDiff softwareSystemDiff = this.getSoftwareSystemDiff();
        assert (softwareSystemDiff != null) : "Missing systemDiff";
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        HashMap<IReport.Format, TFile> outputFiles = new HashMap<IReport.Format, TFile>(2);
        if (reportFormats.contains((Object)IReport.Format.HTML)) {
            SystemDiffHtmlWriter htmlWriter = new SystemDiffHtmlWriter(softwareSystemDiff, currentReport);
            OperationResultWithOutcome<TFile> htmlReportResult = htmlWriter.writeReport(new TFile((File)outputDirectory, targetFileName + CoreFileType.REPORT_HTML.getDefaultExtension()), null);
            createReportResult.addMessagesFrom(htmlReportResult);
            TFile outcome = (TFile)htmlReportResult.getOutcome();
            outputFiles.put(IReport.Format.HTML, outcome);
            createReportResult.setOutcome(outputFiles);
        }
        return createReportResult;
    }

    @Override
    public OperationResult deactivateBaseline(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deactivateBaseline' must not be null";
        assert (this.isLicensed()) : "No licensed";
        SystemDiffConfiguration diffConfiguration = this.getSystemDiffConfiguration();
        assert (diffConfiguration.getBaselineType() != null) : "No baseline active";
        OperationResult result = new OperationResult("Deactivate Baseline");
        this.m_lastBaselineSystem = null;
        this.m_persistentInfoHandler.setLocalBaselineEnabled(result, false);
        SystemDiffAnalyzerConfiguration diffAnalyzerConfiguration = this.getSystemDiffAnalyzerConfiguration().copy();
        String systemBaselinePath = diffAnalyzerConfiguration.getBaselinePath();
        if (systemBaselinePath == null || systemBaselinePath.isEmpty()) {
            if (diffAnalyzerConfiguration.isEnabled()) {
                diffAnalyzerConfiguration.setBaselinePath("", false);
            }
        } else {
            diffAnalyzerConfiguration.setBaselinePath(systemBaselinePath, false);
        }
        this.getSoftwareSystem().getExtension(AnalyzerExtension.class).applyEditedConfiguration(workerContext, diffAnalyzerConfiguration, true);
        return result;
    }

    @Override
    public OperationResultWithOutcome<TFile> computeAndSetBaseline(IWorkerContext workerContext, String fileName, TFile baselineDirectory, String baselineDescription, BaselineType baselineType) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateDelta' must not be null";
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'computeAndSetBaseline' must not be empty";
        assert (baselineDirectory != null) : "Parameter 'baselineDirectory' of method 'computeDiff' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'computeAndSetBaseline' must not be null";
        assert (this.isLicensed()) : "No licensed";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Creating baseline report and trigger computation of system diff");
        IReportExtension reportExtension = this.getSoftwareSystem().getExtension(IReportExtension.class);
        IReportExtension.CreateReportRequest createReportRequest = new IReportExtension.CreateReportRequest();
        createReportRequest.setReportFileName(fileName);
        createReportRequest.setReportDirectory(baselineDirectory);
        createReportRequest.setReportFormats(EnumSet.of(IReport.Format.XML));
        if (baselineDescription != null) {
            createReportRequest.setReportDescription(baselineDescription);
        }
        createReportRequest.setMetricLevels(IReportExtension.CreateReportRequest.STANDARD_METRIC_LEVELS);
        workerContext.working("Create baseline report", true);
        OperationResultWithOutcome<CreateReportResult> createReportResult = reportExtension.createReport(workerContext, createReportRequest);
        result.addMessagesFrom(createReportResult);
        if (result.isFailure()) {
            this.m_lastBaselineSystem = null;
            return result;
        }
        TFile baselineReport = ((CreateReportResult)createReportResult.getOutcome()).getTargetFile(IReport.Format.XML);
        assert (baselineReport != null) : "baselineReport must not be null!";
        result.setOutcome((Object)baselineReport);
        if (FileUtility.refersToSameFile((TFile)baselineDirectory, (TFile)this.getBaselinesDirectory().getFile())) {
            BaselinesDirectory baselinesDirectory = this.getBaselinesDirectory();
            Baseline existingBaseline = baselinesDirectory.getUniqueChild(namedElement -> {
                if (namedElement instanceof Baseline) {
                    return FileUtility.areEqual((TFile)baselineReport, (TFile)((Baseline)namedElement).getFile());
                }
                return false;
            }, Baseline.class);
            if (existingBaseline != null) {
                existingBaseline.remove();
            }
            try {
                BaselineReader reader = new BaselineReader();
                OperationResultWithOutcome<BaselineInfo> infoResult = reader.read(baselineReport);
                if (infoResult.isFailure()) {
                    result.addMessagesFrom(infoResult);
                    return result;
                }
                Baseline baseline = new Baseline(baselinesDirectory, baselineReport, this.getSoftwareSystem().getUniqueExistingChild(Files.class), this, ((BaselineInfo)infoResult.getOutcome()).getCreationTime(), baselineDescription != null ? baselineDescription : "");
                baselinesDirectory.addChild(baseline);
            }
            catch (Exception e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, "Failed to process report file '" + String.valueOf(baselineReport) + "'", new Object[]{e});
            }
        }
        this.setBaseline(workerContext, baselineType, baselineReport);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.BASELINE_MODIFIED), (OperationResult)result);
        return result;
    }

    @Override
    public List<Issue> getSystemDiffComputationErrorIssues() {
        return this.isLicensed() ? this.getSystemDiffAnalyzerConfigurationFile().getIssues(CoreIssueId.SYSTEM_DIFF_COMPUTATION_FAILED) : Collections.emptyList();
    }

    @Override
    public List<Issue> getSystemBaselineNotAccessibleIssues() {
        return this.isLicensed() ? this.getSystemDiffAnalyzerConfigurationFile().getIssues(CoreIssueId.SYSTEM_DIFF_SYSTEM_BASELINE_NOT_ACCESSIBLE) : Collections.emptyList();
    }

    @Override
    public List<Issue> getLocalBaselineNotAccessibleIssues() {
        return this.isLicensed() ? this.getSystemDiffAnalyzerConfigurationFile().getIssues(CoreIssueId.SYSTEM_DIFF_LOCAL_BASELINE_NOT_ACCESSIBLE) : Collections.emptyList();
    }

    @Override
    public OperationResult setBaseline(IWorkerContext workerContext, BaselineType baselineType, TFile baseline) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'setBaseline' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'setBaseline' must not be null";
        assert (baseline != null) : "Parameter 'baselinet' of method 'setBaseline' must not be null";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'setBaseline' must not be null";
        LOGGER.info("Set " + StringUtility.firstCharacterCase((String)baselineType.getPresentationName(), (boolean)true) + " baseline: " + FileUtility.getCanonicalFilePath((TFile)baseline));
        OperationResult result = new OperationResult("Set " + baselineType.getPresentationName() + " baseline");
        if (!baseline.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, baselineType.getPresentationName() + " baseline '" + baseline.getNormalizedAbsolutePath() + "' not found.", new Object[0]);
        } else if (!baseline.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION, "No permission to read " + baselineType.getPresentationName() + " baseline '" + baseline.getNormalizedAbsolutePath() + "'.", new Object[0]);
        }
        String baselinePath = FileUtility.calculateRelativePath((TFile)baseline, (TFile)softwareSystem.getSystemDirectoryFile());
        LOGGER.info("Use baseline path: " + baselinePath);
        SystemDiffAnalyzerConfiguration diffConfiguration = this.getSystemDiffAnalyzerConfiguration().copy();
        this.m_lastBaselineSystem = null;
        this.m_diffConfiguration = null;
        switch (baselineType) {
            case SYSTEM: {
                this.m_persistentInfoHandler.setLocalBaselineEnabled(result, false);
                diffConfiguration.setBaselinePath(baselinePath, true);
                break;
            }
            case LOCAL: {
                this.m_persistentInfoHandler.setLocalBaseline(baseline, baselinePath, true, result);
                break;
            }
            default: {
                assert (false) : "Unhandled baseline type: " + String.valueOf((Object)baselineType);
                break;
            }
        }
        this.m_persistentInfoHandler.addLastRecentlyUsed(baseline, baselineType);
        softwareSystem.getExtension(AnalyzerExtension.class).applyEditedConfiguration(workerContext, diffConfiguration, true);
        return result;
    }

    @Override
    public OperationResult enableBaseline(IWorkerContext workerContext, BaselineType baselineType, boolean enable) {
        assert (this.isLicensed()) : "Not licensed";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'enableBaseline' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'enableBaseline' must not be null";
        OperationResult result = new OperationResult((enable ? "Enable " : "Disable ") + baselineType.getPresentationName() + " baseline");
        SystemDiffConfiguration systemDiffConfiguration = this.getSystemDiffConfiguration();
        SystemDiffAnalyzerConfiguration originalSystemDiffAnalyzerConfiguration = this.getSystemDiffAnalyzerConfiguration();
        SystemDiffAnalyzerConfiguration editedSystemDiffAnalyzerConfiguration = originalSystemDiffAnalyzerConfiguration.copy();
        this.m_diffConfiguration = null;
        switch (baselineType) {
            case SYSTEM: {
                assert (systemDiffConfiguration.getSystemBaseline() != null) : "Method 'enableBaseline': No system baseline configured";
                assert (editedSystemDiffAnalyzerConfiguration.isEnabled() != enable) : "System baseline already " + (enable ? "enabled" : "disabled");
                editedSystemDiffAnalyzerConfiguration.setEnabled(enable);
                result.addMessagesFromAndSetOutcome(this.getSoftwareSystem().getExtension(AnalyzerExtension.class).applyEditedConfiguration(workerContext, editedSystemDiffAnalyzerConfiguration, true));
                break;
            }
            case LOCAL: {
                assert (systemDiffConfiguration.getLocalBaseline() != null) : "Method 'enableBaseline': No local baseline configured";
                this.m_persistentInfoHandler.setLocalBaselineEnabled(result, enable);
                result.addMessagesFromAndSetOutcome(this.getSoftwareSystem().getExtension(AnalyzerExtension.class).applyEditedConfiguration(workerContext, editedSystemDiffAnalyzerConfiguration, true));
                break;
            }
            default: {
                assert (false) : "Unhandled baseline type: " + String.valueOf((Object)baselineType);
                break;
            }
        }
        return result;
    }

    @Override
    public OperationResult deleteLocalBaselineConfiguration(IWorkerContext workerContext) {
        assert (this.isLicensed()) : "Not licensed";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteLocalBaselineConfiguration' must not be null";
        OperationResult result = new OperationResult("Delete local baseline configuration");
        SystemDiffConfiguration systemDiffConfiguration = this.getSystemDiffConfiguration();
        this.m_diffConfiguration = null;
        assert (systemDiffConfiguration.getLocalBaseline() != null) : "Method 'enableBaseline': No local baseline configured";
        this.m_persistentInfoHandler.deleteLocalBaselineEntry(result);
        result.addMessagesFromAndSetOutcome(this.getSoftwareSystem().getExtension(AnalyzerExtension.class).applyEditedConfiguration(workerContext, this.getSystemDiffAnalyzerConfiguration().copy(), true));
        return result;
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        this.getBaselinesDirectory().checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return SystemDiffExtension.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!$assertionsDisabled && modifiableFile == null) {
                    throw new AssertionError((Object)"Parameter 'modifiableFile' of method 'exists' must not be null");
                }
                return modifiableFile instanceof Baseline;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return SystemDiffExtension.this.getBaselinesDirectory();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.BASELINE);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return "Baseline";
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return SystemDiffExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof Baseline)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                SystemDiffExtension.this.addBaseline(modified.getFile(), (Baseline)modified);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof Baseline)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                Baseline toBeRemoved = (Baseline)deleted;
                toBeRemoved.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                result.addMessagesFrom(SystemDiffExtension.this.addBaseline(file, null));
            }
        }, true);
    }

    @Override
    public OperationResultWithOutcome<Baseline> addBaseline(IWorkerContext workerContext, TFile file) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addBaseline' must not be null";
        assert (file != null) : "Parameter 'file' of method 'addBaseline' must not be null";
        assert (this.isLicensed()) : "No licensed";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Adding file as baseline");
        BaselinesDirectory baselines = this.getBaselinesDirectory();
        try {
            if (!FileUtility.areEqual((TFile)baselines.getFile(), (TFile)file.getParentFile())) {
                result.addWarning((OperationResult.IMessageCause)BaselineMessageCause.NO_CHILD_OF_BASELINES_DIRECTORY, "Baseline has not been added to 'Baselines' directory.", new Object[0]);
                OperationResultWithOutcome operationResultWithOutcome = result;
                return operationResultWithOutcome;
            }
            Baseline existing = baselines.getChildren(Baseline.class).stream().filter(b -> FileUtility.areEqual((TFile)file, (TFile)b.getFile())).findFirst().orElse(null);
            result.addMessagesFrom(this.addBaseline(file, existing));
            OperationResultWithOutcome operationResultWithOutcome = result;
            return operationResultWithOutcome;
        }
        finally {
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.BASELINE_MODIFIED), (OperationResult)result);
        }
    }

    private OperationResult addBaseline(TFile file, Baseline baseline) {
        assert (file != null) : "Parameter 'contentFile' of method 'addBaseline' must not be null";
        OperationResultWithOutcome loadResult = new OperationResultWithOutcome("Adding baseline to model");
        BaselinesDirectory baselinesDirectory = this.getBaselinesDirectory();
        if (baseline == null) {
            try {
                OperationResultWithOutcome<BaselineInfo> infoResult = new BaselineReader().read(file);
                if (!infoResult.isSuccess()) {
                    return loadResult;
                }
                BaselineInfo info = (BaselineInfo)infoResult.getOutcome();
                baseline = new Baseline(baselinesDirectory, file, this.getSoftwareSystem().getUniqueExistingChild(Files.class), this, info.getCreationTime(), info.getDescription());
                baselinesDirectory.addChild(baseline);
            }
            catch (Exception exception) {}
        } else {
            baseline.reloaded(file.lastModified(), false);
        }
        baseline.setExistsOnDisk(true);
        baseline.resetTimestamp();
        TrueZipFacade.clear((TFile)file);
        loadResult.setOutcome((Object)baseline);
        return loadResult;
    }

    @Override
    public SystemDiffConfiguration getSystemDiffConfiguration() {
        if (this.m_diffConfiguration == null) {
            if (this.isLicensed()) {
                SystemDiffAnalyzerConfiguration analyzerConfiguration = this.getSystemDiffAnalyzerConfiguration();
                String systemBaselinePath = analyzerConfiguration.getBaselinePath();
                boolean isSystemBaselineEnabled = analyzerConfiguration.isEnabled();
                TFile systemBaseline = null;
                if (systemBaselinePath != null && !systemBaselinePath.isEmpty()) {
                    systemBaseline = FileUtility.isRelativePath((String)systemBaselinePath) ? new TFile((File)this.getSoftwareSystem().getSystemDirectoryFile(), systemBaselinePath) : new TFile(systemBaselinePath);
                } else if (isSystemBaselineEnabled) {
                    LOGGER.warn("Disable system baseline usage because no system baseline specified.");
                    isSystemBaselineEnabled = false;
                }
                StrictPair<TFile, Boolean> localBaselineInfo = this.m_persistentInfoHandler.getLocalBaselineInfo(this.getSoftwareSystem().getSystemDirectoryFile());
                this.m_diffConfiguration = new SystemDiffConfiguration(systemBaseline, isSystemBaselineEnabled, localBaselineInfo != null ? (TFile)localBaselineInfo.getFirst() : null, localBaselineInfo != null ? (Boolean)localBaselineInfo.getSecond() : false);
            } else {
                this.m_diffConfiguration = new SystemDiffConfiguration(null, false, null, false);
            }
        }
        return this.m_diffConfiguration;
    }

    @Override
    public void savedAs(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, EnumSet<Modification> modifications, TFile oldSystemDirectory, OperationResult result, boolean baseDirectoryChanged) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'savedAs' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'savedAs' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'savedAs' must not be null";
        assert (oldSystemDirectory != null) : "Parameter 'oldSystemDirectory' of method 'savedAs' must not be null";
        assert (result != null) : "Parameter 'result' of method 'savedAs' must not be null";
        if (this.isLicensed()) {
            String localBaselinePath;
            SystemDiffAnalyzerConfiguration systemDiffAnalyzerConfiguration = this.getSystemDiffAnalyzerConfiguration();
            String systemBaselinePath = systemDiffAnalyzerConfiguration.getBaselinePath();
            if (systemBaselinePath != null && !systemBaselinePath.isEmpty()) {
                TFile systemBaseline = new TFile((File)oldSystemDirectory, systemBaselinePath);
                String newSystemBaselinePath = FileUtility.calculateRelativePath((TFile)systemBaseline, (TFile)this.getSoftwareSystem().getSystemDirectoryFile());
                systemDiffAnalyzerConfiguration.setBaselinePath(newSystemBaselinePath, systemDiffAnalyzerConfiguration.isEnabled());
            }
            if ((localBaselinePath = this.m_persistentInfoHandler.getLocalBaselinePath()) != null && !localBaselinePath.isEmpty()) {
                TFile localBaseline = new TFile((File)oldSystemDirectory, localBaselinePath);
                String newLocalBaselinePath = FileUtility.calculateRelativePath((TFile)localBaseline, (TFile)this.getSoftwareSystem().getSystemDirectoryFile());
                this.m_persistentInfoHandler.setLocalBaseline(localBaseline, newLocalBaselinePath, this.m_persistentInfoHandler.isLocalBaselineEnabled(), result);
            }
            this.m_diffConfiguration = null;
            this.m_lastBaselineSystem = null;
            modifications.add(Modification.BASELINE_MODIFIED);
        }
    }

    @Override
    public OperationResult deleteBaselines(IWorkerContext workerContext, List<Baseline> baselines) {
        assert (this.isLicensed()) : "No licensed";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteBaselines' must not be null";
        assert (baselines != null && !baselines.isEmpty()) : "Parameter 'baselines' of method 'deleteBaselines' must not be empty";
        OperationResult result = new OperationResult("Delete baseline(s)");
        SystemDiffConfiguration diffConfiguration = this.getSystemDiffConfiguration();
        TFile systemBaselineFile = diffConfiguration.getSystemBaseline();
        TFile localBaselineFile = diffConfiguration.getLocalBaseline();
        boolean deletedSystemBaseline = false;
        boolean deletedLocalBaseline = false;
        if (systemBaselineFile != null || localBaselineFile != null) {
            for (Baseline nextBaseline : baselines) {
                if (!deletedSystemBaseline && FileUtility.refersToSameFile((TFile)systemBaselineFile, (TFile)nextBaseline.getFile())) {
                    deletedSystemBaseline = true;
                }
                if (deletedLocalBaseline || !FileUtility.refersToSameFile((TFile)localBaselineFile, (TFile)nextBaseline.getFile())) continue;
                deletedLocalBaseline = true;
            }
        }
        for (Baseline next : baselines) {
            this.m_persistentInfoHandler.deleted(next.getFile(), result);
            SoftwareSystemFilesDirectory.removeFile(next.getFile(), false, result);
            next.remove();
        }
        if (deletedSystemBaseline || deletedLocalBaseline) {
            this.m_diffConfiguration = null;
            this.m_lastBaselineSystem = null;
            SystemDiffAnalyzerConfiguration diffAnalyzerConfiguration = this.getSystemDiffAnalyzerConfiguration().copy();
            if (deletedSystemBaseline) {
                diffAnalyzerConfiguration.setBaselinePath("", false);
            }
            this.getSoftwareSystem().getExtension(AnalyzerExtension.class).applyEditedConfiguration(workerContext, diffAnalyzerConfiguration, true);
        } else {
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.BASELINE_MODIFIED), result);
        }
        return result;
    }

    private static enum BaselineMessageCause implements OperationResult.IMessageCause
    {
        NO_CHILD_OF_BASELINES_DIRECTORY;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static final class LastBaselineReportProcessing {
        private final TFile m_reportFile;
        private final long m_reportFileLastModified;
        private final ISoftwareSystem m_baselineSystem;
        private final ISystemInfoProcessor m_systemInfoProcessor;
        private final BaselineType m_baselineType;

        public LastBaselineReportProcessing(TFile reportFile, ISoftwareSystem baselineSystem, ISystemInfoProcessor systemInfoProcessor, BaselineType type) {
            assert (reportFile != null) : "Parameter 'reportFile' of method 'LastBaselineReportProcessing' must not be null";
            assert (baselineSystem != null) : "Parameter 'baselineSystem' of method 'LastBaselineReportProcessing' must not be null";
            assert (systemInfoProcessor != null) : "Parameter 'systemInfoProcessor' of method 'LastBaselineReportProcessing' must not be null";
            assert (type != null) : "Parameter 'type' of method 'LastBaselineReportProcessing' must not be null";
            this.m_reportFile = reportFile;
            this.m_reportFileLastModified = reportFile.lastModified();
            this.m_baselineSystem = baselineSystem;
            this.m_systemInfoProcessor = systemInfoProcessor;
            this.m_baselineType = type;
        }

        TFile getReportFile() {
            return this.m_reportFile;
        }

        long getReportFileLastModified() {
            return this.m_reportFileLastModified;
        }

        ISoftwareSystem getSystem() {
            return this.m_baselineSystem;
        }

        ISystemInfoProcessor getSystemInfoProcessor() {
            return this.m_systemInfoProcessor;
        }

        BaselineType getBaselineType() {
            return this.m_baselineType;
        }
    }
}

