/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.NodeAndEdgeRepresentationExtension;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.representation.ExtendableEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.ExtendableEndpointCollectorFactory;
import com.hello2morrow.sonargraph.core.controller.system.representation.GraphAdditionalsCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.PotentialDependencyCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.RepresentationNavigationCollector;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGraphRepresentationExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.WorkspaceRootComponentContainer;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IElement;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.IncludeDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.representation.CreateRepresentationMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistry;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphRepresentationExtension
extends NodeAndEdgeRepresentationExtension<GraphRepresentation>
implements IGraphRepresentationExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphRepresentationExtension.class);

    GraphRepresentationExtension(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor, INamedElementResolver namedElementResolver, StructureItemRegistry structureItemRegistry) {
        super(languageProviderAccessor, softwareSystem, namedElementResolver, structureItemRegistry);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'GraphRepresentationExtension' must not be null";
        finishModelProcessor.addListener(this);
    }

    @Override
    protected Class<GraphRepresentation> getClassForExtension() {
        return GraphRepresentation.class;
    }

    @Override
    public GraphRepresentation createRepresentation(IWorkerContext workerContext, Collection<NamedElement> elements, Set<CoreParserDependencyType> parserDependencyTypesForEdges, Predicate<ParserDependency> dependencyFilter, FocusMode focusMode, PresentationMode presentationMode, EndpointType endpointType, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, boolean levelized, int nameSuffix) {
        boolean isParserDependencyBased;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createGraphRepresentation' must not be null";
        assert (elements != null) : "Parameter 'mainPathElementsForView' of method 'createGraphRepresentation' must not be null";
        assert (focusMode != null) : "Parameter 'mode' of method 'createGraphRepresentation' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createGraphRepresentation' must not be null";
        assert (endpointType != null) : "Parameter 'graphType' of method 'createGraphRepresentation' must not be null";
        workerContext.working("Processing", true);
        GraphRepresentation representationOfOrigin = null;
        String cycleForRepresentationFqName = null;
        LinkedHashSet<NamedElement> mainNodes = new LinkedHashSet<NamedElement>();
        if (elements.size() == 1 && elements.iterator().next() instanceof ArchitectureFile) {
            mainNodes.addAll(this.getRepresentationRelatedElements((ArchitectureFile)elements.iterator().next()));
            properties.add(NodeAndEdgeRepresentation.RepresentationProperty.ADD_MAIN_NODES_DYNAMICALLY);
        } else if (elements.size() == 1 && elements.iterator().next() instanceof CycleGroup) {
            mainNodes.addAll(elements);
            this.processCollectionWithOndemandCycles(mainNodes);
            CycleGroup cycleGroup = (CycleGroup)elements.iterator().next();
            cycleForRepresentationFqName = cycleGroup.getFullyQualifiedName();
            if (cycleGroup instanceof OnDemandCycleGroup) {
                OnDemandCycleGroup onDemandCycleGroup = (OnDemandCycleGroup)cycleGroup;
                assert (onDemandCycleGroup.isValid()) : "'onDemandCycleGroup' must be valid";
                representationOfOrigin = onDemandCycleGroup.getParent(GraphRepresentation.class, new Class[0]);
                assert (representationOfOrigin != null) : "'representaitonOfOrigin' of method 'createGraphRepresentation' must not be null";
            }
        } else {
            mainNodes.addAll(elements);
        }
        LinkedHashSet<NamedElement> additionalNodes = new LinkedHashSet<NamedElement>();
        IDomainRoot.Domain domain = RepresentationUtility.defineDomain(mainNodes);
        GraphRepresentation graphRepresentation = new GraphRepresentation(this.getSoftwareSystem(), this.getNamedElementResolver(), cycleForRepresentationFqName, mainNodes, parserDependencyTypesForEdges, dependencyFilter, domain, focusMode, presentationMode, properties, endpointType, levelized, nameSuffix);
        if (representationOfOrigin != null) {
            representationOfOrigin.addSlaveRepresentation(graphRepresentation);
        }
        if (mainNodes.isEmpty()) {
            assert (endpointType == EndpointType.WORKSPACE_DEPENDENCY) : "Empty main nodes collection is only supported for WorkspaceDependencies representation";
            graphRepresentation.setNodes(Collections.emptyMap(), Collections.emptyMap());
            this.getSoftwareSystem().getUniqueExistingChild(Representations.class).addChild(graphRepresentation);
            return graphRepresentation;
        }
        boolean bl = isParserDependencyBased = endpointType == EndpointType.PARSER_DEPENDENCY;
        if (isParserDependencyBased && focusMode != FocusMode.NO_ADDITIONAL) {
            additionalNodes.addAll(this.calculatePotentialAdditionals(graphRepresentation, mainNodes, domain, presentationMode, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ONLY_INTERNAL), properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH)));
        }
        additionalNodes.removeAll(mainNodes);
        ExtendableEndpointCollectorFactory collectorFactory = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ALLOWS_TRANSITIVE) ? new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, parserDependencyTypesForEdges, domain, presentationMode, isParserDependencyBased, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY)) : new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, null, parserDependencyTypesForEdges, domain, focusMode, presentationMode, isParserDependencyBased, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY));
        graphRepresentation.setDependencyFilter(dependencyFilter);
        this.createGraphRepresentationFromMainAndAdditionalElements((IWorkerContext)DefaultWorkerContext.INSTANCE, graphRepresentation, collectorFactory, focusMode, domain, endpointType, levelized);
        return graphRepresentation;
    }

    @Override
    public GraphRepresentation requestHome(IWorkerContext workerContext, GraphRepresentation currentRepresentation, Set<NamedElement> elements, Set<CoreParserDependencyType> parserDependencyTypesForEdges, FocusMode focusMode, PresentationMode presentationMode, EndpointType endpointType, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, boolean levelized) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'requestHome' must not be null";
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'requestHome' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'requestHome' must not be null";
        assert (parserDependencyTypesForEdges != null) : "Parameter 'parserDependencyTypesForEdges' of method 'requestHome' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'requestHome' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'requestHome' must not be null";
        assert (endpointType != null) : "Parameter 'endpointType' of method 'requestHome' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'requestHome' must not be null";
        this.removeRepresentation(currentRepresentation, false, false);
        GraphRepresentation representation = (GraphRepresentation)this.createRepresentation(workerContext, elements, parserDependencyTypesForEdges, focusMode, presentationMode, endpointType, properties, levelized, currentRepresentation.getId());
        this.updateSlaveRepresentations(currentRepresentation, representation);
        this.removeSlaveRepresentations(representation);
        return representation;
    }

    private Set<NamedElement> calculatePotentialAdditionals(GraphRepresentation representation, Collection<NamedElement> mainNodes, IDomainRoot.Domain domain, PresentationMode presentationMode, boolean onlyInternals, boolean isTypeBasedGraph) {
        assert (representation != null) : "Parameter 'representation' of method 'calculatePotentialAdditionals' must not be null";
        assert (mainNodes != null && !mainNodes.isEmpty()) : "Parameter 'mainNodes' of method 'calculatePotentialAdditionals' must not be empty";
        assert (domain != null) : "Parameter 'domain' of method 'calculatePotentialAdditionals' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'calculatePotentialAdditionals' must not be null";
        LinkedHashSet<NamedElement> additionalNodes = new LinkedHashSet<NamedElement>();
        NamedElement rootElement = RepresentationUtility.getRootElementForRepresentation(this.getSoftwareSystem(), mainNodes, domain);
        for (NamedElement namedElement : mainNodes) {
            StructureInfo structureInfo = this.getStructureItemRegistry().getStructureForElement(namedElement);
            GraphAdditionalsCollector collector = new GraphAdditionalsCollector(this, structureInfo, representation, mainNodes, namedElement, domain, presentationMode, isTypeBasedGraph);
            rootElement.accept(collector);
            Map<NamedElement, PotentialDependencyCollector.MatchingType> potentialAdditionals = collector.getCalculatedAdditionals();
            for (Map.Entry<NamedElement, PotentialDependencyCollector.MatchingType> entry : potentialAdditionals.entrySet()) {
                NamedElement additional = entry.getKey();
                if (mainNodes.contains(additional) || onlyInternals && additional.isExternal()) continue;
                additionalNodes.add(additional);
            }
        }
        return additionalNodes;
    }

    @Override
    public GraphRepresentation createRepresentation(IWorkerContext workerContext, GraphRepresentation currentRepresentation, Collection<NamedElement> originalInput, Collection<NamedElement> mainNodes, Collection<NamedElement> additionalNodes, Set<CoreParserDependencyType> dependencyTypes, Predicate<ParserDependency> dependencyFilter, FocusMode focusMode, PresentationMode presentationMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, CreateRepresentationMode createRepresentationMode, int stateIdToRestore) {
        Set<NamedElement> newAdditionalNodes;
        boolean addMainPathNodesDynamically;
        GraphRepresentation graphRepresentation;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (currentRepresentation != null) : "Parameter 'currentRepresentation' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (originalInput != null) : "Parameter 'originalInput' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (mainNodes != null) : "Parameter 'mainNodes' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (additionalNodes != null) : "Parameter 'additionalNodes' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (dependencyTypes != null) : "Parameter 'dependencyTypes' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        assert (createRepresentationMode != null) : "Parameter 'createRepresentationMode' of method 'createRepresentationForNavigationOrModelUpdate' must not be null";
        EndpointType endpointType = currentRepresentation.getEndpointType();
        if (endpointType == EndpointType.WORKSPACE_DEPENDENCY) {
            return this.createWorkspaceDependencyRepresentation(workerContext, currentRepresentation);
        }
        if (currentRepresentation.isValid()) {
            this.removeRepresentation(currentRepresentation, false, false);
        }
        workerContext.working("Processing", true);
        IDomainRoot.Domain domain = currentRepresentation.getDomain();
        boolean transitive = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ALLOWS_TRANSITIVE);
        boolean onlyVisible = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ONLY_VISIBLE);
        boolean onlyInternal = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ONLY_INTERNAL);
        boolean levelized = currentRepresentation.isLevelized();
        Predicate<NamedElement> validElementForRepresentationFilter = namedElement -> RepresentationUtility.isValidElementForRepresentation(namedElement, endpointType) || this.isSuitableForIncludeDependenciesView((NamedElement)namedElement) || this.isSuitableForWorkspaceDependenciesView((NamedElement)namedElement, endpointType);
        Set<NamedElement> currentAdditionalNodes = additionalNodes.stream().filter(validElementForRepresentationFilter).collect(Collectors.toSet());
        mainNodes = mainNodes.stream().filter(validElementForRepresentationFilter).collect(Collectors.toSet());
        LinkedHashSet<NamedElement> fullMainNodes = new LinkedHashSet<NamedElement>(mainNodes);
        if (fullMainNodes.isEmpty()) {
            return null;
        }
        switch (createRepresentationMode) {
            case UPDATE: {
                graphRepresentation = new GraphRepresentation(this.getSoftwareSystem(), this.getNamedElementResolver(), currentRepresentation.getCycleForRepresentationFqName(), originalInput, dependencyTypes, dependencyFilter, domain, focusMode, presentationMode, properties, endpointType, levelized, currentRepresentation.getId());
                break;
            }
            case NAVIGATION: {
                graphRepresentation = new GraphRepresentation(this.getSoftwareSystem(), this.getNamedElementResolver(), currentRepresentation.getCycleForRepresentationFqName(), originalInput, dependencyTypes, dependencyFilter, domain, currentRepresentation.getProgrammingElementDeltaManager(), focusMode, presentationMode, properties, endpointType, levelized, currentRepresentation.getId());
                graphRepresentation.applyProgrammingElementCollectionsState(stateIdToRestore);
                break;
            }
            default: {
                assert (false) : "Unexpected 'createRepresentationMode': " + String.valueOf((Object)createRepresentationMode);
                graphRepresentation = null;
            }
        }
        assert (graphRepresentation != null);
        this.updateSlaveRepresentations(currentRepresentation, graphRepresentation);
        LinkedHashSet mainNodesComplement = new LinkedHashSet();
        LinkedHashSet<NamedElement> newElementsForView = new LinkedHashSet();
        if (endpointType == EndpointType.PARSER_DEPENDENCY && focusMode != FocusMode.NO_ADDITIONAL && !onlyVisible && createRepresentationMode == CreateRepresentationMode.UPDATE) {
            newElementsForView = this.calculatePotentialAdditionals(graphRepresentation, mainNodes, domain, presentationMode, onlyInternal, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH)).stream().filter(validElementForRepresentationFilter).collect(Collectors.toSet());
        }
        if (addMainPathNodesDynamically = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ADD_MAIN_NODES_DYNAMICALLY)) {
            newAdditionalNodes = Collections.emptySet();
            fullMainNodes.addAll(newElementsForView);
            LinkedHashSet<NamedElement> updatedOriginalNodes = new LinkedHashSet<NamedElement>(graphRepresentation.getOriginalNodes());
            updatedOriginalNodes.addAll(newElementsForView);
            graphRepresentation.setOriginalNodes(this.updateElementsToOriginalElements(updatedOriginalNodes));
        } else {
            newAdditionalNodes = newElementsForView;
            newAdditionalNodes.removeAll(currentAdditionalNodes);
        }
        fullMainNodes.addAll(mainNodesComplement);
        Set<NamedElement> fullAdditionalNodes = RepresentationNavigationCollector.collectAllAdditionals(currentAdditionalNodes, newAdditionalNodes);
        fullAdditionalNodes.removeAll(fullMainNodes);
        this.createGraphRepresentationFromMainAndAdditionalElements(workerContext, graphRepresentation, switch (createRepresentationMode) {
            case CreateRepresentationMode.NAVIGATION -> new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), fullMainNodes, fullAdditionalNodes, newElementsForView, graphRepresentation.getProgrammingElementsForMainNodes(), graphRepresentation.getProgrammingElementsForAdditionalNodes(), dependencyTypes, focusMode, domain, presentationMode, properties, endpointType == EndpointType.PARSER_DEPENDENCY, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY));
            case CreateRepresentationMode.UPDATE -> {
                if (transitive) {
                    yield new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), fullMainNodes, fullAdditionalNodes, dependencyTypes, domain, presentationMode, endpointType == EndpointType.PARSER_DEPENDENCY, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY));
                }
                yield new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), fullMainNodes, fullAdditionalNodes, null, dependencyTypes, domain, focusMode, presentationMode, endpointType == EndpointType.PARSER_DEPENDENCY, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY));
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected 'createRepresentationMode': " + String.valueOf((Object)createRepresentationMode)));
                }
                yield null;
            }
        }, focusMode, domain, endpointType, levelized);
        this.removeSlaveRepresentations(graphRepresentation);
        return graphRepresentation;
    }

    private Set<NamedElement> collectElementsForWorkspaceDependenciesRepresentation() {
        LinkedHashSet<NamedElement> elements = new LinkedHashSet<NamedElement>();
        Set<IWorkspaceDependencyElement> workspaceDependencyElements = this.getSoftwareSystem().getExtension(IWorkspaceExtension.class).getRelevantWorkspaceDependencyElements();
        assert (workspaceDependencyElements != null) : "Parameter 'workspaceDependencyElements' of method 'internalRun' must not be null";
        for (IWorkspaceDependencyElement element : workspaceDependencyElements) {
            assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'internalRun': " + String.valueOf(element);
            elements.add((NamedElement)((Object)element));
        }
        return elements;
    }

    @Override
    public GraphRepresentation createWorkspaceDependencyRepresentation(IWorkerContext workerContext, GraphRepresentation previousRepresentation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'recreateWorkspaceDependencyRepresentation' must not be null";
        assert (previousRepresentation != null) : "Parameter 'previousRepresentation' of method 'recreateWorkspaceDependencyRepresentation' must not be null";
        assert (previousRepresentation.getEndpointType() == EndpointType.WORKSPACE_DEPENDENCY) : "Unexpected endpoint type for 'previousRepresentation': " + String.valueOf((Object)previousRepresentation.getEndpointType());
        if (previousRepresentation.isValid()) {
            this.removeRepresentation(previousRepresentation, false, false);
        }
        return (GraphRepresentation)this.createRepresentation(workerContext, this.collectElementsForWorkspaceDependenciesRepresentation(), Collections.emptySet(), FocusMode.NO_ADDITIONAL, PresentationMode.HIERARCHICAL, EndpointType.WORKSPACE_DEPENDENCY, EnumSet.noneOf(NodeAndEdgeRepresentation.RepresentationProperty.class), true, previousRepresentation.getId());
    }

    @Override
    public GraphRepresentation focus(IWorkerContext workerContext, GraphRepresentation representationToFocus, Collection<RepresentationNode> nodesToFocus, Set<CoreParserDependencyType> dependencyTypes, FocusMode mode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties) {
        Set<Object> additionalNodes;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'focus' must not be null";
        assert (representationToFocus != null) : "Parameter 'representationToFocus' of method 'focus' must not be null";
        assert (nodesToFocus != null) : "Parameter 'nodesToFocus' of method 'focus' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'focus' must not be null";
        this.removeRepresentation(representationToFocus, false, false);
        boolean levelized = representationToFocus.isLevelized();
        if (nodesToFocus.isEmpty()) {
            GraphRepresentation graphRepresentation = this.createGraphForSpecifiedDependencyTypes(workerContext, representationToFocus, dependencyTypes, levelized);
            return graphRepresentation;
        }
        workerContext.working("Processing", true);
        boolean includeTransitive = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ALLOWS_TRANSITIVE);
        boolean useOnlyVisible = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ONLY_VISIBLE);
        boolean onlyInternal = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ONLY_INTERNAL);
        PresentationMode presentationMode = representationToFocus.getPresentationMode();
        EndpointType endpointType = representationToFocus.getEndpointType();
        Set<RepresentationNode> adjustedNodesToFocus = this.collectNodesForFocus(nodesToFocus);
        Set elementsToFocus = adjustedNodesToFocus.stream().map(RepresentationNode::getUnderlyingObject).collect(Collectors.toSet());
        LinkedHashSet<OnDemandCycleGroup> cycleNodes = new LinkedHashSet<OnDemandCycleGroup>();
        for (NamedElement namedElement : elementsToFocus) {
            if (!(namedElement instanceof OnDemandCycleGroup)) continue;
            cycleNodes.add((OnDemandCycleGroup)namedElement);
        }
        IDomainRoot.Domain domain = representationToFocus.getDomain();
        LinkedHashSet<NamedElement> mainNodes = new LinkedHashSet<NamedElement>(elementsToFocus);
        this.processCollectionWithOndemandCycles(mainNodes);
        GraphRepresentation graphRepresentation = new GraphRepresentation(this.getSoftwareSystem(), this.getNamedElementResolver(), representationToFocus.getCycleForRepresentationFqName(), mainNodes, dependencyTypes, representationToFocus.getDependencyFilter(), domain, representationToFocus.getProgrammingElementDeltaManager(), mode, presentationMode, properties, endpointType, levelized, representationToFocus.getId());
        this.updateSlaveRepresentations(representationToFocus, graphRepresentation);
        if (useOnlyVisible) {
            additionalNodes = new LinkedHashSet();
            if (includeTransitive) {
                for (RepresentationNode node : representationToFocus.getNodes()) {
                    if (!node.hasEdges()) continue;
                    NamedElement underlyingObject = node.getUnderlyingObject();
                    if (!onlyInternal || !underlyingObject.isExternal()) {
                        additionalNodes.add(underlyingObject);
                    }
                    this.getConnectedNodes(additionalNodes, node, mode, onlyInternal);
                }
            } else {
                for (NamedElement namedElement : elementsToFocus) {
                    RepresentationNode node = representationToFocus.getNode(namedElement);
                    assert (node != null) : "'node' of method 'focus' must not be null";
                    if (!node.hasEdges()) continue;
                    this.getConnectedNodes(additionalNodes, node, mode, onlyInternal);
                }
            }
            this.processCollectionWithOndemandCycles(additionalNodes);
        } else if (endpointType == EndpointType.PARSER_DEPENDENCY) {
            additionalNodes = mode != FocusMode.NO_ADDITIONAL ? this.calculatePotentialAdditionals(graphRepresentation, mainNodes, domain, presentationMode, onlyInternal, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH)) : Collections.emptySet();
        } else if (endpointType == EndpointType.WORKSPACE_DEPENDENCY) {
            additionalNodes = new LinkedHashSet();
            for (IWorkspaceDependencyElement element : this.getSoftwareSystem().getExtension(IWorkspaceExtension.class).getRelevantWorkspaceDependencyElements()) {
                assert (element instanceof NamedElement) : "Unexpected class in method 'focus': " + String.valueOf(element);
                NamedElement namedElement = (NamedElement)((Object)element);
                if (mainNodes.contains(namedElement) || onlyInternal && namedElement.isExternal()) continue;
                additionalNodes.add(namedElement);
            }
        } else {
            assert (false) : "Unexpected value for endpointType" + String.valueOf((Object)endpointType);
            return null;
        }
        additionalNodes.removeAll(mainNodes);
        additionalNodes.removeAll(elementsToFocus);
        ExtendableEndpointCollectorFactory collectorFactory = includeTransitive ? (useOnlyVisible ? new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, cycleNodes, representationToFocus.getProgrammingElementsForMainNodes(), representationToFocus.getProgrammingElementsForAdditionalNodes(), representationToFocus.getProgrammingElementToProxy(), dependencyTypes, domain, mode, presentationMode, true, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY)) : new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, dependencyTypes, domain, presentationMode, endpointType == EndpointType.PARSER_DEPENDENCY, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY))) : (useOnlyVisible ? new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, cycleNodes, representationToFocus.getProgrammingElementsForMainNodes(), representationToFocus.getProgrammingElementsForAdditionalNodes(), dependencyTypes, domain, mode, presentationMode, true, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY)) : new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, cycleNodes, dependencyTypes, domain, mode, presentationMode, endpointType == EndpointType.PARSER_DEPENDENCY, properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY)));
        this.createGraphRepresentationFromMainAndAdditionalElements((IWorkerContext)DefaultWorkerContext.INSTANCE, graphRepresentation, collectorFactory, mode, domain, endpointType, levelized);
        this.removeSlaveRepresentations(graphRepresentation);
        return graphRepresentation;
    }

    @Override
    public GraphRepresentation createRepresentationForPresentationModeChange(IWorkerContext workerContext, GraphRepresentation previousRepresentation, PresentationMode presentationMode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createGraphForFlatHierarchicalModeChange' must not be null";
        assert (previousRepresentation != null) : "Parameter 'previousRepresentation' of method 'createGraphForFlatHierarchicalModeChange' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createGraphForFlatHierarchicalModeChange' must not be null";
        assert (presentationMode == PresentationMode.FLAT) : "Only flat mode supported";
        this.removeRepresentation(previousRepresentation, false, false);
        boolean transitive = previousRepresentation.allowsTransitiveDependencies();
        workerContext.setNumberOfSteps(transitive ? 3 : 2);
        workerContext.working("Processing", true);
        LinkedHashSet<NamedElement> mainNodes = new LinkedHashSet<NamedElement>(previousRepresentation.getMainNodes());
        LinkedHashSet<NamedElement> additionalNodes = new LinkedHashSet<NamedElement>(previousRepresentation.getAdditionalNodes());
        IDomainRoot.Domain domain = previousRepresentation.getDomain();
        FocusMode mode = previousRepresentation.getFocusMode();
        EndpointType endpointType = previousRepresentation.getEndpointType();
        boolean levelized = previousRepresentation.isLevelized();
        GraphRepresentation graph = new GraphRepresentation(this.getSoftwareSystem(), this.getNamedElementResolver(), previousRepresentation.getCycleForRepresentationFqName(), previousRepresentation.getOriginalNodes(), previousRepresentation.getParserDependencyTypesForEdges(), previousRepresentation.getDependencyFilter(), domain, previousRepresentation.getProgrammingElementDeltaManager(), mode, previousRepresentation.getPresentationMode(), previousRepresentation.getRepresentationProperties(), endpointType, levelized, previousRepresentation.getId());
        this.updateSlaveRepresentations(previousRepresentation, graph);
        this.adjustNodesForPresentationMode(mainNodes, Collections.emptySet(), domain, presentationMode, false, true);
        this.adjustNodesForPresentationMode(additionalNodes, mainNodes, domain, presentationMode, false, true);
        LinkedHashSet<NamedElement> originalInput = new LinkedHashSet<NamedElement>(graph.getOriginalNodes());
        this.adjustNodesForPresentationMode(originalInput, Collections.emptySet(), domain, presentationMode, false, true);
        graph.setOriginalNodes(originalInput);
        additionalNodes.removeAll(mainNodes);
        ExtendableEndpointCollectorFactory collectorFactory = new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, previousRepresentation.getProgrammingElementsForMainNodes(), previousRepresentation.getProgrammingElementsForAdditionalNodes(), previousRepresentation.getParserDependencyTypesForEdges(), domain, previousRepresentation.allowsTransitiveDependencies(), presentationMode, true, previousRepresentation.getRepresentationProperties().contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY));
        workerContext.endStep();
        workerContext.beginSubTask("Creating tree...");
        this.createGraphRepresentationFromMainAndAdditionalElements(workerContext, graph, collectorFactory, mode, domain, endpointType, levelized);
        this.removeSlaveRepresentations(graph);
        workerContext.endSubTask();
        return graph;
    }

    private void processCollectionWithOndemandCycles(Collection<NamedElement> namedElements) {
        assert (namedElements != null) : "Parameter 'namedElements' of method 'processCollectionWithOndemandCycles' must not be null";
        Iterator<NamedElement> it = namedElements.iterator();
        LinkedHashSet<NamedElement> elementsToAdd = new LinkedHashSet<NamedElement>();
        while (it.hasNext()) {
            NamedElement next = it.next();
            if (!(next instanceof CycleGroup)) continue;
            elementsToAdd.addAll(((CycleGroup)next).getCyclicNamedElements());
            it.remove();
        }
        namedElements.addAll(elementsToAdd);
    }

    private <T extends NodeAdapter> void createGraphRepresentationFromMainAndAdditionalElements(IWorkerContext workerContext, GraphRepresentation graphRepresentation, ExtendableEndpointCollectorFactory collectorFactory, FocusMode mode, IDomainRoot.Domain domain, EndpointType endpointType, boolean levelized) {
        assert (graphRepresentation != null) : "Parameter 'graphRepresentation' of method 'createGraphRepresentationFromMainAndAdditionalElements' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createGraphRepresentationFromMainAndAdditionalElements' must not be null";
        assert (collectorFactory != null) : "Parameter 'collectorFactory' of method 'createGraphRepresentationFromMainAndAdditionalElements' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'createGraphRepresentationFromMainAndAdditionalElements' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'createGraphRepresentationFromMainAndAdditionalElements' must not be null";
        workerContext.setNumberOfSteps(3, new int[]{10, 10, 80});
        workerContext.beginSubTask("Creating nodes");
        Set<NamedElement> mainNodes = collectorFactory.getMainNodes();
        Set<NamedElement> additionalNodes = collectorFactory.getAdditionalNodes();
        boolean includeTransitive = graphRepresentation.allowsTransitiveDependencies();
        if (LOGGER.isDebugEnabled()) {
            for (NamedElement namedElement : mainNodes) {
                LOGGER.debug("Main element: " + namedElement.getPresentationName(false));
            }
            for (NamedElement namedElement : additionalNodes) {
                LOGGER.debug("Additional element: " + namedElement.getPresentationName(false));
            }
            LOGGER.debug("Main elements: " + mainNodes.size());
            LOGGER.debug("Additional elements: " + additionalNodes.size());
        }
        for (NamedElement namedElement : mainNodes) {
            RepresentationNode mainNode = graphRepresentation.createNode(namedElement, NodeType.MAIN);
            mainNode.setIsOriginalInputRelated(true);
        }
        for (NamedElement namedElement : additionalNodes) {
            graphRepresentation.createNode(namedElement, NodeType.ADDITIONAL);
        }
        collectorFactory.setNamedElementToProxy(graphRepresentation.getProgrammingElementToProxy());
        LinkedHashSet<NamedElement> mainPathAndAdditionalElements = new LinkedHashSet<NamedElement>(mainNodes);
        mainPathAndAdditionalElements.addAll(additionalNodes);
        Object collector = collectorFactory.createExtendableEndpointCollector(endpointType);
        NodeAdapterSet nodeAdapterSet = switch (endpointType) {
            case EndpointType.INCLUDE_DEPENDENCY -> new IncludeDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, (Collection<? extends NamedElement>)mainPathAndAdditionalElements, (DependencyEndpointCollector)collector);
            case EndpointType.PARSER_DEPENDENCY -> {
                Predicate<ParserDependency> dependencyFilter = graphRepresentation.getDependencyFilter();
                yield new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, (Collection<? extends NamedElement>)mainPathAndAdditionalElements, (DependencyEndpointCollector)collector, RepresentationUtility.PE, dependencyFilter == null ? RepresentationUtility.PD : dependencyFilter);
            }
            case EndpointType.WORKSPACE_DEPENDENCY -> new WorkspaceDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, (Collection<? extends NamedElement>)mainPathAndAdditionalElements, (DependencyEndpointCollector)collector);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled: " + String.valueOf((Object)endpointType)));
                }
                yield null;
            }
        };
        graphRepresentation.setNodeAdapterSet(nodeAdapterSet);
        graphRepresentation.setNodes(this.updateKeysToOriginalElements(((ExtendableEndpointCollector)collector).getProgrammingElementsOfMainNodes()), this.updateKeysToOriginalElements(((ExtendableEndpointCollector)collector).getProgrammingElementsOfAdditionalNodes()));
        GraphRepresentation currentGraphRepresentation = this.getSoftwareSystem().getUniqueExistingChild(Representations.class).getUniqueChild(new NameFilter(graphRepresentation.getName()), GraphRepresentation.class);
        if (currentGraphRepresentation != null) {
            this.removeRepresentation(currentGraphRepresentation, false, false);
        }
        this.getSoftwareSystem().getUniqueExistingChild(Representations.class).addChild(graphRepresentation);
        if (includeTransitive) {
            this.removeTransitivelyUnconnected((IWorkerContext)DefaultWorkerContext.INSTANCE, (DependencyEndpointCollector)collector, nodeAdapterSet, graphRepresentation, (Collection<NamedElement>)mainPathAndAdditionalElements, (Collection<NamedElement>)additionalNodes, mode, ((ExtendableEndpointCollector)collector).getAllowedDependencyTypes(), graphRepresentation.getRepresentationProperties());
        }
        workerContext.endSubTask();
        workerContext.beginSubTask("Analyzing cycles");
        if (levelized) {
            if (endpointType == EndpointType.PARSER_DEPENDENCY) {
                this.analyzeCycleGroupsInRepresentation(workerContext, (NodeAdapterSet<? extends NodeAdapter>)nodeAdapterSet, graphRepresentation, (Collection<NamedElement>)mainPathAndAdditionalElements);
            } else if (endpointType == EndpointType.WORKSPACE_DEPENDENCY) {
                CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
                CycleAnalyzer.compute(cycleAnalyzerAdapter, workerContext);
            }
        }
        workerContext.endSubTask();
        workerContext.beginSubTask("Calculating edges");
        this.addEgdes(nodeAdapterSet, graphRepresentation);
        if (graphRepresentation.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            this.updateUnderlyingDependencies(graphRepresentation);
        }
        graphRepresentation.finishModification();
        if (LOGGER.isDebugEnabled()) {
            OperationResult checkTreeConsistencyResult = NodeAndEdgeRepresentationExtension.checkRepresentationConsistency(graphRepresentation);
            assert (checkTreeConsistencyResult.isSuccess()) : checkTreeConsistencyResult.getErrorMessages();
        }
        workerContext.endSubTask();
    }

    @Override
    protected void analyzeCycleGroupsInRepresentation(IWorkerContext workerContext, NodeAdapterSet<? extends NodeAdapter> nodeAdapterSet, GraphRepresentation graphRepresentation, Collection<NamedElement> mainPathAndAdditionalElements) {
        Integer nextCycleGroupIndex;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'analyzeCycleGroupsInRepresentation' must not be null";
        assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'analyzeCycleGroupsInRepresentation' must not be null";
        assert (graphRepresentation != null) : "Parameter 'graphRepresentation' of method 'analyzeCycleGroupsInRepresentation' must not be null";
        assert (mainPathAndAdditionalElements != null) : "Parameter 'mainPathAndAdditionalElements' of method 'analyzeCycleGroupsInRepresentation' must not be null";
        CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
        CycleAnalyzer.compute(cycleAnalyzerAdapter, workerContext);
        THashMap mainNodeToProgrammingElement = new THashMap();
        THashMap additionalNodeToProgrammingElement = new THashMap();
        THashMap cycleGroupIndexToCycleGroup = new THashMap();
        THashMap cycleGroupIndexToNodeAdaptersToBeCombined = new THashMap();
        for (NodeAdapter nodeAdapter : cycleAnalyzerAdapter.getCyclicNodes()) {
            nextCycleGroupIndex = cycleAnalyzerAdapter.getGroup(nodeAdapter);
            LinkedHashSet<NodeAdapter> nodeAdaptersToBeCombined = (LinkedHashSet<NodeAdapter>)cycleGroupIndexToNodeAdaptersToBeCombined.get(nextCycleGroupIndex);
            OnDemandCycleGroup nextCycleGroup = (OnDemandCycleGroup)cycleGroupIndexToCycleGroup.get(nextCycleGroupIndex);
            if (nextCycleGroup == null) {
                nextCycleGroup = new OnDemandCycleGroup((NamedElement)graphRepresentation, graphRepresentation.getDomain());
                graphRepresentation.addChild(nextCycleGroup);
                cycleGroupIndexToCycleGroup.put(nextCycleGroupIndex, nextCycleGroup);
                assert (nodeAdaptersToBeCombined == null) : "'nodeAdaptersToBeCombined' of method 'createGraphRepresentation' must  be null";
                nodeAdaptersToBeCombined = new LinkedHashSet<NodeAdapter>();
                cycleGroupIndexToNodeAdaptersToBeCombined.put(nextCycleGroupIndex, nodeAdaptersToBeCombined);
            } else assert (nodeAdaptersToBeCombined != null) : "'nodeAdaptersToBeCombined' of method 'createGraphRepresentation' must not be null";
            NamedElement underlyingObject = nodeAdapter.getUnderlyingObject();
            RepresentationNode cyclicNode = graphRepresentation.getNode(underlyingObject.getOriginal());
            assert (cyclicNode != null) : "'cyclycNode' of method 'analyzeCycleGroupsInRepresentation' must not be null";
            boolean cyclicIsMainNode = cyclicNode.isMainNode();
            nextCycleGroup.addCyclicElement(underlyingObject);
            nodeAdaptersToBeCombined.add(nodeAdapter);
            for (EdgeAdapter edgeAdapter : nodeAdapter.getOutgoingEdges()) {
                RepresentationNode nextToNode = graphRepresentation.getNode(((NodeAdapter)edgeAdapter.getTo()).getUnderlyingObject());
                assert (nextToNode != null) : "'nextToNode' of method 'analyzeCycleGroupsInRepresentation' must not be null";
                for (Dependency dependency : edgeAdapter.getDependencies()) {
                    assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'addEdges': " + String.valueOf(dependency);
                    ParserDependency parserDependency = (ParserDependency)dependency;
                    ProgrammingElement fromProgrammingElement = parserDependency.getFrom();
                    ProgrammingElement toProgrammingElement = parserDependency.getTo();
                    this.addProgrammingElementForNode(underlyingObject, fromProgrammingElement, (Map<NamedElement, Set<ProgrammingElement>>)(cyclicIsMainNode ? mainNodeToProgrammingElement : additionalNodeToProgrammingElement));
                    boolean toIsMainNode = nextToNode.isMainNode();
                    this.addProgrammingElementForNode(nextToNode.getUnderlyingObject(), toProgrammingElement, (Map<NamedElement, Set<ProgrammingElement>>)(toIsMainNode ? mainNodeToProgrammingElement : additionalNodeToProgrammingElement));
                }
            }
        }
        for (Map.Entry entry : cycleGroupIndexToCycleGroup.entrySet()) {
            nextCycleGroupIndex = (Integer)entry.getKey();
            OnDemandCycleGroup nextCycleGroup = (OnDemandCycleGroup)entry.getValue();
            Set nextNodeAdaptersToBeCombined = (Set)cycleGroupIndexToNodeAdaptersToBeCombined.get(nextCycleGroupIndex);
            assert (nextNodeAdaptersToBeCombined != null && !nextNodeAdaptersToBeCombined.isEmpty()) : "'nextNodeAdaptersToBeCombined' of method 'createGraphRepresentation' must not be empty";
            for (NodeAdapter nodeAdapter : nextNodeAdaptersToBeCombined) {
                nextCycleGroup.addIncomingRealEdges(nodeAdapter.getIncomingEdges());
                nextCycleGroup.addOutgoingRealEdges(nodeAdapter.getOutgoingEdges());
            }
            NodeAdapter combinedNodeAdapter = nodeAdapterSet.combine(nextCycleGroup, nextNodeAdaptersToBeCombined);
            int level = -1;
            boolean containsMainNode = false;
            for (NodeAdapter nodeAdapter : nextNodeAdaptersToBeCombined) {
                NamedElement underlyingObject = nodeAdapter.getUnderlyingObject();
                RepresentationNode node = graphRepresentation.getNode(underlyingObject);
                assert (node != null) : "'node' of method 'analyzeCycleGroupsInRepresentation' must not be null";
                boolean fromIsMainNode = node.isMainNode();
                mainPathAndAdditionalElements.remove(underlyingObject);
                if (fromIsMainNode) {
                    containsMainNode = true;
                    graphRepresentation.updateMainPathNode(underlyingObject, nextCycleGroup);
                } else {
                    graphRepresentation.updateAdditionalNode(underlyingObject, nextCycleGroup);
                }
                if (level == -1) {
                    level = nodeAdapter.getLevel();
                    continue;
                }
                assert (level == nodeAdapter.getLevel()) : "Level does not match";
            }
            mainPathAndAdditionalElements.add(nextCycleGroup);
            graphRepresentation.createNode(nextCycleGroup, containsMainNode ? NodeType.MAIN : NodeType.ADDITIONAL);
            combinedNodeAdapter.setLevel(level);
        }
        graphRepresentation.updateNodes((Map<NamedElement, Set<ProgrammingElement>>)mainNodeToProgrammingElement, (Map<NamedElement, Set<ProgrammingElement>>)additionalNodeToProgrammingElement, true);
    }

    private void addProgrammingElementForNode(NamedElement elementForNode, ProgrammingElement programmingElement, Map<NamedElement, Set<ProgrammingElement>> collector) {
        assert (elementForNode != null) : "Parameter 'elementForNode' of method 'addProgrammingElemnetForNode' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'addProgrammingElemnetForNode' must not be null";
        NamedElement original = elementForNode.getOriginal();
        Set<ProgrammingElement> programmingElemnts = collector.get(original);
        if (programmingElemnts == null) {
            programmingElemnts = new LinkedHashSet<ProgrammingElement>();
            collector.put(original, programmingElemnts);
        }
        if (programmingElement != null) {
            programmingElemnts.add(programmingElement);
        }
    }

    private void addEgdes(NodeAdapterSet<? extends NodeAdapter> nodeAdapterSet, GraphRepresentation graph) {
        assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'addEgdes' must not be null";
        assert (graph != null) : "Parameter 'graph' of method 'addEgdes' must not be null";
        this.removeUnusedNodes(graph, nodeAdapterSet);
        THashMap mainNodeToProgrammingElement = new THashMap();
        THashMap additionalNodeToProgrammingElement = new THashMap();
        this.createEdges(graph, nodeAdapterSet, (Map<NamedElement, Set<ProgrammingElement>>)mainNodeToProgrammingElement, (Map<NamedElement, Set<ProgrammingElement>>)additionalNodeToProgrammingElement);
        if (graph.getEndpointType() == EndpointType.PARSER_DEPENDENCY) {
            for (Map.Entry entry : mainNodeToProgrammingElement.entrySet()) {
                graph.addProgrammingElementsForNamedElement(((NamedElement)entry.getKey()).getOriginal(), (Set)entry.getValue(), true);
            }
            for (Map.Entry entry : additionalNodeToProgrammingElement.entrySet()) {
                graph.addProgrammingElementsForNamedElement(((NamedElement)entry.getKey()).getOriginal(), (Set)entry.getValue(), false);
            }
        }
    }

    @Override
    protected <U extends NodeAdapter> void createEdges(GraphRepresentation graph, NodeAdapterSet<U> nodeAdapterSet, Map<NamedElement, Set<ProgrammingElement>> mainNodeToProgrammingElement, Map<NamedElement, Set<ProgrammingElement>> additionalNodeToProgrammingElement) {
        assert (graph != null) : "Parameter 'graph' of method 'createEdges' must not be null";
        assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'createEdges' must not be null";
        assert (mainNodeToProgrammingElement != null) : "Parameter 'mainNodeToProgrammingElement' of method 'createEdges' must not be null";
        assert (additionalNodeToProgrammingElement != null) : "Parameter 'additionalNodeToProgrammingElement' of method 'createEdges' must not be null";
        for (NodeAdapter nodeAdapter : nodeAdapterSet.getNodes()) {
            boolean isParserDependencyBased;
            NamedElement originalUnderlyingObject = nodeAdapter.getUnderlyingObject().getOriginal();
            RepresentationNode nextFromNode = graph.getNode(originalUnderlyingObject);
            assert (nextFromNode != null) : "'node' of method 'addEgdes' must not be null";
            boolean fromIsMainNode = nextFromNode.isMainNode();
            boolean bl = isParserDependencyBased = graph.getEndpointType() == EndpointType.PARSER_DEPENDENCY;
            if (isParserDependencyBased && !(originalUnderlyingObject instanceof CycleGroup)) {
                this.addProgrammingElementForNode(originalUnderlyingObject, null, fromIsMainNode ? mainNodeToProgrammingElement : additionalNodeToProgrammingElement);
            }
            for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : nodeAdapter.getOutgoingEdges()) {
                RepresentationNode nextToNode = graph.getNode(edgeAdapter.getTo().getUnderlyingObject().getOriginal());
                assert (nextToNode != null) : "Parameter 'nextToNode' of method 'addEgdes' must not be null";
                nextFromNode.addEdge(new RepresentationEdge<RepresentationNode>(nextFromNode, nextToNode, edgeAdapter.getDependencies(), edgeAdapter.getEndpointType()));
                if (!isParserDependencyBased || originalUnderlyingObject instanceof CycleGroup) continue;
                for (Dependency dependency : edgeAdapter.getDependencies()) {
                    assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'addEdges': " + String.valueOf(dependency);
                    ParserDependency parserDependency = (ParserDependency)dependency;
                    ProgrammingElement fromProgrammingElement = parserDependency.getFrom();
                    ProgrammingElement toProgrammingElement = parserDependency.getTo();
                    this.addProgrammingElementForNode(originalUnderlyingObject, fromProgrammingElement, fromIsMainNode ? mainNodeToProgrammingElement : additionalNodeToProgrammingElement);
                    if (nextToNode.getUnderlyingObject() instanceof CycleGroup) continue;
                    boolean toIsMainNode = nextToNode.isMainNode();
                    this.addProgrammingElementForNode(nextToNode.getUnderlyingObject(), toProgrammingElement, toIsMainNode ? mainNodeToProgrammingElement : additionalNodeToProgrammingElement);
                }
            }
        }
    }

    private void removeUnusedNodes(GraphRepresentation graph, NodeAdapterSet<? extends NodeAdapter> nodeAdapterSet) {
        assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'removeUnusedNodes' must not be null";
        assert (graph != null) : "Parameter 'graph' of method 'removeUnusedNodes' must not be null";
        boolean isParserDependencyBased = graph.getEndpointType() == EndpointType.PARSER_DEPENDENCY;
        Iterator<? extends NodeAdapter> it = nodeAdapterSet.iterator();
        while (it.hasNext()) {
            NodeAdapter nextNodeAdapter = it.next();
            NamedElement underlyingObject = nextNodeAdapter.getUnderlyingObject().getOriginal();
            RepresentationNode node = graph.getNode(underlyingObject);
            assert (node != null) : "'node' of method 'addEgdes' must not be null";
            if ((nextNodeAdapter.hasDependencies() || node.isMainNode()) && (graph.getEndpointType() != EndpointType.PARSER_DEPENDENCY || RepresentationUtility.isValidElementForRepresentation(underlyingObject))) continue;
            it.remove();
            graph.removeNode(underlyingObject, NodeType.ADDITIONAL, true);
            if (!(underlyingObject instanceof OnDemandCycleGroup)) continue;
            graph.removeChild(nextNodeAdapter.getUnderlyingObject());
        }
        if (isParserDependencyBased) assert (!graph.getMainNodes().isEmpty()) : " 'graph.getMainNodes()' of method 'addEgdes' must not be empty";
    }

    private GraphRepresentation createGraphForSpecifiedDependencyTypes(IWorkerContext workerContext, GraphRepresentation previousRepresentation, Set<CoreParserDependencyType> dependencyTypes, boolean levelized) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createTreeForSpecifiedDependenyTyes' must not be null";
        assert (previousRepresentation != null) : "Parameter 'previousRepresentation' of method 'createTreeForSpecifiedDependenyTyes' must not be null";
        assert (dependencyTypes != null) : "Parameter 'dependencyTypes' of method 'createTreeForSpecifiedDependenyTyes' must not be null";
        LinkedHashSet<NamedElement> mainNodes = new LinkedHashSet<NamedElement>(previousRepresentation.getMainNodes());
        LinkedHashSet<NamedElement> additionalNodes = new LinkedHashSet<NamedElement>(previousRepresentation.getAdditionalNodes());
        EndpointType endpointType = previousRepresentation.getEndpointType();
        FocusMode mode = previousRepresentation.getFocusMode();
        IDomainRoot.Domain domain = previousRepresentation.getDomain();
        ExtendableEndpointCollectorFactory collectorFactory = new ExtendableEndpointCollectorFactory(this.getSoftwareSystem(), mainNodes, additionalNodes, null, previousRepresentation.getProgrammingElementsForMainNodes(), previousRepresentation.getProgrammingElementsForAdditionalNodes(), dependencyTypes, domain, mode, previousRepresentation.getPresentationMode(), true, previousRepresentation.getRepresentationProperties().contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY));
        GraphRepresentation representation = new GraphRepresentation(this.getSoftwareSystem(), this.getNamedElementResolver(), previousRepresentation.getCycleForRepresentationFqName(), mainNodes, dependencyTypes, previousRepresentation.getDependencyFilter(), domain, previousRepresentation.getProgrammingElementDeltaManager(), mode, previousRepresentation.getPresentationMode(), previousRepresentation.getRepresentationProperties(), endpointType, previousRepresentation.isLevelized(), previousRepresentation.getId());
        this.updateSlaveRepresentations(previousRepresentation, representation);
        this.createGraphRepresentationFromMainAndAdditionalElements(workerContext, representation, collectorFactory, mode, domain, endpointType, levelized);
        this.removeSlaveRepresentations(representation);
        return representation;
    }

    @Override
    public boolean isSuitableForIncludeDependenciesView(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'isSuitableForIncludeDependenciesView' must not be null";
        Language language = namedElement.getLanguage();
        if (language != null) {
            LanguageProvider languageProvider = this.getLanguageProviderAccessor().getLanguageProvider(language);
            return languageProvider.isSuitableForIncludeDependenciesGraph(namedElement);
        }
        return false;
    }

    @Override
    public boolean isSuitableForWorkspaceDependenciesView(NamedElement namedElement, EndpointType endpointType) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'isSuitableForWorkspaceDependenciesView' must not be null";
        assert (endpointType != null) : "Parameter 'endpointType' of method 'isSuitableForWorkspaceDependenciesView' must not be null";
        return endpointType == EndpointType.WORKSPACE_DEPENDENCY && namedElement instanceof IWorkspaceDependencyElement;
    }

    @Override
    public List<Element> getElementsForWorkspaceDependenciesViewShowInView(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getElementsForShowInView' must not be null";
        ArrayList<Element> relevantElements = new ArrayList<Element>();
        if (!elements.isEmpty()) {
            for (Element nextElement : elements) {
                Element nextElementToConsider = nextElement;
                if (nextElementToConsider instanceof IDiffElement && (nextElementToConsider = ((IDiffElement)((Object)nextElementToConsider)).getCurrentElement()) == null) {
                    return Collections.emptyList();
                }
                if (nextElementToConsider instanceof Issue) {
                    nextElementToConsider = ((Issue)nextElementToConsider).getAffectedElement();
                }
                if (nextElementToConsider instanceof RepresentationNode) {
                    nextElementToConsider = ((RepresentationNode)nextElementToConsider).getUnderlyingObject();
                }
                if (nextElementToConsider instanceof WorkspaceRootComponentContainer) {
                    nextElementToConsider = ((WorkspaceRootComponentContainer)nextElementToConsider).getElement();
                }
                if (!(nextElementToConsider instanceof IWorkspaceDependencyElement) || ((IWorkspaceDependencyElement)((Object)nextElementToConsider)).isExternal()) {
                    return Collections.emptyList();
                }
                relevantElements.add(nextElementToConsider);
            }
        }
        return relevantElements;
    }

    @Override
    public List<Element> getElementsForTypeBasedGraphShowInView(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'isSuitableForTypeBasedGraph' must not be null";
        ArrayList<Element> suitableElements = new ArrayList<Element>();
        for (Element nextElement : elements) {
            Element element = nextElement;
            if (element instanceof IDiffElement && (element = ((IDiffElement)((Object)element)).getCurrentElement()) == null) continue;
            if (element instanceof RepresentationNode) {
                element = ((RepresentationNode)element).getUnderlyingObject();
            }
            if (element instanceof LogicalProgrammingElement) {
                element = ((LogicalProgrammingElement)element).getPrimaryProgrammingElement();
            }
            if (!(element instanceof IType) || !(element instanceof NamedElement) || !RepresentationUtility.isValidElementForRepresentation((NamedElement)element)) continue;
            suitableElements.add(element);
        }
        return suitableElements;
    }

    @Override
    public <T extends IElement> Pair<Set<T>, Set<Dependency>> aggregateEndpointsFromRepresentation(NodeAndEdgeRepresentation representation, Class<T> aggregationClass) {
        assert (representation != null) : "Parameter 'representation' of method 'aggregateEndpointsFromRepresentation' must not be null";
        assert (aggregationClass != null) : "Parameter 'aggregationClass' of method 'aggregateEndpointsFromRepresentation' must not be null";
        THashSet endpoints = new THashSet();
        THashSet dependencies = new THashSet();
        for (RepresentationNode representationNode : representation.getNodes()) {
            for (RepresentationEdge nextEdge : representationNode.getOutgoingEdges()) {
                if (nextEdge.getTo() == nextEdge.getFrom()) continue;
                for (Dependency nextDependency : nextEdge.getDependencies()) {
                    dependencies.add(nextDependency);
                    endpoints.add(this.getParentOfEndpoint(nextDependency.getFrom(), aggregationClass));
                    endpoints.add(this.getParentOfEndpoint(nextDependency.getTo(), aggregationClass));
                }
            }
        }
        return new Pair((Object)endpoints, (Object)dependencies);
    }

    private <T extends IElement> T getParentOfEndpoint(ISnapshotDependency.IDependencyEndpoint endpoint, Class<T> aggregationClass) {
        assert (endpoint != null) : "Parameter 'endpoint' of method 'getParentOfEndpoint' must not be null";
        assert (aggregationClass != null) : "Parameter 'aggregationClass' of method 'getParentOfEndpoint' must not be null";
        if (endpoint instanceof ProgrammingElement) {
            ProgrammingElement element = (ProgrammingElement)endpoint;
            IElement parent = (IElement)element.getParent(aggregationClass, ParentMode.TOPMOST_PARENT_OR_SELF);
            assert (parent != null) : "No parent found for element '" + String.valueOf(element) + "' matching class '" + aggregationClass.getCanonicalName() + "'";
            return (T)parent;
        }
        assert (false) : "Unsupported endpoint type: " + endpoint.getClass().getCanonicalName();
        return null;
    }
}

