/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.script;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class ModifyGroovyScriptConfigurationCommand
extends SoftwareSystemBasedCommand<IModifyGroovyScriptConfigurationInteraction> {
    public ModifyGroovyScriptConfigurationCommand(ISoftwareSystemProvider provider, IModifyGroovyScriptConfigurationInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.MODIFY_GROOVY_SCRIPT_CONFIGURATION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        ModifyGroovyScriptConfigurationData data = new ModifyGroovyScriptConfigurationData();
        if (!((IModifyGroovyScriptConfigurationInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IGroovyExtension groovyExtension = this.getController().getSoftwareSystem().getExtension(IGroovyExtension.class);
        boolean requiresSave = groovyExtension.editRequiresSave(data.getScript(), data.getName());
        if (requiresSave && !((IModifyGroovyScriptConfigurationInteraction)this.getInteraction()).confirmSaveOnEdit()) {
            return;
        }
        OperationResult result = groovyExtension.modifyScriptConfiguration(workerContext, data.getScript(), data.getName(), data.getScriptContent());
        ((IModifyGroovyScriptConfigurationInteraction)this.getInteraction()).process(result);
    }

    public static interface IModifyGroovyScriptConfigurationInteraction
    extends ICommandInteraction {
        public boolean collect(ModifyGroovyScriptConfigurationData var1);

        public boolean confirmSaveOnEdit();

        public void process(OperationResult var1);
    }

    public static final class ModifyGroovyScriptConfigurationData
    implements ICommandInteractionData {
        private GroovyScript m_script;
        private String m_name;
        private ScriptContent m_content;

        public void setName(String name) {
            assert (name != null) : "Parameter 'modifiedName' of method 'setModifiedName' must not be null";
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public void setScriptContent(ScriptContent content) {
            assert (content != null) : "Parameter 'content' of method 'setContent' must not be null";
            this.m_content = content;
        }

        public ScriptContent getScriptContent() {
            return this.m_content;
        }

        public GroovyScript getScript() {
            return this.m_script;
        }

        public void setScript(GroovyScript script) {
            assert (script != null) : "Parameter 'script' of method 'setScript' must not be null";
            this.m_script = script;
        }
    }
}

