/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.resolution;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IIssueExtension;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.List;
import java.util.stream.Collectors;

public class UpdateResolutionMatchingInfoCommand
extends SimpleSoftwareSystemBasedCommand {
    private final List<Resolution> m_resolutionsToUpdate;

    public UpdateResolutionMatchingInfoCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, List<Resolution> resolutionsToUpdate) {
        super(provider, interaction);
        this.m_resolutionsToUpdate = resolutionsToUpdate;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.UPDATE_RESOLUTION_MATCHING_INFO;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        OperationResult result = this.getSoftwareSystem().getExtension(IIssueExtension.class).updateMatchingInfo(workerContext, this.m_resolutionsToUpdate);
        ((SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction)this.getInteraction()).process(result);
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess()) {
            if (!this.getController().getSoftwareSystem().getCurrentModel().isModifiable()) {
                enabled.addErrorMessage("Virtual model not modifiable");
            } else if (this.m_resolutionsToUpdate == null || this.m_resolutionsToUpdate.isEmpty()) {
                enabled.addErrorMessage("There are no issues to update");
            }
            if (this.getUpdatableResolutions().isEmpty()) {
                enabled.addErrorMessage("No resolutions to update");
            }
        }
        return enabled;
    }

    private List<Resolution> getUpdatableResolutions() {
        List<Resolution> updatableResolutions = this.m_resolutionsToUpdate.stream().filter(r -> r.getResolutionMatchingConfidenceAsDouble() != null && Double.compare(r.getResolutionMatchingConfidenceAsDouble(), 0.0) > 0).collect(Collectors.toList());
        return updatableResolutions;
    }
}

