/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.remoting;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IRemoteSelectionExtension;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class SingleRemoteSelectionRequestCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public SingleRemoteSelectionRequestCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.REQUEST_SELECTION_IN_IDE;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        if (((IInteraction)this.getInteraction()).collect(data)) {
            OperationResult result = this.getController().getInstallation().getExtension(IRemoteSelectionExtension.class).sendSingleSelectionRequest(data.getElement(), data.getLineNumber());
            ((IInteraction)this.getInteraction()).processResult(result);
        }
    }

    public static interface IInteraction
    extends ICommandInteractionWithResult {
        public boolean collect(InteractionData var1);
    }

    public static final class InteractionData
    implements ICommandInteractionData {
        private NamedElement m_element;
        private int m_lineNumber = -1;

        public NamedElement getElement() {
            return this.m_element;
        }

        public void setElement(NamedElement element) {
            this.m_element = element;
        }

        public void setLineNumber(int lineNumber) {
            this.m_lineNumber = lineNumber;
        }

        public int getLineNumber() {
            return this.m_lineNumber;
        }
    }
}

