/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SelectDependenciesCommand
extends ArchitecturalViewCommand<ISelectDependenciesInteraction> {
    public SelectDependenciesCommand(ISoftwareSystemProvider provider, ISelectDependenciesInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.ARCHITECTURAL_VIEW_SELECT_DEPENDENCIES;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        SelectDependenciesData data = new SelectDependenciesData();
        if (!((ISelectDependenciesInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        this.getController().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class).selectDependencies(data.getNodes());
    }

    public static interface ISelectDependenciesInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(SelectDependenciesData var1);
    }

    public static class SelectDependenciesData
    implements IArchitecturalViewCommandInteractionData {
        private List<ArchitecturalViewNode> m_nodes;

        SelectDependenciesData() {
        }

        public void setData(List<ArchitecturalViewNode> nodes) {
            assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'setData' must not be empty";
            this.m_nodes = new ArrayList<ArchitecturalViewNode>(nodes);
        }

        List<ArchitecturalViewNode> getNodes() {
            return Collections.unmodifiableList(this.m_nodes);
        }
    }
}

