/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ElementsData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class DeleteElementsCommand
extends ArchitecturalViewCommand<IDeleteElementsInteraction> {
    public DeleteElementsCommand(ISoftwareSystemProvider provider, IDeleteElementsInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_ARCHITECTURAL_VIEW_ELEMENTS;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        ElementsData data = new ElementsData();
        if (!((IDeleteElementsInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.deleteElements(workerContext, data.getElements());
        ((IDeleteElementsInteraction)this.getInteraction()).processDeleteElementsResult(result);
    }

    public static interface IDeleteElementsInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(ElementsData var1);

        public void processDeleteElementsResult(OperationResult var1);
    }
}

