/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.OpenSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class RefreshCommand
extends SoftwareSystemBasedCommand<IRefreshInteraction> {
    public RefreshCommand(ISoftwareSystemProvider provider, IRefreshInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final boolean providesProgress() {
        return true;
    }

    @Override
    public final ActivityMode getActivityMode() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    @Override
    public final boolean isUndoable() {
        return false;
    }

    protected abstract boolean refreshOnSoftwareSystemReload();

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        ISoftwareSystemController controller = this.getController();
        IRefreshInteraction interaction = (IRefreshInteraction)this.getInteraction();
        RefreshData refreshData = new RefreshData();
        interaction.collectRefreshData(refreshData);
        workerContext.setNumberOfSteps(2, new int[]{3, 97});
        workerContext.beginSubTask("Prepare Refresh");
        PrepareRefreshResult prepareRefresh = controller.prepareRefresh(workerContext, refreshData.getOptions(), refreshData.getLimitTo());
        interaction.processPrepareRefreshResult(prepareRefresh);
        workerContext.endSubTask();
        if (prepareRefresh.isSuccess()) {
            PrepareRefreshResult.SoftwareSystemFileModification softwareSystemFileModification = prepareRefresh.getSoftwareSystemFileModification();
            if (softwareSystemFileModification != PrepareRefreshResult.SoftwareSystemFileModification.NONE) {
                IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse response = interaction.confirmPreRefreshSoftwareSystemFileModification(softwareSystemFileModification);
                switch (response) {
                    case CONTINUE: {
                        prepareRefresh.setIgnoreSoftwareSystemFileModification();
                        break;
                    }
                    case CLOSE: {
                        workerContext.beginSubTask("Close Software System");
                        this.runPrerequisiteCommand(new CloseSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), interaction), workerContext);
                        workerContext.endSubTask();
                        return;
                    }
                    case RELOAD: {
                        workerContext.beginSubTask("Reload Software System");
                        this.runPrerequisiteCommand(new OpenSoftwareSystemCommand(this.getController(), interaction, this.refreshOnSoftwareSystemReload()), workerContext);
                        workerContext.endSubTask();
                        return;
                    }
                    default: {
                        assert (false) : "Unhandled software system file modification response:" + String.valueOf((Object)response);
                        break;
                    }
                }
            }
            if (prepareRefresh.confirmationRequired() && !interaction.confirmPreRefreshActions(prepareRefresh)) {
                return;
            }
            OperationResult saveResult = new OperationResult("Confirm save for external changes");
            SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
            if (softwareSystem.getUniqueExistingChild(Workspace.class).isExternalConfigurationChanged() && !this.confirmSaveForExternalChanges(workerContext, saveResult)) {
                return;
            }
            for (PrepareRefreshResult.Question question : prepareRefresh.getQuestions()) {
                if (!interaction.answerPreRefreshQuestion(question)) continue;
                question.recordAnswer(true);
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Refresh");
            OperationResult refreshResult = controller.refresh(workerContext, prepareRefresh);
            workerContext.endSubTask();
            boolean isRefreshSuccess = refreshResult.isSuccess();
            if (softwareSystem.getUniqueExistingChild(Workspace.class).isExternalConfigurationChanged()) {
                saveResult.reset();
                this.confirmSaveForExternalChanges(workerContext, saveResult);
            }
            refreshResult.addMessagesFrom(saveResult);
            refreshResult.setIsSuccess(isRefreshSuccess);
            interaction.processRefreshResult(refreshResult);
        }
    }

    private boolean confirmSaveForExternalChanges(IWorkerContext workerContext, OperationResult result) {
        boolean historyAvailable;
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        IUndoRedoExtension undoRedoExtension = softwareSystem.getExtension(IUndoRedoExtension.class);
        SoftwareSystemFile systemFile = this.getController().getSoftwareSystem().getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        boolean originalNeedsSave = systemFile.needsSave();
        boolean bl = historyAvailable = undoRedoExtension.getHistorySize(softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile()) > 0;
        if (((IRefreshInteraction)this.getInteraction()).confirmSystemSaveDueToExternalFileChangesOnOpen(historyAvailable)) {
            if (!originalNeedsSave) {
                systemFile.setNeedsSave(true);
            }
            OperationResult saveResult = this.getController().saveSoftwareSystem(workerContext);
            result.addMessagesFrom(saveResult);
            if (saveResult.isFailure() && originalNeedsSave != systemFile.needsSave()) {
                systemFile.setNeedsSave(originalNeedsSave);
            }
            return true;
        }
        return false;
    }

    public static interface IRefreshInteraction
    extends AbstractOpenCommand.IOpenInteraction {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public void collectRefreshData(RefreshData var1);

        default public void processPrepareRefreshResult(PrepareRefreshResult result) {
            assert (result != null) : "Parameter 'result' of method 'processRefreshPrepareResult' must not be null";
        }

        public PreRefreshSoftwareSystemFileModificationResponse confirmPreRefreshSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification var1);

        public boolean confirmPreRefreshActions(PrepareRefreshResult var1);

        public boolean answerPreRefreshQuestion(PrepareRefreshResult.Question var1);

        default public void processRefreshResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processRefreshResult' must not be null";
        }

        public static enum PreRefreshSoftwareSystemFileModificationResponse {
            CONTINUE,
            CLOSE,
            RELOAD;

        }
    }

    public static final class RefreshData
    implements ICommandInteractionData {
        private final Set<ISoftwareSystemProvider.IRefreshOption> m_refreshOptions = new LinkedHashSet<ISoftwareSystemProvider.IRefreshOption>();
        private final Set<Language> m_limitToLanguages = new LinkedHashSet<Language>();

        public void addOptions(ISoftwareSystemProvider.IRefreshOption ... options) {
            assert (options != null) : "Parameter 'options' of method 'addOptions' must not be null";
            this.m_refreshOptions.addAll(Arrays.asList(options));
        }

        public void removeOptions(ISoftwareSystemProvider.IRefreshOption ... options) {
            assert (options != null) : "Parameter 'options' of method 'removeOptions' must not be null";
            this.m_refreshOptions.removeAll(Arrays.asList(options));
        }

        Set<ISoftwareSystemProvider.IRefreshOption> getOptions() {
            return Collections.unmodifiableSet(this.m_refreshOptions);
        }

        public void addLimitTo(Language language) {
            assert (language != null) : "Parameter 'language' of method 'addLimitTo' must not be null";
            this.m_limitToLanguages.add(language);
        }

        Set<Language> getLimitTo() {
            return Collections.unmodifiableSet(this.m_limitToLanguages);
        }

        public String toString() {
            return "Refresh options: " + this.m_refreshOptions.toString() + ", limit to languages: " + this.m_limitToLanguages.toString();
        }
    }
}

