/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public abstract class CreateModuleCommand
extends SimpleSoftwareSystemBasedCommand {
    private final String m_name;
    private final String m_description;

    public static final ITextValidator getNameValidator(ISoftwareSystemProvider controller) {
        assert (controller != null) : "Parameter 'controller' of method 'getNameValidator' must not be null";
        assert (controller.hasSoftwareSystem()) : "No software system openend";
        return controller.getSoftwareSystem().getExtension(IWorkspaceExtension.class).getModuleNameValidator();
    }

    protected CreateModuleCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, String name, String description) {
        super(provider, interaction);
        assert (name != null) : "Parameter 'name' of method 'CreateModuleCommand' must not be null";
        assert (description != null) : "Parameter 'description' of method 'CreateModuleCommand' must not be null";
        this.m_name = name;
        this.m_description = description;
    }

    protected final String getName() {
        return this.m_name;
    }

    protected final String getDescription() {
        return this.m_description;
    }

    @Override
    public final Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && !CreateModuleCommand.getNameValidator(this.getController()).isValid(null, this.m_name).isSuccess()) {
            enabled.addErrorMessage("No valid module name");
        }
        return enabled;
    }

    protected final Module createModule(IWorkerContext workerContext, Module.IModuleType moduleType) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createModule' must not be null";
        assert (moduleType != null) : "Parameter 'moduleType' of method 'createModule' must not be null";
        OperationResultWithOutcome<Module> result = this.getController().getSoftwareSystem().getExtension(IWorkspaceExtension.class).createModule(workerContext, moduleType, this.getName(), this.getDescription());
        ((SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction)this.getInteraction()).process((OperationResult)result);
        return (Module)result.getOutcome();
    }
}

