/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;

public abstract class AbstractCreateSoftwareSystemCommand
extends SonargraphCommand {
    public static ITextValidator getNameValidator(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getNameValidator' must not be null";
        return ((ISoftwareSystemController)provider).getSoftwareSystemNameValidator();
    }

    public static IPathValidator getBaseDirectoryValidator(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getPathValidator' must not be null";
        return ((ISoftwareSystemController)provider).getSoftwareSystemBaseDirectoryValidator();
    }

    public static String validateSystemOverwrite(ISoftwareSystemProvider provider, TFile baseDirectory, String name) {
        assert (provider != null) : "Parameter 'provider' of method 'getPathValidator' must not be null";
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'validateSystemOverwrite' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'validateSystemOverwrite' must not be empty";
        return ((ISoftwareSystemController)provider).validateOverwrite(baseDirectory, name);
    }

    public AbstractCreateSoftwareSystemCommand(ISoftwareSystemProvider provider) {
        super(provider);
    }

    @Override
    protected final boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    public static interface IInteraction
    extends CloseSoftwareSystemCommand.ICloseInteraction {
        public boolean collect(SoftwareSystemData var1);

        public boolean confirmOverwrite(String var1);

        public void processCreateSoftwareSystemResult(OperationResult var1);
    }

    public static final class SoftwareSystemData
    implements ICommandInteractionData {
        private String m_name;
        private String m_description;
        private TFile m_baseDirectory;
        private ImportQualityModel m_importQualityModel;

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        public void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        public void setBaseDirectory(TFile baseDirectory) {
            assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'setBaseDirectory' must not be null";
            this.m_baseDirectory = baseDirectory;
        }

        public void setQualityModel(ImportQualityModel importQualityModel) {
            this.m_importQualityModel = importQualityModel;
        }

        String getName() {
            return this.m_name;
        }

        String getDescription() {
            return this.m_description;
        }

        TFile getBaseDirectory() {
            return this.m_baseDirectory;
        }

        ImportQualityModel getQualityModel() {
            return this.m_importQualityModel;
        }
    }
}

