/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.sonargraph.core.command.common.DateNever;
import com.hello2morrow.sonargraph.core.command.common.ProductProperty;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseMessageCause;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.license.controller.LicenseProvider;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SonargraphLicenseValidator {
    static final int VERSION_DIGIT_ANY = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphLicenseValidator.class);
    private static final String SEPARATOR = ",";
    private static final String ANY = "Any";
    private static final String DATE_NEVER = "Never";
    private static final String VERSION_SEPARATOR = ".";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final int THRESHOLD_EXPIRE_DAYS = 14;
    private static final String LANGUAGE_PREFIX = "Language-";
    private final List<String> m_userInfo = new ArrayList<String>();
    private final SonargraphProduct m_product;
    private final Version m_productVersion;
    private final Map<String, String> m_productProperties;
    private final Map<String, Language> m_availableLanguages;
    private final LicenseProvider m_licenseProvider;

    SonargraphLicenseValidator(SonargraphProduct product, Version version, Map<String, String> productProperties, Map<String, Language> availableLanguages, LicenseProvider licenseProvider) {
        assert (product != null) : "Parameter 'product' of method 'SonargraphLicenseValidator' must not be null";
        assert (version != null) : "Parameter 'version' of method 'SonargraphLicenseValidator' must not be null";
        assert (productProperties != null) : "Parameter 'productProperties' of method 'SonargraphLicenseValidator' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'SonargraphLicenseValidator' must not be null";
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'SonargraphLicenseValidator' must not be null";
        this.m_product = product;
        this.m_productVersion = version;
        this.m_productProperties = productProperties;
        this.m_availableLanguages = availableLanguages;
        this.m_licenseProvider = licenseProvider;
    }

    static final boolean isLicensed(Version productVersion, Version licenseVersion) {
        assert (licenseVersion != null) : "Parameter 'licensedVersion' of method 'isLicensedVersionValid' must not be null";
        assert (productVersion != null) : "Parameter 'productVersion' of method 'isLicensedVersionValid' must not be null";
        assert (productVersion.getMajor() != -1) : "Invalid product version (major): " + String.valueOf(productVersion);
        assert (licenseVersion.getMajor() != -1) : "Invalid license version: " + String.valueOf(productVersion);
        if (licenseVersion.getMajor() > productVersion.getMajor()) {
            return true;
        }
        if (productVersion.getMajor() > licenseVersion.getMajor()) {
            return false;
        }
        if (licenseVersion.getMinor() != -1) {
            assert (productVersion.getMinor() != -1) : "Invalid product version (minor): " + String.valueOf(productVersion);
            if (licenseVersion.getMinor() > productVersion.getMinor()) {
                return true;
            }
            if (productVersion.getMinor() > licenseVersion.getMinor()) {
                return false;
            }
        }
        if (licenseVersion.getIncrement() != -1) {
            assert (productVersion.getIncrement() != -1) : "Invalid product version (increment): " + String.valueOf(productVersion);
            if (licenseVersion.getIncrement() > productVersion.getIncrement()) {
                return true;
            }
            if (productVersion.getIncrement() > licenseVersion.getIncrement()) {
                return false;
            }
        }
        if (licenseVersion.getBuild() != -1) {
            assert (productVersion.getBuild() != -1) : "Invalid product version (build): " + String.valueOf(productVersion);
            if (licenseVersion.getBuild() > productVersion.getBuild()) {
                return true;
            }
            if (productVersion.getBuild() > licenseVersion.getBuild()) {
                return false;
            }
        }
        return true;
    }

    void validateLanguage(SonargraphLicense license, String key, String value, Map<Language, Integer> licensedLanguageToSize) {
        assert (license != null) : "Parameter 'license' of method 'processLanguae' must not be null";
        assert (key != null) : "Parameter 'key' of method 'processLanguae' must not be null";
        assert (value != null) : "Parameter 'value' of method 'processLanguae' must not be null";
        assert (licensedLanguageToSize != null) : "Parameter 'licensedLanguageToSize' of method 'validateLanguage' must not be null";
        Language availableLanguage = this.m_availableLanguages.get(key);
        if (availableLanguage != null) {
            if (availableLanguage.needsLicense()) {
                try {
                    Integer size = Integer.valueOf(value);
                    if (size != -1) {
                        licensedLanguageToSize.put(availableLanguage, size);
                    }
                }
                catch (NumberFormatException ex) {
                    license.getNonPropertyRelatedValidationResult().addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.INVALID_LANGUAGE_SIZE_FORMAT, "For language '" + key + "'", new Object[0]);
                }
            }
        } else {
            license.getNonPropertyRelatedValidationResult().addWarning((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LANGUAGE_NOT_AVAILABLE_IN_INSTALLATION, "'" + key + "'", new Object[0]);
        }
    }

    private void validateVersion(SonargraphLicense license, String version) {
        assert (license != null) : "Parameter 'license' of method 'validateVersion' must not be null";
        assert (version != null) : "Parameter 'version' of method 'processVersion' must not be null";
        if (ANY.equalsIgnoreCase(version)) {
            return;
        }
        if (version.contains(VERSION_SEPARATOR)) {
            String[] licenseVersionParts = version.split("\\.");
            try {
                int major = Integer.parseInt(licenseVersionParts[0]);
                int minor = licenseVersionParts.length >= 2 ? Integer.parseInt(licenseVersionParts[1]) : -1;
                int increment = licenseVersionParts.length >= 3 ? Integer.parseInt(licenseVersionParts[2]) : -1;
                int build = licenseVersionParts.length == 4 ? Integer.parseInt(licenseVersionParts[3]) : -1;
                Version licenseVersion = Version.create((int)major, (int)minor, (int)increment, (int)build);
                if (!SonargraphLicenseValidator.isLicensed(this.m_productVersion, licenseVersion)) {
                    license.setValidationError(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.VERSION_NOT_LICENSED);
                }
            }
            catch (NumberFormatException ex) {
                license.setValidationError(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.INVALID_VERSION_FORMAT);
            }
        } else {
            try {
                int major = Integer.parseInt(version);
                Version licenseVersion = Version.create((int)major, (int)-1, (int)-1, (int)-1);
                if (!SonargraphLicenseValidator.isLicensed(this.m_productVersion, licenseVersion)) {
                    license.setValidationError(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.VERSION_NOT_LICENSED);
                }
            }
            catch (NumberFormatException ex) {
                license.setValidationError(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.INVALID_VERSION_FORMAT);
            }
        }
    }

    private void validateProduct(SonargraphLicense license, String product) {
        assert (license != null) : "Parameter 'license' of method 'validateProduct' must not be null";
        if (product != null && !product.isEmpty()) {
            HashSet<String> products = new HashSet<String>();
            String[] stringArray = product.split(SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nextProduct = stringArray[n2];
                if (nextProduct.equals("SonargraphExplorer")) {
                    products.add("Sonargraph");
                } else {
                    products.add(nextProduct);
                }
                ++n2;
            }
            if (!products.contains(this.m_product.getStandardName())) {
                license.setValidationError(SonargraphLicense.Property.PRODUCT, SonargraphLicenseMessageCause.PRODUCT_DOES_NOT_MATCH);
            }
        } else {
            license.setValidationError(SonargraphLicense.Property.PRODUCT, SonargraphLicenseMessageCause.PRODUCT_NOT_SPECIFIED);
        }
    }

    private void validateMacAddresses(SonargraphLicense license, String macAddresses) {
        assert (license != null) : "Parameter 'license' of method 'validateMacAddresses' must not be null";
        assert (macAddresses != null) : "Parameter 'macAddresses' of method 'validateMacAddresses' must not be empty";
        if (ANY.equalsIgnoreCase(macAddresses)) {
            return;
        }
        HashSet<String> splitMacAddresses = new HashSet<String>();
        String[] stringArray = macAddresses.split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nextMacAddress = stringArray[n2];
            splitMacAddresses.add(nextMacAddress);
            ++n2;
        }
        OperationResult.IMessageCause errorCause = this.m_licenseProvider.checkMacAddresses(splitMacAddresses);
        if (errorCause != null) {
            license.setValidationError(SonargraphLicense.Property.MAC_ADDRESSES, errorCause);
        }
    }

    private void validateTicketExpirationDate(SonargraphLicense license, String date) {
        boolean checkDateOnly;
        SimpleDateFormat parserSDF;
        assert (license != null) : "Parameter 'license' of method 'validateTicketExpirationDate' must not be null";
        assert (date != null) : "Parameter 'date' of method 'validateTicketExpirationDate' must not be null";
        if (DATE_NEVER.equalsIgnoreCase(date)) {
            license.setTicketExpirationDate(DateNever.INSTANCE);
            return;
        }
        if (date.indexOf(84) > 0) {
            parserSDF = new SimpleDateFormat(TIME_FORMAT);
            checkDateOnly = false;
        } else {
            parserSDF = new SimpleDateFormat(DATE_FORMAT);
            checkDateOnly = true;
        }
        parserSDF.setLenient(false);
        Date dateObj = null;
        try {
            dateObj = parserSDF.parse(date);
            license.setTicketExpirationDate(dateObj);
        }
        catch (ParseException ex) {
            license.setValidationError(SonargraphLicense.Property.TICKET_EXPIRATION, SonargraphLicenseMessageCause.INVALID_DATE_FORMAT);
            return;
        }
        if (checkDateOnly) {
            if (this.m_licenseProvider.getDaysLeft(dateObj) < 0) {
                license.setValidationError(SonargraphLicense.Property.TICKET_EXPIRATION, SonargraphLicenseMessageCause.LICENSE_TICKET_EXPIRED);
            }
        } else {
            Date now = new Date();
            if (now.compareTo(dateObj) > 0) {
                license.setValidationError(SonargraphLicense.Property.TICKET_EXPIRATION, SonargraphLicenseMessageCause.LICENSE_TICKET_EXPIRED);
            }
        }
    }

    private void validateExpirationDate(SonargraphLicense license, String date) {
        assert (license != null) : "Parameter 'license' of method 'validateExpirationDate' must not be null";
        assert (date != null) : "Parameter 'date' of method 'validateExpirationDate' must not be null";
        if (DATE_NEVER.equalsIgnoreCase(date)) {
            license.setExpirationDate(DateNever.INSTANCE);
            return;
        }
        SimpleDateFormat parserSDF = new SimpleDateFormat(DATE_FORMAT);
        parserSDF.setLenient(false);
        Date dateObj = null;
        try {
            dateObj = parserSDF.parse(date);
            license.setExpirationDate(dateObj);
        }
        catch (ParseException ex) {
            license.setValidationError(SonargraphLicense.Property.EXPIRATION, SonargraphLicenseMessageCause.INVALID_DATE_FORMAT);
            return;
        }
        int daysLeft = this.m_licenseProvider.getDaysLeft(dateObj);
        if (daysLeft <= 0) {
            license.setValidationError(SonargraphLicense.Property.EXPIRATION, SonargraphLicenseMessageCause.LICENSE_EXPIRED);
        } else if (daysLeft < 14) {
            String msg = license.getNonPropertyRelatedValidationResult().addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_CONTRACT_WILL_EXPIRE_SOON, CoreResourceProviderAdapter.getInstance().getString("core.message.license.contractWillExpire", new Object[]{daysLeft}));
            this.m_userInfo.add(msg);
        }
    }

    private void validateSupportExpirationDate(SonargraphLicense license, String date) {
        assert (license != null) : "Parameter 'license' of method 'validateSupportExpirationDate' must not be null";
        assert (date != null) : "Parameter 'date' of method 'validateSupportExpirationDate' must not be null";
        if (DATE_NEVER.equalsIgnoreCase(date)) {
            license.setSupportExpirationDate(DateNever.INSTANCE);
            return;
        }
        SimpleDateFormat parserSDF = new SimpleDateFormat(DATE_FORMAT);
        parserSDF.setLenient(false);
        Date dateObj = null;
        Date buildDate = null;
        try {
            dateObj = parserSDF.parse(date);
            buildDate = parserSDF.parse(this.m_productProperties.get(ProductProperty.BUILD_DATE.getStandardName()));
            license.setSupportExpirationDate(dateObj);
            if (buildDate.after(dateObj)) {
                license.setValidationError(SonargraphLicense.Property.SUPPORT_EXPIRATION, SonargraphLicenseMessageCause.SUPPORT_EXPIRED);
                return;
            }
        }
        catch (ParseException ex) {
            license.setValidationError(SonargraphLicense.Property.SUPPORT_EXPIRATION, SonargraphLicenseMessageCause.INVALID_DATE_FORMAT);
            return;
        }
        int daysLeft = this.m_licenseProvider.getDaysLeft(dateObj);
        if (daysLeft < 0) {
            String msg = license.getNonPropertyRelatedValidationResult().addWarning((OperationResult.IMessageCause)SonargraphLicenseMessageCause.SUPPORT_EXPIRED, "Support expired " + -1 * daysLeft + " days ago.", new Object[0]);
            this.m_userInfo.add(msg);
        } else if (daysLeft < 14) {
            String msg = license.getNonPropertyRelatedValidationResult().addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.SUPPORT_WILL_EXPIRE_SOON, CoreResourceProviderAdapter.getInstance().getString("core.message.license.supportWillExpire", new Object[]{daysLeft}));
            this.m_userInfo.add(msg);
        }
    }

    private void validateFeatures(SonargraphLicense license, String featuresString) {
        assert (license != null) : "Parameter 'license' of method 'validateSpecialFeatures' must not be null";
        assert (featuresString != null) : "Parameter 'featuresString' of method 'validateFeatures' must not be null";
        EnumSet<SonargraphFeature> features = EnumSet.noneOf(SonargraphFeature.class);
        if (!featuresString.isEmpty()) {
            String[] splitFeatures;
            String[] stringArray = splitFeatures = featuresString.split(SEPARATOR);
            int n = splitFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                String nextFeature = stringArray[n2];
                try {
                    features.add(SonargraphFeature.fromStandardName(nextFeature.trim()));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.info("Ignoring unknown feature: " + nextFeature.trim());
                }
                ++n2;
            }
        }
        license.setFeatures(features);
    }

    private void validateDisabledCategories(SonargraphLicense license, String input) {
        assert (license != null) : "Parameter 'license' of method 'validateDisabledCategories' must not be null";
        assert (input != null) : "Parameter 'disabledCategories' of method 'validateDisabledCategories' must not be null";
        EnumSet<SonargraphCategory> disabledCategories = EnumSet.noneOf(SonargraphCategory.class);
        if (!input.isEmpty()) {
            String[] splitDisabledCategories;
            String[] stringArray = splitDisabledCategories = input.split(SEPARATOR);
            int n = splitDisabledCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String nextDisabeldCategory = stringArray[n2];
                try {
                    disabledCategories.add(SonargraphCategory.fromStandardName(nextDisabeldCategory.trim()));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.info("Ignoring unknown category: " + nextDisabeldCategory.trim());
                }
                ++n2;
            }
        }
        license.setDisabledCategories(disabledCategories);
    }

    private static void validateLogin(SonargraphLicense license, String licensedLogin) {
        assert (license != null) : "Parameter 'license' of method 'validateLogin' must not be null";
        assert (licensedLogin != null) : "Parameter 'licensedLogin' of method 'validateLogin' must not be null";
        String login = Platform.getUserName();
        if (licensedLogin.equalsIgnoreCase(ANY)) {
            return;
        }
        if (!licensedLogin.equalsIgnoreCase(login)) {
            license.setValidationError(SonargraphLicense.Property.LOGIN, SonargraphLicenseMessageCause.INVALID_LOGIN);
        }
    }

    private void validateActivationCode(SonargraphLicense license, String activationCode) {
        assert (activationCode != null) : "Parameter 'activationCode' of method 'validateActivationCode' must not be null";
        if (!this.m_licenseProvider.validateActivationCodeFormat(activationCode)) {
            license.setValidationError(SonargraphLicense.Property.ACTIVATION_CODE, SonargraphLicenseMessageCause.INVALID_FORMAT_ACTIVATION_CODE);
        }
    }

    private boolean isSupportExpirationRequired(SonargraphLicense license) {
        assert (license != null) : "Parameter 'license' of method 'isSupportExpirationRequired' must not be null";
        String version = license.getValue(SonargraphLicense.Property.VERSION);
        return version == null || version.equalsIgnoreCase(ANY);
    }

    void validate(SonargraphLicense license) {
        assert (license != null) : "Parameter 'license' of method 'validate' must not be null";
        LinkedHashMap<Language, Integer> licensedLanguageToSize = new LinkedHashMap<Language, Integer>();
        block13: for (Map.Entry<String, String> nextEntry : license.getProperties().entrySet()) {
            String nextPropertyKey = nextEntry.getKey();
            String nextPropertyValue = nextEntry.getValue();
            if (nextPropertyValue.isEmpty()) continue;
            if (nextPropertyKey.startsWith(LANGUAGE_PREFIX)) {
                String nextLanguage = nextPropertyKey.substring(LANGUAGE_PREFIX.length());
                this.validateLanguage(license, nextLanguage, nextPropertyValue, licensedLanguageToSize);
                continue;
            }
            SonargraphLicense.Property property = SonargraphLicense.Property.fromStandardName(nextPropertyKey);
            if (property != null) {
                switch (property) {
                    case PRODUCT: {
                        this.validateProduct(license, nextPropertyValue);
                        continue block13;
                    }
                    case VERSION: {
                        this.validateVersion(license, nextPropertyValue);
                        continue block13;
                    }
                    case MAC_ADDRESSES: {
                        this.validateMacAddresses(license, nextPropertyValue);
                        continue block13;
                    }
                    case ACTIVATION_CODE: {
                        this.validateActivationCode(license, nextPropertyValue);
                        continue block13;
                    }
                    case LOGIN: {
                        SonargraphLicenseValidator.validateLogin(license, nextPropertyValue);
                        continue block13;
                    }
                    case SPECIAL_LICENSE_FEATURES: {
                        this.validateFeatures(license, nextPropertyValue);
                        continue block13;
                    }
                    case DISABLED_CATEGORIES: {
                        this.validateDisabledCategories(license, nextPropertyValue);
                        continue block13;
                    }
                    case EXPIRATION: {
                        this.validateExpirationDate(license, nextPropertyValue);
                        continue block13;
                    }
                    case SUPPORT_EXPIRATION: {
                        if (!this.isSupportExpirationRequired(license)) continue block13;
                        this.validateSupportExpirationDate(license, nextPropertyValue);
                        continue block13;
                    }
                    case TICKET_EXPIRATION: {
                        this.validateTicketExpirationDate(license, nextPropertyValue);
                        continue block13;
                    }
                    case LICENSE: 
                    case LICENSOR: 
                    case LICENSEE: 
                    case USER: 
                    case CONTRACT: 
                    case CREATION: 
                    case TICKET_ID: 
                    case TICKET_MAGIC: 
                    case HEART_BEAT_SECONDS: {
                        continue block13;
                    }
                    default: {
                        assert (false) : "Unhandled property: " + String.valueOf((Object)property);
                        continue block13;
                    }
                }
            }
            if ("Signature".equals(nextPropertyKey)) continue;
            LOGGER.info("Ignoring unknown property: " + nextPropertyKey);
        }
        for (Language nextAvailableLanguage : this.m_availableLanguages.values()) {
            if (licensedLanguageToSize.containsKey(nextAvailableLanguage) || nextAvailableLanguage.needsLicense()) continue;
            licensedLanguageToSize.put(nextAvailableLanguage, 0);
        }
        license.setLanguages(licensedLanguageToSize);
        boolean noLanguagesLicensed = licensedLanguageToSize.entrySet().stream().allMatch(entry -> (Integer)entry.getValue() == -1);
        if (licensedLanguageToSize.isEmpty() || noLanguagesLicensed) {
            license.getNonPropertyRelatedValidationResult().addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.NO_LANGUAGES_LICENSED);
        }
        HashSet<SonargraphLicense.Property> mandatoryProperties = new HashSet<SonargraphLicense.Property>();
        mandatoryProperties.add(SonargraphLicense.Property.PRODUCT);
        mandatoryProperties.add(SonargraphLicense.Property.EXPIRATION);
        if (this.isSupportExpirationRequired(license)) {
            mandatoryProperties.add(SonargraphLicense.Property.SUPPORT_EXPIRATION);
        }
        mandatoryProperties.add(SonargraphLicense.Property.LOGIN);
        mandatoryProperties.add(SonargraphLicense.Property.VERSION);
        if (license.getValue(SonargraphLicense.Property.TICKET_ID) == null) {
            mandatoryProperties.add(SonargraphLicense.Property.MAC_ADDRESSES);
        }
        if (license.getValue(SonargraphLicense.Property.ACTIVATION_CODE) != null) {
            mandatoryProperties.add(SonargraphLicense.Property.TICKET_EXPIRATION);
        } else if (license.getValue(SonargraphLicense.Property.TICKET_EXPIRATION) == null) {
            license.setTicketExpirationDate(DateNever.INSTANCE);
        }
        for (SonargraphLicense.Property nextMandatoryProperty : mandatoryProperties) {
            if (license.getValue(nextMandatoryProperty) != null && !license.getValue(nextMandatoryProperty).isEmpty()) continue;
            license.getNonPropertyRelatedValidationResult().addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.MISSING_MANDATORY_PROPERTY, "'" + nextMandatoryProperty.getStandardName() + "'", new Object[0]);
        }
        if (license.getExpirationDate() != DateNever.INSTANCE) {
            this.m_licenseProvider.hasSystemDateBeenManipulatedTooMuch(license.getNonPropertyRelatedValidationResult(), new Date(), license.getExpirationDate());
        }
        if (this.isSupportExpirationRequired(license) && license.getSupportExpirationDate() != DateNever.INSTANCE) {
            this.m_licenseProvider.hasSystemDateBeenManipulatedTooMuch(license.getNonPropertyRelatedValidationResult(), new Date(), license.getSupportExpirationDate());
        }
        if (license.getTicketExpirationDate() != DateNever.INSTANCE) {
            this.m_licenseProvider.hasSystemDateBeenManipulatedTooMuch(license.getNonPropertyRelatedValidationResult(), new Date(), license.getTicketExpirationDate());
        }
    }

    List<String> getUserInfo() {
        return Collections.unmodifiableList(this.m_userInfo);
    }

    void clearUserInfo() {
        this.m_userInfo.clear();
    }
}

