<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <style type="text/css" MEDIA="all">@import url("hello2morrow.css");</style>
        <script src="tablefilter/tablefilter.js"></script>
        <title>Sonargraph Architect Report - Issue Details for <%=issueId.getPresentationName()%></title>
    </head>

    <body>
        <a name="top"></a>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td width="200" bgcolor="#333333"><img src="spacer.gif" alt="" width="200" height="65" border="0"></td>
                <td width="23" bgcolor="E3E4E5"><img src="spacer.gif" width="23" height="1"></td>
                <td width="100%" bgcolor="E3E4E5">
                    <table border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td width="7" bgcolor="e3e4e5"><img src="spacer.gif" width="7" height="1"></td>
                            <td><img src="hello2morrow.gif" alt="hello2morrow" width="227" height="23" border="0"></td>
                            <td width="100%" align="right" bgcolor="e3e4e5"><img src="header.gif" alt="hello2morrow" width="543" height="65" border="0"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="3" bgcolor="#000000"></td>
            </tr>
            <tr>
<!-- start of navigation -->            
                <td bgcolor="#A7A9AC" valign="top">
                    <div class="leftNav">
                    </div>
                </td>
<!-- end of navigation -->
                <!-- start of spacer -->
                <td width="23"><img src="spacer.gif" width="23" height="1"></td><!-- end of spacer -->
                
                <!-- real content -->
                <td width="100%">
                    <table width="100%" border="0">
                        <tr>
                            <td width="1%" height="80" valign="center">
                                <image src="logo.gif" width="350"></image>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h1><a name="system"></a>Details of Unresolved Issues (<%=issueId.getPresentationName()%>) of <%= report.title %></h1>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <strong>Path: </strong><%= report.systemDirectoryPath %><br/>
                                <strong>System Description: </strong><%= report.softwareSystem.description %><br/>
                                <strong>Sonargraph Version: </strong><%= report.version %><br/>
                                <strong>Report Creation: </strong><%= report.timestampString %><br/>
                                <%
                                if (report.getFocus() == com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.MODULE_LEVEL)
                                {
                                	com.hello2morrow.sonargraph.core.model.report.ModuleReport moduleReport = (com.hello2morrow.sonargraph.core.model.report.ModuleReport) report;
                                	String systemReportFileName = moduleReport.getMainReportTargetFile().getName();
                                	String moduleReportFileName = report.getTargetFile().getName();
								%>
									<strong>Link to Main System Report: </strong><a href="./<%=systemReportFileName%>" target="<%=systemReportFileName%>"><%=systemReportFileName%></a><br/>
									<strong>Link to Main Module Report: </strong><a href="./<%=moduleReportFileName%>" target="<%=moduleReportFileName%>"><%=moduleReportFileName%></a><br/>
								<%                                		
                                }
                                else
                                {
                                %>
                                	<strong>Link to Main Report: </strong><a href="./<%=report.getTargetFile().getName()%>" target="<%=report.getTargetFile().getName()%>"><%=report.getTargetFile().getName()%></a><br/>
                                <%
                                }
                                %>
                                <strong>Current Virtual Model: </strong><%= report.currentVirtualModel %> <br/>
                                <%
                                    if (report.getActiveProfile() != null && report.getActiveProfile().length() > 0)
                                    {
                                %>
                                        <strong>Workspace Profile: </strong><%= report.activeProfile %> <br/>
                                <%
                                    }
                                %>
                                <%
                                    if (report.getQualityModelPath() != null && report.getQualityModelPath().length() > 0)
                                    {
                                %>
                                        <strong>Quality Model: </strong><%= report.qualityModelPath %> <br/>
                                <%
                                    }
                                %>
                                <% 
                                if(truncated)
                                {
                                %>
                                <br/>
                                <strong>NOTE: List of issues has been truncated to contain only <%=issues.size()%> of <%=totalCount%> issues!</strong><br/>
                                <%
                                }
                                %>
                                <%
                                if (diffReport != null)
                                {
                                %>
                                	<strong>System Diff Report: </strong><a href="<%= diffReport%>#issues"><%= diffReport%></a> <br/>
                                <%
                                }
                                %> 
                            </td>
                        </tr>
                        <tr>
                            <td><h2><a name="openIssues"></a>Unresolved Issues (<%=issues.size()%><% if (truncated) out.print(" of " + totalCount)%>) of Type "<%=issueId.getPresentationName()%>"</h2>
								<% 
                                if(truncated)
                                {
                                %>
	                            	To ensure usability, the list has been truncated to contain only the first <%=issues.size()%> of <%=totalCount%> issues.
                                <%
                                }
                                %>                            	
                            </td>
                        </tr>
	                    <tr>
                            <td>
                            <% 
                               i = 0;
                            %>
<!-- Unresolved Duplicates -->
                            <% 
                            if (issueId == com.hello2morrow.sonargraph.core.model.element.CoreIssueId.DUPLICATE_CODE_BLOCK)
                            {
                            %>
                             	<table class="techTable" id="duplicates" width="100%">
                                    <thead>
	                                    <tr>
	                                        <th>Name</th>
	                                        <%
	                                        if (report.isQualityGateCheckActive())
                                        	{
                                        	%>
                                        		<th>Affecting Quality Gate(s)</th>
                                        	<%
                                        	}
                                        	%>
	                                        <th>File</th>
	                                        <th>Line Range</th>
	                                        <th>Block Length (Lines)</th>
	                                        <th>Tolerance (Lines)</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                    i = 0;
                                    for (com.hello2morrow.sonargraph.core.model.element.Issue nextIssue : issues)
                                    {
                                    	com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue duplicateIssue = (com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue) nextIssue;
                                        com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock duplicate = (com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock) duplicateIssue.getAffectedElement();
                                        for (com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence occurrence : duplicate.getChildren(com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence.class))
                                        {
	                                        i++;
                                            out.println("<tr>");
                                            out.println("<td>");
	                                        out.println(duplicate.getName());
                                            out.println("</td>");
                                            
                                            if (report.isQualityGateCheckActive())
	                                        {
	                                        	boolean affecting = report.issueAffectingQualityGates(duplicateIssue);
	                                        	if (affecting)
	                                        	{
	                                        		out.println("<td class=\"qualityGateAffecting\">");
	                                        	} 
	                                        	else
	                                        	{
	                                        		out.println("<td class=\"notQualityGateAffecting\">");
	                                        	}
	                                        	out.println(affecting);
	                                        	out.println("</td>");
	                                        }
                                            
                                            out.println("<td>");
                                            out.println(occurrence.getSourceFile().getPresentationName(false));
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(occurrence.getLineRange());
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(occurrence.getBlockSize());
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(occurrence.getToleranceAsInt());
                                            out.println("</td>");
                                            out.println("</tr>");
                                        }
                                    }
                                    %>
                                </table>
                            	<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort',
							          		types: ['string', 'string', 'string', 'number', 'number']								          		
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Duplicates: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Duplicates/Page: ', rowCounts],
								       	
								       	<%
                                        if (report.isQualityGateCheckActive())
                                    	{
                                    	%>
                                    		col_widths: ['8px', '8px', '40px', '5px', '5px', '5px'],
                                    	<%
                                    	}
                                    	else
                                    	{
                                    	%>
                                    		col_widths: ['8px', '40px', '5px', '5px', '5px'],	
                                    	<%
                                    	}
                                    	%>
								       	
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('duplicates', filtersConfig);
									tf.init();
								</script>
                            <%	
                           	}
                           	else if (issueId == com.hello2morrow.sonargraph.core.model.element.CoreIssueId.COMPONENT_CYCLE_GROUP
                           		|| issueId == com.hello2morrow.sonargraph.core.model.element.CoreIssueId.NAMESPACE_CYCLE_GROUP)
                           	{
                           	%>
<!-- Unresolved Cycle Groups -->                           	
                           	   <table class="techTable" width="100%" id="<%=issueId.getStandardName()%>">
                                	<thead>
	                                    <tr>
	                                        <th>Name</th>
	                                        <%
	                                        if (report.isQualityGateCheckActive())
                                        	{
                                        	%>
                                        		<th>Affecting Quality Gate(s)</th>
                                        	<%
                                        	}
                                        	%>
	                                        <th>Scope</th>
	                                        <th>Size</th>
	                                        <th>Involved Elements</th>
	                                    </tr>
	                                 </thead>
                                    <%
                                    for (com.hello2morrow.sonargraph.core.model.element.Issue nextIssue : issues)
                                    {
                                        com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue nextCycleGroupIssue = (com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue) nextIssue;
                                        com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup group = ((com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup) nextCycleGroupIssue.getAffectedElement())
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(nextCycleGroupIssue.getAffectedElement().getName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        if (report.isQualityGateCheckActive())
                                        {
                                        	boolean affecting = report.issueAffectingQualityGates(nextCycleGroupIssue);
                                        	if (affecting)
                                        	{
                                        		out.println("<td class=\"qualityGateAffecting\">");
                                        	} 
                                        	else
                                        	{
                                        		out.println("<td class=\"notQualityGateAffecting\">");
                                        	}
                                        	out.println(affecting);
                                        	out.println("</td>");
                                        }
                                        out.println(group.getScope().getImageResourceName() + ": " + group.getScope().getPresentationName(true));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(group.getNumberOfCyclicElements());
                                        out.println("</td>");
                                        out.println("<td>");

                                        for (com.hello2morrow.sonargraph.core.model.element.NamedElement next : group.getCyclicNamedElements())
                                        {
                                            out.println(next.getPresentationName(false) + " <br/>");
                                        }    
                                        i++;
                                        out.println("</td>");
                                        out.println("</tr>");
                                    }
                                    %>
                            	</table>               
                                <script>
                                	var rowCount = <%=issues.size()%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort',
							          		types: ['string', 'string', 'number', 'string']								          		
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Cycle Groups: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Cycle Groups/Page: ', rowCounts],
								       	
								       	<%
                                        if (report.isQualityGateCheckActive())
                                    	{
                                    	%>
                                    		col_widths: ['12px', '8px', '15px', '5px', '30px'],
                                    	<%
                                    	}
                                    	else
                                    	{
                                    	%>
                                    		col_widths: ['12px', '15px', '5px', '30px'],	
                                    	<%
                                    	}
                                    	%>
								       	
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('<%=issueId.getStandardName()%>', filtersConfig);
									tf.init();
                                </script>
                            </td>
                           	<%
                           	}
                           	else
                           	{
                           	%>
<!-- Default Handling -->                            	
                                <table class="techTable" width="100%" id="unresolvedIssues">
                                	<thead>
	                                    <tr>
	                                    	<th>Type</th>
	                                        <%
	                                        if (report.isQualityGateCheckActive())
                                        	{
                                        	%>
                                        		<th>Affecting<br/>Quality Gate(s)</th>
                                        	<%
                                        	}
                                        	%>
	                                        <th>Description</th>
	                                        <th>Severity</th>
	                                        <th>Category</th>
	                                        <th>Element</th>
	                                        <th>To Element</th>
	                                        <th>Provider</th>
	                                    </tr>
                                    </thead>
                                    <%                                    
                                    for (com.hello2morrow.sonargraph.core.model.element.Issue issue : issues)
                                    {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(issue.getName());
                                        out.println("</td>");
                                        if (report.isQualityGateCheckActive())
                                        {
                                        	boolean affecting = report.issueAffectingQualityGates(issue);
                                        	if (affecting)
                                        	{
                                        		out.println("<td class=\"qualityGateAffecting\">");
                                        	} 
                                        	else
                                        	{
                                        		out.println("<td class=\"notQualityGateAffecting\">");
                                        	}
                                        	out.println(affecting);
                                        	out.println("</td>");
                                        }
                                        out.println("<td>");
                                        out.println(issue.getDescription());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(issue.getSeverity().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(issue.getId().getCategory().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(report.getElementOrFrom(issue));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(report.getTo(issue));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(issue.getProvider().getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                        i++;
                                    }
                                    %>
                                </table>
                            	<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort'
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Issues: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Issues/Page: ', rowCounts],
								       	<%
                                        if (report.isQualityGateCheckActive())
                                    	{
                                    	%>
                                    		col_widths: ['15px', '10px', '35px', '8px', '8px', '35px', '35px', '10px'],
                                    	<%
                                    	}
                                    	else
                                    	{
                                    	%>
                                    		col_widths: ['15px', '35px', '8px', '8px', '35px', '35px', '10px'],
                                    	<%
                                    	}
                                    	%>
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('unresolvedIssues', filtersConfig);
									tf.init();
								</script>
								<%
								}
								%>
                            </td>
                        </tr>
                    </table>
                </td>
    <!-- end of real content -->
            </tr>
        </table>
    </body>
</html>