/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.snapshot;

import com.hello2morrow.sonargraph.api.Any;
import com.hello2morrow.sonargraph.api.ListAny;
import com.hello2morrow.sonargraph.api.LongAny;
import com.hello2morrow.sonargraph.api.StringAny;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotRootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemFromSnapshotCreator;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.snapshot.INamedElementFactory;
import com.hello2morrow.sonargraph.core.persistence.snapshot.NamedElementFactory;
import com.hello2morrow.sonargraph.core.persistence.snapshot.ObsoleteElementFactory;
import com.hello2morrow.sonargraph.core.persistence.snapshot.RetrievableFactory;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileReader;
import gnu.trove.map.hash.THashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotReader
extends SnapshotProcessor
implements ISnapshotReader,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotReader.class);
    private final Map<String, INamedElementFactory> m_classNameToNamedElementFactory = new THashMap();
    private final Map<String, RetrievableFactory> m_classNameToRetrievableFactory = new THashMap();
    private final List<String> m_languages = new ArrayList<String>();
    private final List<String> m_stringList = new ArrayList<String>();
    private final TFile m_dataFile;
    private ReadableByteChannel m_dataChannel;
    private ByteBuffer m_dataBuffer;
    private List<NamedElement> m_elementList = new ArrayList<NamedElement>();
    private short m_version;
    private ClassLoader m_classLoader;
    private boolean m_treeHasBeenRead;
    private TFileInputStream m_dataStream;

    public SnapshotReader(TFile dataFile) {
        assert (dataFile != null) : "Parameter 'dataFile' of method 'SnapshotReader' must not be null";
        this.m_dataFile = dataFile;
        this.m_classNameToNamedElementFactory.put("com.hello2morrow.sonargraph.languageprovider.java.model.ignore.IgnoreAccess", ObsoleteElementFactory.DEFAULT);
        this.m_classNameToNamedElementFactory.put("com.hello2morrow.sonargraph.languageprovider.java.model.ignore.IgnoreTypeAccess", new ObsoleteElementFactory("S"));
        this.m_classNameToNamedElementFactory.put("com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaSystemSettings", ObsoleteElementFactory.DEFAULT);
    }

    @Override
    public int getVersion() {
        return this.m_version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'open' must not be null";
        try {
            this.m_dataStream = new TFileInputStream((File)new TFile((File)this.m_dataFile, "snapshot.data"));
            this.m_dataChannel = Channels.newChannel((InputStream)this.m_dataStream);
            this.m_dataBuffer = ByteBuffer.allocateDirect(65536);
            this.m_dataBuffer.clear();
            this.m_dataChannel.read(this.m_dataBuffer);
            this.m_dataBuffer.flip();
            int magic = this.m_dataBuffer.getInt();
            if (magic != this.getMagicNumber()) {
                result.addError((OperationResult.IMessageCause)SnapshotProcessor.SnapshotMessageCause.INVALID_SNAPSHOT_FILE_FORMAT);
                return false;
            }
            this.m_version = this.m_dataBuffer.getShort();
            if (this.m_version < 3) {
                result.addError((OperationResult.IMessageCause)SnapshotProcessor.SnapshotMessageCause.INCOMPATIBLE_SNAPSHOT_FILE_FORMAT);
                return false;
            }
            if (this.m_version > 27) {
                result.addError((OperationResult.IMessageCause)SnapshotProcessor.SnapshotMessageCause.UPGRADE_NEEDED, "Snapshot was created with a newer version of Sonargraph. Update Sonargraph to the newest version.", new Object[0]);
                return false;
            }
            while (true) {
                String language;
                if ((language = this.readString()) == null) {
                    return true;
                }
                this.m_languages.add(language);
            }
        }
        catch (Throwable t) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, t);
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_dataChannel != null) {
            try {
                this.m_dataChannel.close();
            }
            catch (IOException exc) {
                LOGGER.warn("Unable to close data channel", (Throwable)exc);
            }
        }
    }

    private void ensureAvailable(int bytes) throws IOException {
        if (this.m_dataBuffer.remaining() < bytes) {
            if (this.m_dataBuffer.remaining() > 0) {
                byte[] rest = new byte[this.m_dataBuffer.remaining()];
                this.m_dataBuffer.get(rest);
                this.m_dataBuffer.clear();
                this.m_dataBuffer.put(rest);
            } else {
                this.m_dataBuffer.clear();
            }
            this.m_dataChannel.read(this.m_dataBuffer);
            this.m_dataBuffer.flip();
        }
    }

    public SoftwareSystem readSnapshot(ClassLoader loader, ISoftwareSystemFromSnapshotCreator creator, SoftwareSystem targetSoftwareSystem, OperationResult result) {
        assert (creator != null) : "Parameter 'creater' of method 'readSnapshot' must not be null";
        assert (loader != null) : "Parameter 'loader' of method 'readSnapshot' must not be null";
        assert (result != null) : "Parameter 'result' of method 'readSnapshot' must not be null";
        this.m_classLoader = loader;
        NamedElement parent = null;
        try {
            SoftwareSystem softwareSystem = null;
            SoftwareSystem setAsModelServiceProvider = null;
            while (true) {
                int parentId;
                NamedElement element;
                String className;
                INamedElementFactory factory;
                if ((factory = this.m_classNameToNamedElementFactory.get(className = this.readString())) == null) {
                    factory = new NamedElementFactory(className, loader);
                    this.m_classNameToNamedElementFactory.put(className, factory);
                }
                if (parent == null) {
                    element = factory.create();
                    assert (element != null && element instanceof SoftwareSystem) : "Unexpected class in method 'readSnapshot': " + String.valueOf(element);
                    softwareSystem = (SoftwareSystem)element;
                    creator.initializeFromSnapshot(softwareSystem, new TFile((File)this.m_dataFile));
                    setAsModelServiceProvider = targetSoftwareSystem != null ? targetSoftwareSystem : softwareSystem;
                } else {
                    element = factory.create(parent);
                    parent.addChild(element);
                    assert (setAsModelServiceProvider != null) : "'setAsModelServiceProvider' of method 'readSnapshot' must not be null";
                    element.setModelServiceProvider(setAsModelServiceProvider);
                }
                this.m_elementList.add(element);
                if (element instanceof ISnapshotDependency.IDependencyEndpoint) {
                    ISnapshotDependency.IDependencyEndpoint pe = (ISnapshotDependency.IDependencyEndpoint)((Object)element);
                    pe.readDependencyList(this);
                }
                if ((parentId = this.readInt()) == -1) break;
                parent = this.m_elementList.get(parentId);
            }
            this.m_treeHasBeenRead = true;
            assert (softwareSystem != null) : "'softwareSystem' of method 'readSnapshot' must not be null";
            for (NamedElement nextNamedElement : this.m_elementList) {
                nextNamedElement.retrieve(this);
            }
            creator.finishInitializationFromSnapshot(softwareSystem);
            SoftwareSystem softwareSystem2 = softwareSystem;
            return softwareSystem2;
        }
        catch (Throwable e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, e);
        }
        finally {
            this.m_elementList = null;
            this.m_dataBuffer = null;
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void mapRootDirectories(SoftwareSystem loadedFromSnapshot, IBaseDirectory baseDirectory, OperationResult result) {
        if (!SnapshotReader.$assertionsDisabled && loadedFromSnapshot == null) {
            throw new AssertionError((Object)"Parameter 'loadedFromSnapshot' of method 'mapRootDirectories' must not be null");
        }
        if (!SnapshotReader.$assertionsDisabled && baseDirectory == null) {
            throw new AssertionError((Object)"Parameter 'baseDirectory' of method 'mapRootDirectories' must not be null");
        }
        if (!SnapshotReader.$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Parameter 'result' of method 'mapRootDirectories' must not be null");
        }
        rootMapping = new Properties();
        mappingFile = new TFile((File)this.m_dataFile, "RootMapping.properties");
        if (mappingFile.exists()) {
            try {
                var6_6 = null;
                var7_9 = null;
                try {
                    in = new TFileReader((File)mappingFile, this.getCharacterSet());
                    try {
                        rootMapping.load((Reader)in);
                        var10_12 = loadedFromSnapshot.getComponentContainer().iterator();
                        while (true) {
                            nextComponentContainer = var10_12.next();
                            for (ISnapshotRootDirectoryPath nextRoot : nextComponentContainer.getRootDirectoryPaths()) {
                                realPath = rootMapping.getProperty(nextRoot.getName());
                                if (realPath == null) {
                                    result.addError((OperationResult.IMessageCause)SnapshotProcessor.SnapshotMessageCause.INCONSISTENT_ROOTDIRECTORY_MAPPING, "No mapping defined for root '" + nextRoot.getName() + "'.", new Object[0]);
                                    return;
                                }
                                if (!(SnapshotReader.$assertionsDisabled || nextRoot != null && nextRoot instanceof RootDirectoryPath)) {
                                    throw new AssertionError((Object)("Unexpected class in method 'mapRootDirectories': " + String.valueOf(nextRoot)));
                                }
                                ((RootDirectoryPath)nextRoot).setOrigin(baseDirectory, realPath);
                            }
                            break;
                        }
                    }
                    finally {
                        if (var10_12.hasNext()) ** continue;
                    }
                }
                catch (Throwable var7_10) {
                    if (var6_6 == null) {
                        var6_6 = var7_10;
                    } else if (var6_6 != var7_10) {
                        var6_6.addSuppressed(var7_10);
                    }
                    throw var6_6;
                }
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex, "Failed to process mapping for root directories", new Object[0]);
            }
        } else {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "No root mapping file found", new Object[0]);
        }
    }

    public List<String> getLanguages() {
        return this.m_languages;
    }

    @Override
    public String readString() throws IOException {
        this.ensureAvailable(1);
        byte c = this.m_dataBuffer.get();
        if (c == 110) {
            return null;
        }
        if (c == 101) {
            return "";
        }
        if (c == 115) {
            this.ensureAvailable(4);
            int index = this.readInt();
            return this.m_stringList.get(index);
        }
        assert (c == 83);
        this.ensureAvailable(2);
        short len = this.m_dataBuffer.getShort();
        byte[] bytes = new byte[len];
        this.ensureAvailable(len);
        this.m_dataBuffer.get(bytes);
        String result = new String(bytes, this.getCharacterSet());
        this.m_stringList.add(result);
        return result;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureAvailable(1);
        return this.m_dataBuffer.get();
    }

    @Override
    public short readShort() throws IOException {
        this.ensureAvailable(2);
        return this.m_dataBuffer.getShort();
    }

    @Override
    public int readInt() throws IOException {
        this.ensureAvailable(4);
        return this.m_dataBuffer.getInt();
    }

    @Override
    public float readFloat() throws IOException {
        this.ensureAvailable(4);
        return this.m_dataBuffer.getFloat();
    }

    @Override
    public long readLong() throws IOException {
        this.ensureAvailable(8);
        return this.m_dataBuffer.getLong();
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.ensureAvailable(1);
        return this.m_dataBuffer.get() != 0;
    }

    @Override
    public <T extends ISnapshotReader.IRetrievable> T read(Class<T> expectedClass, SnapshotArgument ... arguments) throws IOException, ClassNotFoundException {
        assert (expectedClass != null) : "Parameter 'expectedClass' of method 'read' must not be null";
        if (this.m_treeHasBeenRead) {
            if (ISnapshotDependency.class.isAssignableFrom(expectedClass)) {
                assert (arguments == null || arguments.length == 0) : "Arguments not supported for named element";
                int id = this.readInt();
                if (id == 0) {
                    return null;
                }
                ISnapshotDependency.IDependencyEndpoint pe = (ISnapshotDependency.IDependencyEndpoint)((Object)this.m_elementList.get(id - 1));
                assert (pe != null) : "'pe' of method 'read' must not be null";
                int index = this.readInt();
                ISnapshotDependency dep = pe.getOutgoingDependencyAt(index);
                assert (expectedClass.isAssignableFrom(dep.getClass())) : "Unexpected class: " + dep.getClass().getName();
                return (T)dep;
            }
            if (NamedElement.class.isAssignableFrom(expectedClass) || ISnapshotDependency.IDependencyEndpoint.class.isAssignableFrom(expectedClass)) {
                assert (arguments == null || arguments.length == 0) : "Arguments not supported for named element";
                int id = this.readInt();
                if (id == 0) {
                    return null;
                }
                NamedElement namedElement = this.m_elementList.get(id - 1);
                assert (namedElement != null) : "'namedElement' of method 'read' must not be null";
                assert (expectedClass.isAssignableFrom(namedElement.getClass())) : "Unexpected class: " + namedElement.getClass().getName();
                return (T)namedElement;
            }
        }
        assert (arguments != null) : "Arguments needed for retrieval";
        String className = this.readString();
        if (className == null) {
            return null;
        }
        RetrievableFactory factory = this.m_classNameToRetrievableFactory.get(className);
        if (factory == null) {
            factory = new RetrievableFactory(className, this.m_classLoader, SnapshotArgument.getClazzes(arguments));
            this.m_classNameToRetrievableFactory.put(className, factory);
        }
        ISnapshotReader.IRetrievable retrievable = factory.create(SnapshotArgument.getObjects(arguments));
        assert (expectedClass.isAssignableFrom(retrievable.getClass())) : "Unexpected class: " + retrievable.getClass().getName();
        if (this.m_treeHasBeenRead) {
            retrievable.retrieve(this);
        }
        return (T)retrievable;
    }

    @Override
    public Any readAny() throws IOException {
        byte type = this.readByte();
        StringAny result = null;
        switch (type) {
            case 48: {
                break;
            }
            case 83: {
                result = new StringAny(this.readString());
                break;
            }
            case 76: {
                result = new LongAny(this.readLong());
                break;
            }
            case 91: {
                ArrayList<Any> list = new ArrayList<Any>();
                int size = this.readInt();
                int i = 0;
                while (i < size) {
                    list.add(this.readAny());
                    ++i;
                }
                result = new ListAny(list);
            }
        }
        return result;
    }
}

