/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.script;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinitionFactory;
import com.hello2morrow.sonargraph.core.model.script.ParameterType;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.script.ScriptMessageCause;
import com.hello2morrow.sonargraph.core.model.script.ScriptResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.script.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.script.XsdLanguages;
import com.hello2morrow.sonargraph.core.persistence.script.XsdParameterDefinition;
import com.hello2morrow.sonargraph.core.persistence.script.XsdParameterDefinitions;
import com.hello2morrow.sonargraph.core.persistence.script.XsdParameterValue;
import com.hello2morrow.sonargraph.core.persistence.script.XsdRunConfiguration;
import com.hello2morrow.sonargraph.core.persistence.script.XsdRunConfigurations;
import com.hello2morrow.sonargraph.core.persistence.script.XsdScript;
import com.hello2morrow.sonargraph.core.persistence.script.runconfiguration.RunConfigurationPersistence;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptPersistence.class);
    private static final String XSD_NAMESPACE = "com.hello2morrow.sonargraph.core.persistence.script";
    private static final String ROOT_ELEMENT = "script";
    private static final String SCHEMA_URL = "com.hello2morrow.sonargraph.core.persistence.script".replace('.', '/') + "/script";
    private static final Version MIGRATION_BEFORE = Version.create((int)8, (int)5, (int)0, (int)333);
    private final Version m_version;
    private final Set<Language> m_availableLanguages;
    private final GroovyScripts m_groovyScripts;
    private final boolean m_isReadOnly;

    public ScriptPersistence(GroovyScripts groovyScripts, Version version, Set<Language> availableLanguages, boolean isReadOnly) {
        assert (groovyScripts != null) : "Parameter 'groovyScripts' of method 'ScriptPersistence' must not be null";
        assert (version != null) : "Parameter 'version' of method 'ScriptPersistence' must not be null";
        assert (availableLanguages != null && !availableLanguages.isEmpty()) : "Parameter 'availableLanguages' of method 'ScriptPersistence' must not be empty";
        this.m_version = version;
        this.m_availableLanguages = availableLanguages;
        this.m_groovyScripts = groovyScripts;
        this.m_isReadOnly = isReadOnly;
    }

    public static boolean isValidRootElement(String rootElement) {
        assert (rootElement != null && rootElement.length() > 0) : "Parameter 'rootElement' of method 'isValidRootElement' must not be empty";
        return ROOT_ELEMENT.equals(rootElement);
    }

    public Pair<ScriptContent, List<String>> loadScriptFromFile(TFile scriptFile, OperationResult result) {
        assert (scriptFile != null) : "Parameter 'scriptFile' of method 'loadScriptFromFile' must not be null";
        assert (scriptFile.exists()) : "Parameter 'scriptFile' of method 'loadScriptFromFile' must be an existent file";
        XsdScript scriptXml = null;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)scriptFile);){
                OperationResult loadScriptResult = new OperationResult("Load script from file '" + FileUtility.calculateRelativePath((TFile)scriptFile, (TFile)this.m_groovyScripts.getDirectoryFile()) + "'");
                scriptXml = this.getScriptXml((InputStream)inputStream, loadScriptResult);
                if (loadScriptResult.isFailure()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed to process Script from file '" + FileUtility.calculateRelativePath((TFile)scriptFile, (TFile)this.m_groovyScripts.getDirectoryFile()) + "'", new Object[0]);
                }
                result.addMessagesFrom(loadScriptResult);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Failed to load script from file [" + scriptFile.getAbsolutePath() + "]: " + e.getMessage(), new Object[0]);
        }
        catch (IOException exc) {
            LOGGER.warn("Unable to close resource for '" + String.valueOf(scriptFile) + "'", (Throwable)exc);
        }
        if (!result.isSuccess()) {
            return null;
        }
        assert (scriptXml != null);
        Version version = Version.create((String)scriptXml.getVersion());
        if (version != null && version.isBefore(MIGRATION_BEFORE)) {
            LOGGER.info("Migrate script file {} with version {}", (Object)scriptFile.getAbsolutePath(), (Object)version.toString());
            Integer timeout = scriptXml.getTimeout();
            if (timeout == null || timeout < 1) {
                timeout = 10;
            }
            Pair<ScriptContent, List<String>> scriptContentAndLanguageIssueInfo = this.migrateXmlToPojo(scriptXml, scriptFile, timeout, result);
            assert (scriptContentAndLanguageIssueInfo != null) : "'scriptContentAndLanguageIssueInfo' of method 'loadScriptFromFile' must not be null";
            ScriptContent scriptContent = (ScriptContent)scriptContentAndLanguageIssueInfo.getFirst();
            assert (scriptContent != null) : "'scriptContent' of method 'loadScriptFromFile' must not be null";
            if (!this.m_isReadOnly) {
                List<FileBasedRunConfiguration> fileBasedRunConfigurations = scriptContent.getChildren(FileBasedRunConfiguration.class);
                if (!fileBasedRunConfigurations.isEmpty()) {
                    RunConfigurationPersistence runConfigurationPersistence = new RunConfigurationPersistence(this.m_groovyScripts, this.m_version);
                    for (FileBasedRunConfiguration nextFileBasedRunConfiguration : fileBasedRunConfigurations) {
                        OperationResult nextMigrationSaveResult = runConfigurationPersistence.save(nextFileBasedRunConfiguration, nextFileBasedRunConfiguration.getFile());
                        result.addMessagesFrom(nextMigrationSaveResult);
                        if (!nextMigrationSaveResult.isSuccess()) continue;
                        nextFileBasedRunConfiguration.resetTimestamp();
                    }
                }
                this.storeScriptToFile(scriptFile, scriptContent, result);
            }
            return scriptContentAndLanguageIssueInfo;
        }
        return this.convertXmlToPojo(scriptXml);
    }

    public Pair<ScriptContent, List<String>> loadScriptFromStream(InputStream inputStream, OperationResult result) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadScriptFromStream' must not be null";
        XsdScript scriptXml = this.getScriptXml(inputStream, result);
        if (!result.isSuccess()) {
            return null;
        }
        return this.convertXmlToPojo(scriptXml);
    }

    private JaxbAdapter<JAXBElement<XsdScript>> createJaxbAadpter() {
        XmlPersistenceContext persistenceContext = new XmlPersistenceContext(XSD_NAMESPACE, ScriptResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        return JaxbAccess.createJaxbAdapter(ObjectFactory.class.getClassLoader(), persistenceContext);
    }

    private XsdScript getScriptXml(InputStream inputStream, OperationResult result) {
        ValidationEventHandlerImpl eventHandler;
        assert (inputStream != null) : "Parameter 'inputStream' of method 'getScriptXml' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getScriptXml' must not be null";
        JaxbAdapter<JAXBElement<XsdScript>> jaxbAdapter = this.createJaxbAadpter();
        JAXBElement script = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)(eventHandler = new ValidationEventHandlerImpl(result)));
        if (script == null) {
            result.addError((OperationResult.IMessageCause)ScriptMessageCause.ERROR_IN_SCRIPT_FORMAT);
            return null;
        }
        return (XsdScript)script.getValue();
    }

    private Pair<ScriptContent, List<String>> migrateXmlToPojo(XsdScript scriptXml, TFile scriptFile, Integer timeout, OperationResult result) {
        assert (scriptXml != null) : "Parameter 'scriptXml' of method 'migrateXmlToPojo' must not be null";
        assert (scriptFile != null) : "Parameter 'scriptFile' of method 'migrateXmlToPojo' must not be null";
        assert (timeout != null) : "Parameter 'timeout' of method 'migrateXmlToPojo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'migrateXmlToPojo' must not be null";
        Pair<ScriptContent, List<String>> scriptContentAndLanguageIssueInfo = this.convertXmlToPojo(scriptXml);
        XsdRunConfigurations runConfigurations = scriptXml.getRunConfigurations();
        if (runConfigurations == null) {
            return scriptContentAndLanguageIssueInfo;
        }
        ScriptContent scriptContent = (ScriptContent)scriptContentAndLanguageIssueInfo.getFirst();
        for (XsdRunConfiguration runConfiguration : runConfigurations.getRunConfiguration()) {
            TFile targetFile;
            RunConfigurationParameters data = new RunConfigurationParameters();
            data.setParameterValue("timeout", timeout);
            for (XsdParameterValue parameterValue : runConfiguration.getParameterValue()) {
                String parameterValueName = parameterValue.getName();
                String parameterValueValue = parameterValue.getValue();
                ParameterDefinition<?> definition = scriptContent.getParameterDefinition(parameterValueName);
                if (definition == null) continue;
                data.setParameterValue(definition.getName(), definition.parse(parameterValueValue));
            }
            String output = runConfiguration.getOutputFile();
            if (output != null && !output.isEmpty()) {
                assert (scriptContent.getParameterDefinition("output") != null) : "output not found";
                data.setParameterValue("output", output);
            }
            if (!(targetFile = new TFile((File)scriptFile.getParentFile(), FileBasedRunConfiguration.getFileName(FileUtility.getFileNameWithoutExtension((TFile)scriptFile), runConfiguration.getName()))).exists()) {
                FileBasedRunConfiguration rc = new FileBasedRunConfiguration(scriptContent, targetFile, this.m_groovyScripts, data, scriptContent, this.m_groovyScripts.getParent(Files.class, new Class[0]));
                scriptContent.addChild(rc);
                continue;
            }
            LOGGER.warn("Target file already exists - not migrating: " + targetFile.getAbsolutePath());
        }
        return scriptContentAndLanguageIssueInfo;
    }

    private Pair<ScriptContent, List<String>> convertXmlToPojo(XsdScript scriptXml) {
        assert (scriptXml != null) : "Parameter 'scriptXml' of method 'convertXmlToPojo' must not be null";
        ScriptContent.Builder scriptBuilder = new ScriptContent.Builder().description(scriptXml.getDescription());
        scriptBuilder.source(scriptXml.getSource());
        XsdParameterDefinitions parameters = scriptXml.getParameterDefinitions();
        ArrayList<ParameterDefinition.Builder> parameterList = new ArrayList<ParameterDefinition.Builder>();
        for (XsdParameterDefinition nextParameterXsd : parameters.getParameterDefinition()) {
            String nextParameterTypeName = StringUtility.firstCharacterCase((String)nextParameterXsd.getType().toLowerCase(), (boolean)false);
            try {
                ParameterType nextParameterType = ParameterType.fromStandardName(nextParameterTypeName);
                ParameterDefinition.Builder<?> nextParameterDefinitionBuilder = ParameterDefinitionFactory.create(nextParameterType, nextParameterXsd.name);
                String nextDefaultValue = nextParameterXsd.getDefaultValue();
                if (nextDefaultValue == null || !nextParameterType.isConversionIntoTargetTypePossible(nextDefaultValue)) {
                    nextDefaultValue = nextParameterType.getDefaultValue().toString();
                }
                nextParameterDefinitionBuilder.description(nextParameterXsd.description).parseDefaultValue(nextDefaultValue);
                if (nextParameterXsd.candidates != null) {
                    nextParameterDefinitionBuilder.candidates(nextParameterXsd.candidates);
                }
                parameterList.add(nextParameterDefinitionBuilder);
            }
            catch (IllegalArgumentException nextParameterType) {
                // empty catch block
            }
        }
        ArrayList<CallSite> languageIssues = new ArrayList<CallSite>(3);
        XsdLanguages languages = scriptXml.getLanguages();
        HashSet<Language> languageSet = new HashSet<Language>();
        for (String languageStandardName : languages.getLanguage()) {
            boolean exists = false;
            for (Language language : this.m_availableLanguages) {
                if (!language.getStandardName().equals(languageStandardName)) continue;
                languageSet.add(language);
                exists = true;
                break;
            }
            if (exists) continue;
            languageIssues.add((CallSite)((Object)("Script API language '" + languageStandardName + "' is not available.")));
        }
        scriptBuilder.languages(languageSet);
        scriptBuilder.parameterDefinitions(parameterList);
        return new Pair((Object)scriptBuilder.build(), languageIssues);
    }

    private void save(ScriptContent content, OutputStream stream, OperationResult result) {
        assert (content != null) : "Parameter 'content' of method 'save' must not be null";
        assert (stream != null) : "Parameter 'stream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        JAXBElement<XsdScript> xsdElement = this.convertPojoToXml(content);
        JaxbAdapter<JAXBElement<XsdScript>> jaxbAdapter = this.createJaxbAadpter();
        try {
            jaxbAdapter.save(xsdElement, stream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    public void storeScriptToFile(TFile targetFile, ScriptContent scriptBeforeWrite, OperationResult result) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'storeScriptToFile' must not be null";
        assert (scriptBeforeWrite != null) : "Parameter 'scriptBeforeWrite' of method 'storeScriptToFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'storeScriptToFile' must not be null";
        TFile parentDirectory = targetFile.getParentFile();
        boolean parentDirectoryExists = true;
        if (!parentDirectory.exists() && !(parentDirectoryExists = parentDirectory.mkdirs())) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, "Unknown error occured creating directory: " + parentDirectory.getAbsolutePath(), new Object[0]);
        }
        if (parentDirectoryExists) {
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (TFileOutputStream out = new TFileOutputStream((File)targetFile);){
                    this.save(scriptBeforeWrite, (OutputStream)out, result);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof FileSystemException) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, ex.getCause());
                } else {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, (Throwable)ex);
                }
            }
            catch (IOException ex1) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex1);
            }
        }
    }

    public void storeScriptToStream(OutputStream targetStream, GroovyScript script, OperationResult result) {
        this.save(script.getScriptContent(), targetStream, result);
    }

    private JAXBElement<XsdScript> convertPojoToXml(ScriptContent scriptContent) {
        assert (scriptContent != null) : "Parameter 'scriptContent' of method 'convertPojoToXml' must not be null";
        ObjectFactory objectFactory = new ObjectFactory();
        XsdScript xsdScript = objectFactory.createXsdScript();
        JAXBElement<XsdScript> xsdElement = objectFactory.createScript(xsdScript);
        xsdScript.setVersion(this.m_version.toString());
        xsdScript.setDescription(scriptContent.getDescription());
        xsdScript.setSource(scriptContent.getSource());
        XsdParameterDefinitions parameters = objectFactory.createXsdParameterDefinitions();
        xsdScript.setParameterDefinitions(parameters);
        for (ParameterDefinition<?> parameter : scriptContent.getParameterDefinitions()) {
            XsdParameterDefinition p = objectFactory.createXsdParameterDefinition();
            p.setName(parameter.getName());
            p.setDescription(parameter.getDescription());
            p.setDefaultValue(parameter.getDefaultValueAsString());
            p.setType(parameter.getType().getStandardName());
            p.setCandidates(parameter.getPossibleValuesAsString());
            parameters.getParameterDefinition().add(p);
        }
        XsdLanguages languages = objectFactory.createXsdLanguages();
        xsdScript.setLanguages(languages);
        for (Language language : scriptContent.getLanguages()) {
            languages.getLanguage().add(language.getStandardName());
        }
        return xsdElement;
    }
}

