/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.report;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.foundation.utilities.XmlUtility;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlIdGenerator;
import com.hello2morrow.sonargraph.integration.access.persistence.report.ObjectFactory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCheck;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCurrentSystemConditions;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementKind;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExcludeFilter;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueDiffCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricDiffCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdNamedElement;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdOperator;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdQualityGate;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdQualityGateConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdQualityGateStatus;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSoftwareSystemReport;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdThresholdIssueCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdThresholdIssueDiffCondition;
import java.util.List;
import java.util.Map;

final class QualityGateXmlReportWriter {
    private final ObjectFactory m_objectFactory;
    private final XmlIdGenerator m_idGenerator;
    private final Map<Object, XsdNamedElement> m_namedElementToXsdNamedElement;
    private final Map<String, XsdElementKind> m_elementStandardNameToXsdElementKind;
    private int m_createdElements;

    public QualityGateXmlReportWriter(ObjectFactory objectFactory, XmlIdGenerator idGenerator, Map<Object, XsdNamedElement> namedElementToXsdNamedElement, Map<String, XsdElementKind> elementStandardNameToXsdElementKind) {
        assert (objectFactory != null) : "Parameter 'objectFactory' of method 'QualityGateXmlReportWriterUtility' must not be null";
        assert (idGenerator != null) : "Parameter 'idGenerator' of method 'QualityGateXmlReportWriter' must not be null";
        assert (namedElementToXsdNamedElement != null) : "Parameter 'namedElementToXsdNamedElement' of method 'QualityGateXmlReportWriter' must not be null";
        assert (elementStandardNameToXsdElementKind != null) : "Parameter 'elementStandardNameToXsdElementKind' of method 'QualityGateXmlReportWriter' must not be null";
        this.m_objectFactory = objectFactory;
        this.m_idGenerator = idGenerator;
        this.m_namedElementToXsdNamedElement = namedElementToXsdNamedElement;
        this.m_elementStandardNameToXsdElementKind = elementStandardNameToXsdElementKind;
    }

    int writeElementsToXml(IReport report, XsdSoftwareSystemReport xsdReport) {
        this.m_createdElements = 0;
        assert (report != null) : "Parameter 'report' of method 'writeElementsToXml' must not be null";
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'writeElementsToXml' must not be null";
        List<String> configurationEntries = report.getQualityGateCheckConfigurationEntries();
        if (configurationEntries != null) {
            XsdQualityGateConfiguration xsdConfiguration = this.m_objectFactory.createXsdQualityGateConfiguration();
            ++this.m_createdElements;
            for (String next : configurationEntries) {
                xsdConfiguration.getEntry().add(next);
            }
            xsdReport.setQualityGateConfiguration(xsdConfiguration);
        }
        for (Map.Entry<QualityGate, QualityGateResult> nextEntry : report.getQualityGateToResultMap().entrySet()) {
            XsdQualityGate xsdQualityGate = this.m_objectFactory.createXsdQualityGate();
            ++this.m_createdElements;
            QualityGate qualityGate = nextEntry.getKey();
            this.m_namedElementToXsdNamedElement.put(qualityGate, (XsdNamedElement)xsdQualityGate);
            xsdQualityGate.setId(this.m_idGenerator.getNextId());
            xsdQualityGate.setName(qualityGate.getName());
            xsdQualityGate.setPresentationName(qualityGate.getPresentationName(true));
            xsdQualityGate.setFqName(qualityGate.getFullyQualifiedName());
            xsdQualityGate.setKind((Object)this.getOrCreateElementKind(qualityGate));
            xsdQualityGate.setLastModified(XmlUtility.createDateTimeObject((long)qualityGate.getTimestamp()));
            xsdQualityGate.setPath(qualityGate.getIdentifyingPath());
            xsdQualityGate.setType(qualityGate.getFileType().getStandardName());
            xsdQualityGate.setLastModified(XmlUtility.createDateTimeObject((long)qualityGate.getTimestamp()));
            xsdQualityGate.setDescription(qualityGate.getDescription());
            xsdReport.getSystemFileElement().add(xsdQualityGate);
            this.m_createdElements += this.writeCurrentSystemConditions(qualityGate, xsdQualityGate);
            this.m_createdElements += this.writeBaselineSystemConditions(qualityGate, xsdQualityGate);
        }
        return this.m_createdElements;
    }

    private int writeCurrentSystemConditions(QualityGate qualityGate, XsdQualityGate xsdQualityGate) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'writeCurrentSystemConditions' must not be null";
        assert (xsdQualityGate != null) : "Parameter 'xsdQualityGate' of method 'writeCurrentSystemConditions' must not be null";
        int createdElements = 0;
        XsdCurrentSystemConditions xsdCurrentSystemConditions = this.m_objectFactory.createXsdCurrentSystemConditions();
        ++createdElements;
        xsdQualityGate.setCurrentSystemConditions(xsdCurrentSystemConditions);
        CurrentSystemConditions currentSystemConditions = qualityGate.getUniqueExistingChild(CurrentSystemConditions.class);
        for (AbstractCurrentIssueQualityGateCondition nextCondition : currentSystemConditions.getChildren(AbstractCurrentIssueQualityGateCondition.class)) {
            XsdIssueCondition xsdCondition;
            if (nextCondition instanceof ThresholdIssueQualityGateCondition) {
                ThresholdIssueQualityGateCondition condition = (ThresholdIssueQualityGateCondition)nextCondition;
                XsdThresholdIssueCondition xsdThresholdCondition = this.m_objectFactory.createXsdThresholdIssueCondition();
                xsdThresholdCondition.setMetricId(condition.getMetricId());
                xsdCondition = xsdThresholdCondition;
            } else if (nextCondition instanceof CurrentIssueQualityGateCondition) {
                xsdCondition = this.m_objectFactory.createXsdIssueCondition();
            } else {
                xsdCondition = null;
                assert (false) : "Unsupported condition class: " + nextCondition.getClass().getCanonicalName();
            }
            this.addNamedElementAttributes(nextCondition, (XsdNamedElement)xsdCondition);
            String info = nextCondition.getInformation();
            xsdCondition.setInfo(info != null ? info : "");
            this.m_namedElementToXsdNamedElement.put(nextCondition, (XsdNamedElement)xsdCondition);
            ++createdElements;
            xsdCurrentSystemConditions.getIssueCondition().add(xsdCondition);
            xsdCondition.setIssueType(nextCondition.getIssueType());
            xsdCondition.setSeverity(AbstractCurrentIssueQualityGateCondition.getSeverityAsString(nextCondition.getSeverityList()));
            xsdCondition.setResolution(AbstractCurrentIssueQualityGateCondition.getResolutionsAsString(nextCondition.getResolutionList()));
            xsdCondition.setOperator(this.convertOperator(nextCondition.getOperator()));
            xsdCondition.setLimit(nextCondition.getLimit());
            QualityGateResultStatus status = nextCondition.getStatus();
            xsdCondition.setStatus(this.convertConditionStatus(status));
        }
        for (QualityGateExcludeFilter nextExclude : currentSystemConditions.getChildren(QualityGateExcludeFilter.class)) {
            XsdExcludeFilter xsdExcludeFilter = this.convertExcludeFilterToXml(this.m_objectFactory, nextExclude);
            xsdCurrentSystemConditions.getExclude().add(xsdExcludeFilter);
            this.m_namedElementToXsdNamedElement.put(nextExclude, (XsdNamedElement)xsdExcludeFilter);
            ++createdElements;
        }
        return createdElements;
    }

    private XsdExcludeFilter convertExcludeFilterToXml(ObjectFactory objectFactory, QualityGateExcludeFilter nextExclude) {
        assert (objectFactory != null) : "Parameter 'objectFactory' of method 'convertExcludeFilterToXml' must not be null";
        assert (nextExclude != null) : "Parameter 'nextExclude' of method 'convertExcludeFilterToXml' must not be null";
        XsdExcludeFilter xsdExcludeFilter = objectFactory.createXsdExcludeFilter();
        xsdExcludeFilter.setIssueType(nextExclude.getIssueType());
        xsdExcludeFilter.setSeverity(QualityGateExcludeFilter.getSeverityAsString(nextExclude.getSeverityList()));
        xsdExcludeFilter.setResolution(QualityGateExcludeFilter.getResolutionsAsString(nextExclude.getResolutionList()));
        if (nextExclude.getMetricId() != null && !nextExclude.getMetricId().equalsIgnoreCase("Any")) {
            xsdExcludeFilter.setMetricId(nextExclude.getMetricId());
        }
        this.addNamedElementAttributes(nextExclude, (XsdNamedElement)xsdExcludeFilter);
        String info = nextExclude.getInformation();
        xsdExcludeFilter.setInfo(info != null ? info : "");
        return xsdExcludeFilter;
    }

    private int writeBaselineSystemConditions(QualityGate qualityGate, XsdQualityGate xsdQualityGate) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'writeBaselineSystemConditions' must not be null";
        assert (xsdQualityGate != null) : "Parameter 'xsdQualityGate' of method 'writeBaselineSystemConditions' must not be null";
        int createdElements = 0;
        XsdDiffAgainstBaselineConditions xsdBaselineConditions = this.m_objectFactory.createXsdDiffAgainstBaselineConditions();
        ++createdElements;
        xsdQualityGate.setBaselineConditions(xsdBaselineConditions);
        DiffAgainstBaselineConditions diffAgainstBaselineConditions = qualityGate.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
        for (AbstractQualityGateElement nextElement : diffAgainstBaselineConditions.getChildren(AbstractQualityGateElement.class)) {
            if (nextElement instanceof AbstractIssueDiffAgainstBaselineCondition) {
                XsdIssueDiffCondition xsdIssueDiffCondition;
                AbstractIssueDiffAgainstBaselineCondition nextCondition = (AbstractIssueDiffAgainstBaselineCondition)nextElement;
                if (nextElement instanceof IssueDiffAgainstBaselineCondition) {
                    xsdIssueDiffCondition = this.m_objectFactory.createXsdIssueDiffCondition();
                    ++createdElements;
                    this.setDiffIssueConditionProperties(nextCondition, xsdIssueDiffCondition);
                } else if (nextElement instanceof ThresholdIssueDiffAgainstBaselineCondition) {
                    ThresholdIssueDiffAgainstBaselineCondition thresholdCondition = (ThresholdIssueDiffAgainstBaselineCondition)nextElement;
                    XsdThresholdIssueDiffCondition xsdThresholdCondition = this.m_objectFactory.createXsdThresholdIssueDiffCondition();
                    ++createdElements;
                    this.setDiffIssueConditionProperties(nextCondition, (XsdIssueDiffCondition)xsdThresholdCondition);
                    xsdThresholdCondition.setMetricId(thresholdCondition.getMetricId());
                    if (thresholdCondition.getDiffThreshold() != null) {
                        xsdThresholdCondition.setDiffThreshold(thresholdCondition.getDiffThreshold());
                    }
                    if (thresholdCondition.getDiffThresholdRelative() != null) {
                        xsdThresholdCondition.setDiffThresholdRelative(thresholdCondition.getDiffThresholdRelative());
                    }
                    xsdThresholdCondition.setOperator(this.convertOperator(thresholdCondition.getOperator()));
                    xsdIssueDiffCondition = xsdThresholdCondition;
                } else {
                    assert (false) : "Unsupported class: " + nextElement.getClass().getCanonicalName();
                    xsdIssueDiffCondition = null;
                }
                this.addNamedElementAttributes(nextElement, (XsdNamedElement)xsdIssueDiffCondition);
                this.m_namedElementToXsdNamedElement.put(nextCondition, (XsdNamedElement)xsdIssueDiffCondition);
                xsdBaselineConditions.getIssueDiffCondition().add(xsdIssueDiffCondition);
                continue;
            }
            if (!(nextElement instanceof MetricValueDiffQualityGateCondition)) continue;
            MetricValueDiffQualityGateCondition metricDiffCondition = (MetricValueDiffQualityGateCondition)nextElement;
            XsdMetricDiffCondition xsdMetricDiffCondition = this.m_objectFactory.createXsdMetricDiffCondition();
            ++createdElements;
            xsdMetricDiffCondition.setMetricId(metricDiffCondition.getMetricId());
            xsdMetricDiffCondition.setOperator(this.convertOperator(metricDiffCondition.getOperator()));
            if (metricDiffCondition.getDiffThreshold() != null) {
                xsdMetricDiffCondition.setDiffThreshold(metricDiffCondition.getDiffThreshold());
            }
            if (metricDiffCondition.getDiffThresholdRelative() != null) {
                xsdMetricDiffCondition.setDiffThresholdRelative(metricDiffCondition.getDiffThresholdRelative());
            }
            this.addNamedElementAttributes(nextElement, (XsdNamedElement)xsdMetricDiffCondition);
            xsdMetricDiffCondition.setInfo(nextElement.getInformation());
            xsdMetricDiffCondition.setStatus(this.convertConditionStatus(nextElement.getStatus()));
            this.m_namedElementToXsdNamedElement.put(metricDiffCondition, (XsdNamedElement)xsdMetricDiffCondition);
            xsdBaselineConditions.getMetricDiffCondition().add(xsdMetricDiffCondition);
        }
        for (QualityGateExcludeFilter nextExclude : diffAgainstBaselineConditions.getChildren(QualityGateExcludeFilter.class)) {
            XsdExcludeFilter xsdExcludeFilter = this.convertExcludeFilterToXml(this.m_objectFactory, nextExclude);
            xsdExcludeFilter.setId(this.m_idGenerator.getNextId());
            this.m_namedElementToXsdNamedElement.put(nextExclude, (XsdNamedElement)xsdExcludeFilter);
            xsdBaselineConditions.getExclude().add(xsdExcludeFilter);
            ++createdElements;
        }
        return createdElements;
    }

    private void addNamedElementAttributes(NamedElement namedElement, XsdNamedElement xsdNamedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'addNamedElementAttributes' must not be null";
        assert (xsdNamedElement != null) : "Parameter 'xsdNamedElement' of method 'addNamedElementAttributes' must not be null";
        xsdNamedElement.setFqName(namedElement.getFullyQualifiedName());
        xsdNamedElement.setId(this.m_idGenerator.getNextId());
        xsdNamedElement.setName(namedElement.getShortName());
        xsdNamedElement.setPresentationName(namedElement.getPresentationName(false));
        XsdElementKind xsdElementKind = this.getOrCreateElementKind(namedElement);
        xsdNamedElement.setKind((Object)xsdElementKind);
    }

    private void setDiffIssueConditionProperties(AbstractIssueDiffAgainstBaselineCondition diffCondition, XsdIssueDiffCondition xsdDiffCondition) {
        assert (diffCondition != null) : "Parameter 'diffCondition' of method 'setDiffIssueConditionProperties' must not be null";
        assert (xsdDiffCondition != null) : "Parameter 'xsdIssueCondition' of method 'setDiffIssueConditionProperties' must not be null";
        xsdDiffCondition.setIssueType(diffCondition.getIssueType());
        xsdDiffCondition.setSeverity(AbstractIssueDiffAgainstBaselineCondition.getSeverityAsString(diffCondition.getSeverityList()));
        xsdDiffCondition.setResolution(AbstractIssueDiffAgainstBaselineCondition.getResolutionsAsString(diffCondition.getResolutionList()));
        QualityGateDiffCheck check = diffCondition.getCheck();
        if (check == null) {
            check = QualityGateDiffCheck.STRICT;
        }
        xsdDiffCondition.setCheck(this.convertCheck(check));
        String info = diffCondition.getInformation();
        xsdDiffCondition.setInfo(info != null ? info : "");
        xsdDiffCondition.setStatus(this.convertConditionStatus(diffCondition.getStatus()));
    }

    private XsdCheck convertCheck(QualityGateDiffCheck check) {
        assert (check != null) : "Parameter 'check' of method 'convertCheck' must not be null";
        switch (check) {
            case RELAXED: {
                return XsdCheck.RELAXED;
            }
            case STRICT: {
                return XsdCheck.STRICT;
            }
        }
        assert (false) : "Unsupported check: " + check.name();
        return null;
    }

    private XsdQualityGateStatus convertConditionStatus(QualityGateResultStatus status) {
        assert (status != null) : "Parameter 'status' of method 'convertStatus' must not be null";
        switch (status) {
            case FAILED: {
                return XsdQualityGateStatus.FAILED;
            }
            case PASSED: {
                return XsdQualityGateStatus.PASSED;
            }
            case NONE: {
                return XsdQualityGateStatus.NONE;
            }
        }
        assert (false) : "Unsupported status: " + status.getStandardName();
        return null;
    }

    private XsdOperator convertOperator(Operator operator) {
        assert (operator != null) : "Parameter 'operator' of method 'convertOperator' must not be null";
        switch (operator) {
            case LESS: {
                return XsdOperator.LESS;
            }
            case LESS_OR_EQUAL: {
                return XsdOperator.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return XsdOperator.EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return XsdOperator.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return XsdOperator.GREATER;
            }
            case N_A: {
                return XsdOperator.N_A;
            }
        }
        assert (false) : "Unsupported operator: " + operator.name();
        return null;
    }

    private XsdElementKind getOrCreateElementKind(NamedElement nextElement) {
        XsdElementKind xsdElementKind;
        if (!this.m_elementStandardNameToXsdElementKind.containsKey(nextElement.getStandardPresentationKind())) {
            xsdElementKind = this.m_objectFactory.createXsdElementKind();
            ++this.m_createdElements;
            xsdElementKind.setId(this.m_idGenerator.getNextId());
            xsdElementKind.setStandardKind(nextElement.getStandardPresentationKind());
            xsdElementKind.setPresentationKind(nextElement.getPresentationKind());
            if (!xsdElementKind.getStandardKind().equals(nextElement.getImageResourceName())) {
                xsdElementKind.setImageResourceName(nextElement.getImageResourceName());
            }
            this.m_elementStandardNameToXsdElementKind.put(nextElement.getStandardPresentationKind(), xsdElementKind);
        } else {
            xsdElementKind = this.m_elementStandardNameToXsdElementKind.get(nextElement.getStandardPresentationKind());
        }
        return xsdElementKind;
    }
}

