/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.qualitygate;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElementContainer;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdCheck;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdCurrentSystemConditions;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdDiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdExcludeFilter;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdIssueCondition;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdIssueDiffCondition;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdMetricDiffCondition;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdOperator;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdQualityGate;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdThresholdIssueCondition;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.XsdThresholdIssueDiffCondition;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QualityGatePersistence {
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.core.persistence.qualitygate";
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/core/persistence/qualitygate/qualityGate";
    private static final Logger LOGGER = LoggerFactory.getLogger(QualityGatePersistence.class);
    private static final String ROOT_ELEMENT = "qualityGate";
    private final XmlPersistenceContext m_persistenceContext;
    private final Version m_version;
    private final QualityGates m_qualityGates;
    private final IModifiablePathListener m_filePathListener;
    private final IQualityGateProvider m_qualityGateProvider;

    public QualityGatePersistence(IQualityGateProvider qualityGateProvider, Version version, QualityGates qualityGates, IModifiablePathListener modifiablePathListener) {
        assert (qualityGateProvider != null) : "Parameter 'qualityGateProvider' of method 'QualityGatePersistence' must not be null";
        assert (version != null) : "Parameter 'version' of method 'VirtualModelPersistence' must not be null";
        assert (qualityGates != null) : "Parameter 'qualityGates' of method 'QualityGatePersistence' must not be null";
        assert (modifiablePathListener != null) : "Parameter 'modifiablePathListener' of method 'QualityGatePersistence' must not be null";
        this.m_qualityGateProvider = qualityGateProvider;
        this.m_version = version;
        this.m_qualityGates = qualityGates;
        this.m_filePathListener = modifiablePathListener;
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
    }

    public OperationResultWithOutcome<QualityGate> load(TFile qualityGateFile, QualityGate qualityGate) {
        assert (qualityGateFile != null) : "Parameter 'qualityGateFile' of method 'load' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load quality gate from '" + qualityGateFile.getName() + "'");
        if (!qualityGateFile.exists() || !qualityGateFile.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Cannot read quality gate file '%s'", qualityGateFile.getNormalizedAbsolutePath()), new Object[0]);
            return result;
        }
        if (qualityGate == null) {
            LOGGER.debug("Read quality gate from file {}", (Object)qualityGateFile);
            qualityGate = new QualityGate(this.m_qualityGates, qualityGateFile, qualityGateFile.lastModified(), "", this.m_filePathListener);
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileInputStream in = new TFileInputStream((File)qualityGateFile);){
                OperationResult loadResult = this.load((InputStream)in, qualityGate);
                result.addMessagesFrom(loadResult);
                if (result.isFailure()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Failed to process quality gate file '%s'", qualityGateFile.getNormalizedAbsolutePath()), new Object[0]);
                } else {
                    result.setOutcome((Object)qualityGate);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, String.format("Cannot read quality gate file '%s'", qualityGateFile.getNormalizedAbsolutePath()), new Object[]{e});
        }
        return result;
    }

    public OperationResult load(InputStream in, QualityGate qualityGate) {
        assert (in != null) : "Parameter 'in' of method 'load' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'load' must not be null";
        OperationResultWithOutcome<XsdQualityGate> result = this.loadFromStream(in);
        if (result.isSuccess()) {
            XsdQualityGate xsdQualityGate = (XsdQualityGate)result.getOutcome();
            try {
                XsdDiffAgainstBaselineConditions xsdDiffAgainstBaselineConditions;
                qualityGate.setDescription(xsdQualityGate.getDescription());
                if (xsdQualityGate.getCurrentSystemConditions() != null) {
                    XsdCurrentSystemConditions xsdCurrentSystemConditions = xsdQualityGate.getCurrentSystemConditions();
                    CurrentSystemConditions currentConditions = new CurrentSystemConditions(qualityGate);
                    this.loadCurrentConditions(xsdCurrentSystemConditions, currentConditions);
                    qualityGate.addChild(currentConditions);
                }
                if ((xsdDiffAgainstBaselineConditions = xsdQualityGate.getDiffAgainstBaselineConditions()) != null) {
                    DiffAgainstBaselineConditions baselineConditions = new DiffAgainstBaselineConditions(qualityGate);
                    qualityGate.addChild(baselineConditions);
                    this.loadDiffAgainstBaselineConditions(xsdDiffAgainstBaselineConditions, baselineConditions);
                }
            }
            catch (Throwable ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed read quality gate from file.", new Object[]{ex});
                return result;
            }
        }
        return result;
    }

    private void loadCurrentConditions(XsdCurrentSystemConditions xsdCurrentSystemConditions, CurrentSystemConditions currentConditions) {
        assert (xsdCurrentSystemConditions != null) : "Parameter 'xsdCurrentSystemConditions' of method 'loadCurrentConditions' must not be null";
        assert (currentConditions != null) : "Parameter 'currentConditions' of method 'loadCurrentConditions' must not be null";
        for (XsdIssueCondition nextXsdCondition : xsdCurrentSystemConditions.getIssueCondition()) {
            if (nextXsdCondition instanceof XsdThresholdIssueCondition) {
                String metricId = ((XsdThresholdIssueCondition)nextXsdCondition).getMetricId();
                ThresholdIssueQualityGateCondition condition = new ThresholdIssueQualityGateCondition(currentConditions, nextXsdCondition.getIssueType(), QualityGatePersistence.convertToList(nextXsdCondition.getSeverity()), QualityGatePersistence.convertToList(nextXsdCondition.getResolution()), metricId, this.convertOperator(nextXsdCondition.getOperator()), nextXsdCondition.getLimit());
                currentConditions.addChild(condition);
                continue;
            }
            CurrentIssueQualityGateCondition condition = new CurrentIssueQualityGateCondition(currentConditions, nextXsdCondition.getIssueType(), QualityGatePersistence.convertToList(nextXsdCondition.getSeverity()), QualityGatePersistence.convertToList(nextXsdCondition.getResolution()), this.convertOperator(nextXsdCondition.getOperator()), nextXsdCondition.getLimit());
            currentConditions.addChild(condition);
        }
        for (XsdExcludeFilter nextExclude : xsdCurrentSystemConditions.getExclude()) {
            currentConditions.addChild(this.loadExcludeFilter(currentConditions, nextExclude));
        }
    }

    public static List<String> convertToList(String valueList) {
        assert (valueList != null && !valueList.isEmpty()) : "Parameter 'valueList' of method 'convertToList' must not be empty";
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = valueList.split(", ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            result.add(next.trim());
            ++n2;
        }
        result.trimToSize();
        return result;
    }

    private QualityGateExcludeFilter loadExcludeFilter(AbstractQualityGateElementContainer parent, XsdExcludeFilter xsdExclude) {
        assert (parent != null) : "Parameter 'parent' of method 'loadExcludeFilter' must not be null";
        assert (xsdExclude != null) : "Parameter 'xsdExclude' of method 'loadExcludeFilter' must not be null";
        if (xsdExclude.getMetricId() == null) {
            return new QualityGateExcludeFilter(parent, xsdExclude.getIssueType(), QualityGatePersistence.convertToList(xsdExclude.getSeverity()), QualityGatePersistence.convertToList(xsdExclude.getResolution()));
        }
        return new QualityGateExcludeFilter(parent, xsdExclude.getIssueType(), xsdExclude.getMetricId(), QualityGatePersistence.convertToList(xsdExclude.getSeverity()), QualityGatePersistence.convertToList(xsdExclude.getResolution()));
    }

    private Operator convertOperator(XsdOperator operator) {
        switch (operator) {
            case LESS: {
                return Operator.LESS;
            }
            case LESS_OR_EQUAL: {
                return Operator.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return Operator.EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Operator.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return Operator.GREATER;
            }
            case N_A: {
                return Operator.N_A;
            }
        }
        assert (false) : "Unsupported operator: " + operator.name();
        return null;
    }

    private XsdOperator convertOperator(Operator operator) {
        assert (operator != null) : "Parameter 'operator' of method 'convertOperator' must not be null";
        switch (operator) {
            case LESS: {
                return XsdOperator.LESS;
            }
            case LESS_OR_EQUAL: {
                return XsdOperator.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return XsdOperator.EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return XsdOperator.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return XsdOperator.GREATER;
            }
            case N_A: {
                return XsdOperator.N_A;
            }
        }
        assert (false) : "Unsupported operator: " + operator.name();
        return null;
    }

    private void loadDiffAgainstBaselineConditions(XsdDiffAgainstBaselineConditions xsdDiffAgainstBaselineConditions, DiffAgainstBaselineConditions baselineConditions) {
        assert (xsdDiffAgainstBaselineConditions != null) : "Parameter 'xsdDiffAgainstBaselineConditions' of method 'loadDiffAgainstBaselineConditions' must not be null";
        assert (baselineConditions != null) : "Parameter 'baselineConditions' of method 'loadDiffAgainstBaselineConditions' must not be null";
        for (XsdIssueDiffCondition next : xsdDiffAgainstBaselineConditions.getIssueDiffCondition()) {
            AbstractIssueDiffAgainstBaselineCondition condition;
            List<String> severities = QualityGatePersistence.convertToList(next.getSeverity());
            List<String> resolutions = QualityGatePersistence.convertToList(next.getResolution());
            if (next instanceof XsdThresholdIssueDiffCondition) {
                XsdThresholdIssueDiffCondition nextThresholdCondition = (XsdThresholdIssueDiffCondition)next;
                condition = new ThresholdIssueDiffAgainstBaselineCondition(baselineConditions, nextThresholdCondition.getIssueType(), severities, resolutions, nextThresholdCondition.getMetricId(), this.convertOperator(nextThresholdCondition.getOperator()), nextThresholdCondition.getDiffThreshold(), nextThresholdCondition.getDiffThresholdRelative(), this.convertCheck(nextThresholdCondition.getCheck()));
                baselineConditions.addChild(condition);
                continue;
            }
            QualityGateDiffCheck check = this.convertCheck(next.getCheck());
            condition = check != null && this.m_qualityGateProvider.isRelaxedSupportedByIssueType(next.getIssueType()) ? new IssueDiffAgainstBaselineCondition(baselineConditions, next.getIssueType(), severities, resolutions, check) : new IssueDiffAgainstBaselineCondition(baselineConditions, next.getIssueType(), severities, resolutions);
            baselineConditions.addChild(condition);
        }
        for (XsdMetricDiffCondition nextXsdMetricDiffCondition : xsdDiffAgainstBaselineConditions.getMetricDiffCondition()) {
            MetricValueDiffQualityGateCondition metricCondition = new MetricValueDiffQualityGateCondition(baselineConditions, nextXsdMetricDiffCondition.getMetricId(), this.convertOperator(nextXsdMetricDiffCondition.getOperator()), nextXsdMetricDiffCondition.getDiffThreshold(), nextXsdMetricDiffCondition.getDiffThresholdRelative());
            baselineConditions.addChild(metricCondition);
        }
        for (XsdExcludeFilter nextXsdExclude : xsdDiffAgainstBaselineConditions.getExclude()) {
            QualityGateExcludeFilter filter = this.loadExcludeFilter(baselineConditions, nextXsdExclude);
            baselineConditions.addChild(filter);
        }
    }

    private QualityGateDiffCheck convertCheck(XsdCheck xsdCheck) {
        if (xsdCheck == null) {
            return null;
        }
        switch (xsdCheck) {
            case RELAXED: {
                return QualityGateDiffCheck.RELAXED;
            }
            case STRICT: {
                return QualityGateDiffCheck.STRICT;
            }
        }
        assert (false) : "Unsupported check: " + xsdCheck.name();
        return null;
    }

    private XsdCheck convertCheck(QualityGateDiffCheck check) {
        assert (check != null) : "Parameter 'check' of method 'convertCheck' must not be null";
        switch (check) {
            case RELAXED: {
                return XsdCheck.RELAXED;
            }
            case STRICT: {
                return XsdCheck.STRICT;
            }
        }
        assert (false) : "Unsupported check: " + check.name();
        return null;
    }

    private OperationResultWithOutcome<XsdQualityGate> loadFromStream(InputStream inputStream) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'internLoadFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading quality gate from stream");
        JaxbAdapter jaxbAdapter = JaxbAccess.createJaxbAdapter(ObjectFactory.class.getClassLoader(), this.m_persistenceContext);
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result);
        JAXBElement element = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isFailure()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Quality gate loaded from stream is corrupt", new Object[0]);
            return result;
        }
        result.setOutcome((Object)((XsdQualityGate)element.getValue()));
        return result;
    }

    public OperationResult save(QualityGate qualityGate, TFile file) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'save' must not be null";
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        OperationResult result = new OperationResult("Save quality gate to file '" + file.getNormalizedAbsolutePath() + "'");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileOutputStream out = new TFileOutputStream((File)file);){
                this.save((OutputStream)out, qualityGate, result);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, String.format("Failed to save quality gate to file '%s'", file.getNormalizedAbsolutePath()), new Object[]{e});
            return result;
        }
    }

    public void save(OutputStream out, QualityGate qualityGate, OperationResult result) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'save' must not be null";
        assert (out != null) : "Parameter 'out' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        JAXBElement<XsdQualityGate> element = this.convertPojoToXml(qualityGate);
        if (element == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Failed to convert quality gate '" + qualityGate.getName() + "' to XML.", new Object[0]);
            return;
        }
        JaxbAdapter jaxbAdapter = JaxbAccess.createJaxbAdapter(ObjectFactory.class.getClassLoader(), this.m_persistenceContext);
        try {
            jaxbAdapter.save(element, out);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    private JAXBElement<XsdQualityGate> convertPojoToXml(QualityGate qualityGate) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'convertPojoToXml' must not be null";
        ObjectFactory objectFactory = new ObjectFactory();
        XsdQualityGate xsdQualityGate = objectFactory.createXsdQualityGate();
        JAXBElement<XsdQualityGate> element = objectFactory.createQualityGate(xsdQualityGate);
        xsdQualityGate.setVersion(this.m_version.toString());
        xsdQualityGate.setDescription(qualityGate.getDescription());
        this.convertCurrentSystemConditionsToXml(qualityGate, objectFactory, xsdQualityGate);
        this.convertBaselineConditionsToXml(qualityGate, objectFactory, xsdQualityGate);
        return element;
    }

    public void convertCurrentSystemConditionsToXml(QualityGate qualityGate, ObjectFactory objectFactory, XsdQualityGate xsdQualityGate) {
        CurrentSystemConditions currentSystemConditions = qualityGate.getUniqueExistingChild(CurrentSystemConditions.class);
        XsdCurrentSystemConditions xsdCurrentSystemConditions = objectFactory.createXsdCurrentSystemConditions();
        xsdQualityGate.setCurrentSystemConditions(xsdCurrentSystemConditions);
        for (AbstractCurrentIssueQualityGateCondition nextCondition : currentSystemConditions.getChildren(AbstractCurrentIssueQualityGateCondition.class)) {
            XsdIssueCondition xsdIssueCondition;
            if (nextCondition instanceof CurrentIssueQualityGateCondition) {
                xsdIssueCondition = objectFactory.createXsdIssueCondition();
                this.setCurrentConditionProperties(nextCondition, xsdIssueCondition);
            } else if (nextCondition instanceof ThresholdIssueQualityGateCondition) {
                xsdIssueCondition = objectFactory.createXsdThresholdIssueCondition();
                this.setCurrentConditionProperties(nextCondition, xsdIssueCondition);
                ((XsdThresholdIssueCondition)xsdIssueCondition).setMetricId(((ThresholdIssueQualityGateCondition)nextCondition).getMetricId());
            } else {
                assert (false) : "Unsupported class " + nextCondition.getClass().getCanonicalName();
                xsdIssueCondition = null;
            }
            xsdCurrentSystemConditions.getIssueCondition().add(xsdIssueCondition);
        }
        for (QualityGateExcludeFilter nextExclude : currentSystemConditions.getChildren(QualityGateExcludeFilter.class)) {
            XsdExcludeFilter xsdExcludeFilter = this.convertExcludeFilterToXml(objectFactory, nextExclude);
            xsdCurrentSystemConditions.getExclude().add(xsdExcludeFilter);
        }
    }

    private XsdExcludeFilter convertExcludeFilterToXml(ObjectFactory objectFactory, QualityGateExcludeFilter nextExclude) {
        assert (objectFactory != null) : "Parameter 'objectFactory' of method 'convertExcludeFilterToXml' must not be null";
        assert (nextExclude != null) : "Parameter 'nextExclude' of method 'convertExcludeFilterToXml' must not be null";
        XsdExcludeFilter xsdExcludeFilter = objectFactory.createXsdExcludeFilter();
        xsdExcludeFilter.setIssueType(nextExclude.getIssueType());
        xsdExcludeFilter.setSeverity(QualityGateExcludeFilter.getSeverityAsString(nextExclude.getSeverityList()));
        xsdExcludeFilter.setResolution(QualityGateExcludeFilter.getResolutionsAsString(nextExclude.getResolutionList()));
        if (nextExclude.getMetricId() != null && !nextExclude.getMetricId().equalsIgnoreCase("Any")) {
            xsdExcludeFilter.setMetricId(nextExclude.getMetricId());
        }
        return xsdExcludeFilter;
    }

    private void setCurrentConditionProperties(AbstractCurrentIssueQualityGateCondition nextCondition, XsdIssueCondition xsdIssueCondition) {
        xsdIssueCondition.setIssueType(nextCondition.getIssueType());
        xsdIssueCondition.setSeverity(AbstractCurrentIssueQualityGateCondition.getSeverityAsString(nextCondition.getSeverityList()));
        xsdIssueCondition.setResolution(AbstractCurrentIssueQualityGateCondition.getResolutionsAsString(nextCondition.getResolutionList()));
        xsdIssueCondition.setOperator(this.convertOperator(nextCondition.getOperator()));
        xsdIssueCondition.setLimit(nextCondition.getLimit());
    }

    private void convertBaselineConditionsToXml(QualityGate qualityGate, ObjectFactory objectFactory, XsdQualityGate xsdQualityGate) {
        DiffAgainstBaselineConditions diffAgainstBaselineConditions = qualityGate.getUniqueExistingChild(DiffAgainstBaselineConditions.class);
        XsdDiffAgainstBaselineConditions xsdBaselineConditions = objectFactory.createXsdDiffAgainstBaselineConditions();
        xsdQualityGate.setDiffAgainstBaselineConditions(xsdBaselineConditions);
        for (AbstractQualityGateElement nextElement : diffAgainstBaselineConditions.getChildren(AbstractQualityGateElement.class)) {
            if (nextElement instanceof AbstractIssueDiffAgainstBaselineCondition) {
                XsdIssueDiffCondition xsdIssueCondition;
                AbstractIssueDiffAgainstBaselineCondition nextCondition = (AbstractIssueDiffAgainstBaselineCondition)nextElement;
                if (nextElement instanceof IssueDiffAgainstBaselineCondition) {
                    xsdIssueCondition = objectFactory.createXsdIssueDiffCondition();
                    this.setDiffIssueConditionProperties(nextCondition, xsdIssueCondition);
                } else if (nextElement instanceof ThresholdIssueDiffAgainstBaselineCondition) {
                    ThresholdIssueDiffAgainstBaselineCondition thresholdCondition = (ThresholdIssueDiffAgainstBaselineCondition)nextElement;
                    XsdThresholdIssueDiffCondition xsdThresholdCondition = objectFactory.createXsdThresholdIssueDiffCondition();
                    this.setDiffIssueConditionProperties(nextCondition, xsdThresholdCondition);
                    xsdThresholdCondition.setMetricId(thresholdCondition.getMetricId());
                    if (thresholdCondition.getDiffThreshold() != null) {
                        xsdThresholdCondition.setDiffThreshold(thresholdCondition.getDiffThreshold());
                    }
                    if (thresholdCondition.getDiffThresholdRelative() != null) {
                        xsdThresholdCondition.setDiffThresholdRelative(thresholdCondition.getDiffThresholdRelative());
                    }
                    xsdThresholdCondition.setOperator(this.convertOperator(thresholdCondition.getOperator()));
                    xsdIssueCondition = xsdThresholdCondition;
                } else {
                    assert (false) : "Unsupported class: " + nextElement.getClass().getCanonicalName();
                    xsdIssueCondition = null;
                }
                xsdBaselineConditions.getIssueDiffCondition().add(xsdIssueCondition);
                continue;
            }
            if (!(nextElement instanceof MetricValueDiffQualityGateCondition)) continue;
            MetricValueDiffQualityGateCondition metricDiffCondition = (MetricValueDiffQualityGateCondition)nextElement;
            XsdMetricDiffCondition xsdMetricDiffCondition = objectFactory.createXsdMetricDiffCondition();
            xsdMetricDiffCondition.setMetricId(metricDiffCondition.getMetricId());
            xsdMetricDiffCondition.setOperator(this.convertOperator(metricDiffCondition.getOperator()));
            if (metricDiffCondition.getDiffThreshold() != null) {
                xsdMetricDiffCondition.setDiffThreshold(metricDiffCondition.getDiffThreshold());
            }
            if (metricDiffCondition.getDiffThresholdRelative() != null) {
                xsdMetricDiffCondition.setDiffThresholdRelative(metricDiffCondition.getDiffThresholdRelative());
            }
            xsdBaselineConditions.getMetricDiffCondition().add(xsdMetricDiffCondition);
        }
        for (QualityGateExcludeFilter nextExclude : diffAgainstBaselineConditions.getChildren(QualityGateExcludeFilter.class)) {
            XsdExcludeFilter xsdExcludeFilter = this.convertExcludeFilterToXml(objectFactory, nextExclude);
            xsdBaselineConditions.getExclude().add(xsdExcludeFilter);
        }
    }

    private void setDiffIssueConditionProperties(AbstractIssueDiffAgainstBaselineCondition diffCondition, XsdIssueDiffCondition xsdDiffCondition) {
        assert (diffCondition != null) : "Parameter 'diffCondition' of method 'setDiffIssueConditionProperties' must not be null";
        assert (xsdDiffCondition != null) : "Parameter 'xsdIssueCondition' of method 'setDiffIssueConditionProperties' must not be null";
        xsdDiffCondition.setIssueType(diffCondition.getIssueType());
        xsdDiffCondition.setSeverity(AbstractIssueDiffAgainstBaselineCondition.getSeverityAsString(diffCondition.getSeverityList()));
        xsdDiffCondition.setResolution(AbstractIssueDiffAgainstBaselineCondition.getResolutionsAsString(diffCondition.getResolutionList()));
        if (diffCondition.getCheck() != null) {
            xsdDiffCondition.setCheck(this.convertCheck(diffCondition.getCheck()));
        }
    }

    public OperationResult loadFromClasspath(String name, QualityGate qualityGate) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'loadFromClasspath' must not be empty";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'loadFromClasspath' must not be null";
        OperationResult result = new OperationResult("Load quality gate from classpath");
        String qualityGateFile = name + CoreFileType.QUALITY_GATE.getDefaultExtension();
        InputStream inputStream = QualityGatePersistence.class.getResourceAsStream(qualityGateFile);
        if (inputStream == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "'" + qualityGateFile + "' not found in classpath.", new Object[0]);
        } else {
            try {
                OperationResult loadResult = this.load(inputStream, qualityGate);
                result.addMessagesFrom(loadResult);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static boolean isValidRootElement(String rootElement) {
        assert (rootElement != null && rootElement.length() > 0) : "Parameter 'rootElement' of method 'isValidRootElement' must not be empty";
        return ROOT_ELEMENT.equals(rootElement);
    }
}

