/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.diff;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.persistence.diff.AbstractHtmlInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class MetricInfo
extends AbstractHtmlInfo {
    private final MetricsDiff m_metricsDiff;

    public MetricInfo(SoftwareSystemDiff softwareSystemDiff) {
        super(softwareSystemDiff);
        this.m_metricsDiff = softwareSystemDiff.getUniqueExistingChild(MetricsDiff.class);
    }

    public boolean hasChanges() {
        return this.m_metricsDiff.getChange() != IDiffElement.Change.UNMODIFIED;
    }

    public List<MetricValueDiff> getValueDiffs() {
        List<MetricValueDiff> metricValues = this.removeUnmodifiedChildrenFromList(this.m_metricsDiff.getChildren(MetricValueDiff.class));
        Collections.sort(metricValues, new Comparator<MetricValueDiff>(){

            @Override
            public int compare(MetricValueDiff o1, MetricValueDiff o2) {
                return o1.getMetricPresentationName().compareTo(o2.getMetricPresentationName());
            }
        });
        return metricValues;
    }

    public String getCategories(MetricValueDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getCategories' must not be null";
        return diff.getCategoryPresentationNames().stream().collect(Collectors.joining(", "));
    }
}

